/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.ds.AssignLicenseConnectInfoValidateSpec;
import com.vmware.license.client.management.ds.AssignLicenseDecodeResult;
import com.vmware.license.client.management.ds.AssignLicenseDecodeSpec;
import com.vmware.license.client.management.ds.AssignLicenseUpdateSpec;
import com.vmware.license.client.management.ds.AssignLicenseValidateResultSpec;
import com.vmware.license.client.management.ds.AssignLicenseValidateSpec;
import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.ds.DecodeResult;
import com.vmware.license.client.management.ds.LicenseAssignmentError;
import com.vmware.license.client.management.ds.LicenseKey;
import com.vmware.license.client.management.ds.LicenseKeyCreateSpec;
import com.vmware.license.client.management.ds.LicenseKeyDecodeResult;
import com.vmware.license.client.management.ds.LicenseKeyDecodeSpec;
import com.vmware.license.client.management.ds.LicenseKeyRemoveSpec;
import com.vmware.license.client.management.ds.LicenseKeyUpdateLabelSpec;
import com.vmware.license.client.management.ds.LicenseSolutionRemoveSpec;
import com.vmware.license.client.management.editor.EntityType;
import com.vmware.license.client.management.editor.LicenseEditor;
import com.vmware.license.client.management.editor.LicenseEntityMutationException;
import com.vmware.license.client.management.editor.LicenseKeyMutationException;
import com.vmware.license.client.management.editor.LicenseRetrievalException;
import com.vmware.license.client.util.LicensePropertyUtil;
import com.vmware.license.client.util.LicenseUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.impl.vmodl.DataObjectImpl;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(LicenseMutationProvider.class);
    private LicenseEditor _licenseEditor;
    private LegacyAuthorizationService _authorizationService;

    public LicenseMutationProvider(LicenseEditor licenseEditor, LegacyAuthorizationService legacyAuthorizationService) {
        this._licenseEditor = licenseEditor;
        this._authorizationService = legacyAuthorizationService;
    }

    public OperationResult add(LicenseKeyCreateSpec licenseKeyCreateSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            LicenseKey licenseKey = this._licenseEditor.addLicense(licenseKeyCreateSpec.key, licenseKeyCreateSpec.labels, licenseKeyCreateSpec.scope);
            if (LicenseMutationProvider.isLicenseInvalid(licenseKey)) {
                operationResult.error = new MethodFault(ManagementUtil.getLocalizedString("error.invalidLicense"));
            } else {
                URI uRI = ManagementUtil.buildLicenseUri("LicenseKey", licenseKey.getLicenseKey(), licenseKeyCreateSpec.scope);
                operationResult.entity = uRI;
            }
            return operationResult;
        }
        catch (LicenseKeyMutationException licenseKeyMutationException) {
            _logger.error((Object)"Could not create license key", (Throwable)licenseKeyMutationException);
            operationResult.error = ManagementUtil.buildLicenseMethodFault(licenseKeyMutationException);
            return operationResult;
        }
    }

    public OperationResult remove(URI uRI, LicenseKeyRemoveSpec licenseKeyRemoveSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            this._licenseEditor.removeLicense(ManagementUtil.getLicenseUriValue(uRI), ManagementUtil.getLicenseUriScope(uRI));
            return operationResult;
        }
        catch (LicenseKeyMutationException licenseKeyMutationException) {
            _logger.error((Object)"Could not remove license key", (Throwable)licenseKeyMutationException);
            operationResult.error = ManagementUtil.buildLicenseMethodFault(licenseKeyMutationException);
            return operationResult;
        }
    }

    public OperationResult apply(URI uRI, LicenseKeyUpdateLabelSpec licenseKeyUpdateLabelSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            String string = ManagementUtil.getLicenseUriValue(uRI);
            String string2 = ManagementUtil.getLicenseUriScope(uRI);
            if (StringUtil.isNullOrEmpty((String)licenseKeyUpdateLabelSpec.labelValue)) {
                this._licenseEditor.removeLabel(string, licenseKeyUpdateLabelSpec.labelKey, string2);
            } else {
                this._licenseEditor.updateLabel(string, licenseKeyUpdateLabelSpec.labelKey, licenseKeyUpdateLabelSpec.labelValue, string2);
            }
            return operationResult;
        }
        catch (LicenseKeyMutationException licenseKeyMutationException) {
            _logger.error((Object)"Could not update license key label", (Throwable)licenseKeyMutationException);
            operationResult.error = ManagementUtil.buildLicenseMethodFault(licenseKeyMutationException);
            return operationResult;
        }
    }

    public ValidationResult[] validateMultiSpec(LicenseKeyDecodeSpec[] licenseKeyDecodeSpecArray) {
        LicenseKey[] licenseKeyArray;
        try {
            licenseKeyArray = this._licenseEditor.getLicenseKeys(licenseKeyDecodeSpecArray[0].scope, false);
        }
        catch (LicenseRetrievalException licenseRetrievalException) {
            return new ValidationResult[]{LicenseMutationProvider.getValidationError(licenseRetrievalException)};
        }
        ArrayList<ValidationResult> arrayList = new ArrayList<ValidationResult>();
        for (LicenseKeyDecodeSpec licenseKeyDecodeSpec : licenseKeyDecodeSpecArray) {
            arrayList.add(this.validateDecodeSpec(licenseKeyDecodeSpec, licenseKeyArray, licenseKeyDecodeSpec.scope));
        }
        return arrayList.toArray(new ValidationResult[arrayList.size()]);
    }

    public ValidationResult[] validateOnMultiEntity(Object[] objectArray, AssignLicenseValidateSpec assignLicenseValidateSpec) {
        try {
            if (objectArray.length <= 0) {
                throw new IllegalArgumentException("The entities array should not be empty");
            }
            LicenseKey[] licenseKeyArray = this._licenseEditor.getLicenseKeys(assignLicenseValidateSpec.scope, null);
            Assignment[] assignmentArray = this.retrieveAssignments(objectArray);
            return this.validateAssignLicense(assignmentArray, licenseKeyArray, true);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when validating license assignments", (Throwable)exception);
            return new ValidationResult[]{LicenseMutationProvider.getValidationError(exception)};
        }
    }

    public ValidationResult validate(ManagedObjectReference managedObjectReference, AssignLicenseConnectInfoValidateSpec assignLicenseConnectInfoValidateSpec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = managedObjectReference;
        try {
            ValidationResult validationResult2;
            if (assignLicenseConnectInfoValidateSpec.connectInfo == null || assignLicenseConnectInfoValidateSpec.scope == null) {
                throw new IllegalArgumentException("Connection information and scope should be provided");
            }
            Assignment assignment = LicensePropertyUtil.buildAssignment(assignLicenseConnectInfoValidateSpec.connectInfo);
            if (ManagementUtil.isLicensePrivilegeGranted(this._authorizationService, assignLicenseConnectInfoValidateSpec.scope)) {
                LicenseKey[] licenseKeyArray = this._licenseEditor.getLicenseKeys(assignLicenseConnectInfoValidateSpec.scope, null);
                boolean bl = LicenseMutationProvider.isEntityDlfVersionSupported(assignment, licenseKeyArray);
                ValidationResult[] validationResultArray = this.validateAssignLicense(new Assignment[]{assignment}, licenseKeyArray, bl);
                validationResult2 = validationResultArray[0];
            } else {
                validationResult2 = this.validateAssignLicenseNoPermissions(assignment);
            }
            validationResult.result = validationResult2.result;
            return validationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"Error during assign license validation", (Throwable)exception);
            validationResult.error = ManagementUtil.buildLicenseMethodFault(exception);
            return validationResult;
        }
    }

    public ValidationResult validate(AssignLicenseDecodeSpec assignLicenseDecodeSpec) {
        try {
            boolean bl;
            LicenseKey[] licenseKeyArray = this._licenseEditor.getLicenseKeys(assignLicenseDecodeSpec.scope, false);
            LicenseKeyDecodeResult licenseKeyDecodeResult = this.getLicenseKeyDecodeResult(assignLicenseDecodeSpec.licenseKey, licenseKeyArray, assignLicenseDecodeSpec.scope, assignLicenseDecodeSpec.assignemnts);
            AssignLicenseDecodeResult assignLicenseDecodeResult = new AssignLicenseDecodeResult();
            assignLicenseDecodeResult.licenseDecodeResult = licenseKeyDecodeResult;
            boolean bl2 = licenseKeyDecodeResult.decodedLicense.isSuiteLicense() && !licenseKeyDecodeResult.decodedLicense.isPrimarySuiteLicense();
            boolean bl3 = bl = licenseKeyDecodeResult.result == DecodeResult.OK || licenseKeyDecodeResult.result == DecodeResult.EXISTING;
            if (bl && !bl2) {
                assignLicenseDecodeResult.licenseAssignmentError = LicenseMutationProvider.getLicenseAssigmentError(assignLicenseDecodeSpec.assignemnts, licenseKeyDecodeResult.decodedLicense);
            }
            ValidationResult validationResult = new ValidationResult();
            validationResult.result = assignLicenseDecodeResult;
            return validationResult;
        }
        catch (LicenseKeyMutationException licenseKeyMutationException) {
            _logger.error((Object)"Could not decode the license key", (Throwable)licenseKeyMutationException);
            return LicenseMutationProvider.getValidationError(licenseKeyMutationException);
        }
        catch (LicenseRetrievalException licenseRetrievalException) {
            _logger.error((Object)"Could not retrieve license keys", (Throwable)licenseRetrievalException);
            return LicenseMutationProvider.getValidationError(licenseRetrievalException);
        }
    }

    public OperationResult apply(Object object, AssignLicenseUpdateSpec assignLicenseUpdateSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = object;
        try {
            String string;
            LicenseKey licenseKey;
            String string2;
            if (!ManagedObjectReference.class.isInstance(object) && !URI.class.isInstance(object)) {
                throw new IllegalArgumentException("The object should be either ManagedObjectRegerence or URI");
            }
            if (assignLicenseUpdateSpec.licenseKeyCreateSpec != null) {
                string2 = this.add(assignLicenseUpdateSpec.licenseKeyCreateSpec);
                if (((OperationResult)string2).error != null) {
                    operationResult.error = ((OperationResult)string2).error;
                    return operationResult;
                }
            }
            if (LicenseMutationProvider.isLicenseInvalid(licenseKey = this._licenseEditor.updateAssigedLicense(string2 = ManagementUtil.getEntityId(object), assignLicenseUpdateSpec.licenseKey, assignLicenseUpdateSpec.entityDisplayName, string = ManagementUtil.getEntityScope(object)))) {
                this._licenseEditor.removeAssignedLicense(string2, string);
                operationResult.error = new MethodFault(ManagementUtil.getLocalizedString("error.invalidLicense"));
            }
            operationResult.result = licenseKey;
            return operationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"Could not update license assignment", (Throwable)exception);
            operationResult.error = ManagementUtil.buildLicenseMethodFault(exception);
            return operationResult;
        }
    }

    public OperationResult remove(URI uRI, LicenseSolutionRemoveSpec licenseSolutionRemoveSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        try {
            this._licenseEditor.unregisterEntity(ManagementUtil.getLicenseUriValue(uRI), ManagementUtil.getLicenseUriScope(uRI));
            return operationResult;
        }
        catch (LicenseEntityMutationException licenseEntityMutationException) {
            _logger.error((Object)"Could not unregister license solution", (Throwable)licenseEntityMutationException);
            operationResult.error = ManagementUtil.buildLicenseMethodFault(licenseEntityMutationException);
            return operationResult;
        }
    }

    private ValidationResult[] validateAssignLicense(Assignment[] assignmentArray, LicenseKey[] licenseKeyArray, boolean bl) {
        ArrayList<LicenseKey> arrayList = new ArrayList<LicenseKey>();
        ArrayList<LicenseKey> arrayList2 = new ArrayList<LicenseKey>();
        for (LicenseKey licenseKey : licenseKeyArray) {
            LicenseKey licenseKey2 = LicenseMutationProvider.getLicenseAvailableForAssignment(assignmentArray, licenseKey);
            if (licenseKey2 == null || bl && !LicenseMutationProvider.areEntitiesDlfVersionSupported(assignmentArray, licenseKey2)) continue;
            if (LicenseMutationProvider.isLicenseAssignable(assignmentArray, licenseKey2) != LicenseAssignmentError.None) {
                arrayList2.add(licenseKey2);
                continue;
            }
            arrayList.add(licenseKey2);
        }
        AssignLicenseValidateResultSpec assignLicenseValidateResultSpec = new AssignLicenseValidateResultSpec();
        assignLicenseValidateResultSpec.assignments = assignmentArray;
        assignLicenseValidateResultSpec.assignableLicenses = arrayList.toArray(new LicenseKey[arrayList.size()]);
        assignLicenseValidateResultSpec.unassignableLicenses = arrayList2.toArray(new LicenseKey[arrayList2.size()]);
        assignLicenseValidateResultSpec.areLicensesFilteredByDlfVersion = bl;
        ValidationResult validationResult = new ValidationResult();
        validationResult.result = assignLicenseValidateResultSpec;
        return new ValidationResult[]{validationResult};
    }

    private ValidationResult validateAssignLicenseNoPermissions(Assignment assignment) {
        DataObjectImpl dataObjectImpl;
        ArrayList<DataObjectImpl> arrayList = new ArrayList<DataObjectImpl>();
        ArrayList<DataObjectImpl> arrayList2 = new ArrayList<DataObjectImpl>();
        if (!assignment.getLicenseKey().isEvaluation()) {
            dataObjectImpl = LicensePropertyUtil.buildEvaluationLicenseKey();
            if (LicenseMutationProvider.canSwitchToEvaluation(new Assignment[]{assignment})) {
                arrayList.add(dataObjectImpl);
            } else {
                arrayList2.add(dataObjectImpl);
            }
        }
        dataObjectImpl = new AssignLicenseValidateResultSpec();
        dataObjectImpl.assignments = new Assignment[]{assignment};
        dataObjectImpl.assignableLicenses = arrayList.toArray(new LicenseKey[arrayList.size()]);
        dataObjectImpl.unassignableLicenses = arrayList2.toArray(new LicenseKey[arrayList2.size()]);
        ValidationResult validationResult = new ValidationResult();
        validationResult.result = dataObjectImpl;
        return validationResult;
    }

    private ValidationResult validateDecodeSpec(LicenseKeyDecodeSpec licenseKeyDecodeSpec, LicenseKey[] licenseKeyArray, String string) {
        ValidationResult validationResult = new ValidationResult();
        try {
            validationResult.result = this.getLicenseKeyDecodeResult(licenseKeyDecodeSpec.licenseKey, licenseKeyArray, string, null);
            return validationResult;
        }
        catch (LicenseKeyMutationException licenseKeyMutationException) {
            _logger.error((Object)"Could not decode the license key", (Throwable)licenseKeyMutationException);
            validationResult.error = ManagementUtil.buildLicenseMethodFault(licenseKeyMutationException);
            return validationResult;
        }
    }

    private LicenseKeyDecodeResult getLicenseKeyDecodeResult(String string, LicenseKey[] licenseKeyArray, String string2, Assignment[] assignmentArray) throws LicenseKeyMutationException {
        Object object;
        boolean bl;
        Object object2 = LicenseMutationProvider.getExistingLicense(string, licenseKeyArray);
        boolean bl2 = bl = object2 != null;
        if (!bl) {
            object2 = this._licenseEditor.decodeLicense(string, string2);
        }
        if (assignmentArray != null && object2.isPrimarySuiteLicense() && (object = LicenseMutationProvider.getLicenseAvailableForAssignment(assignmentArray, object2)) != null) {
            object2 = object;
        }
        object = LicenseMutationProvider.getLicenseDecodeResult(object2, bl);
        LicenseKeyDecodeResult licenseKeyDecodeResult = new LicenseKeyDecodeResult();
        licenseKeyDecodeResult.licenseKey = string;
        licenseKeyDecodeResult.decodedLicense = object2;
        licenseKeyDecodeResult.result = object;
        licenseKeyDecodeResult.errorMessage = LicensePropertyUtil.getErrorMessage(VimSessionUtil.getService((String)string2), object2);
        return licenseKeyDecodeResult;
    }

    private static ValidationResult getValidationError(Exception exception) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.error = ManagementUtil.buildLicenseMethodFault(exception);
        return validationResult;
    }

    private static DecodeResult getLicenseDecodeResult(LicenseKey licenseKey, boolean bl) {
        if (bl) {
            return DecodeResult.EXISTING;
        }
        if (LicenseMutationProvider.isLicenseInvalid(licenseKey)) {
            return DecodeResult.INVALID;
        }
        if (LicenseMutationProvider.isLicenseExpired(licenseKey)) {
            return DecodeResult.EXPIRED;
        }
        return DecodeResult.OK;
    }

    private static boolean isLicenseInvalid(LicenseKey licenseKey) {
        if (licenseKey == null || StringUtil.isNullOrEmpty((String)licenseKey.getLicenseKey())) {
            return true;
        }
        return licenseKey.isInvalid();
    }

    private static boolean isLicenseExpired(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return false;
        }
        return licenseKey.getExpirationTime() == null ? false : licenseKey.getExpirationTime() <= 0L;
    }

    private static boolean isLicenseWithCapacityRestriction(LicenseKey licenseKey) {
        return !licenseKey.isUnlimitedCapacity() && EntityType.HOST.equals((Object)licenseKey.getEntityType()) && LicenseUtil.isCpuCostUnit(licenseKey.getCostUnit());
    }

    private static LicenseKey getExistingLicense(String string, LicenseKey[] licenseKeyArray) {
        if (licenseKeyArray == null) {
            return null;
        }
        for (LicenseKey licenseKey : licenseKeyArray) {
            if (!licenseKey.getLicenseKey().equals(string)) continue;
            return licenseKey;
        }
        return null;
    }

    private static LicenseAssignmentError isLicenseAvailableForAssignment(Assignment[] assignmentArray, LicenseKey licenseKey) {
        if (licenseKey.isEvaluation()) {
            return LicenseAssignmentError.None;
        }
        if (licenseKey.getProductName() == null || licenseKey.getProductVersion() == null) {
            return LicenseAssignmentError.NoProductInLicense;
        }
        for (Assignment assignment : assignmentArray) {
            if (!licenseKey.getProductName().equals(assignment.getProductName())) {
                return LicenseAssignmentError.ProductNameDoesNotMatch;
            }
            if (licenseKey.getProductVersion().equals(assignment.getProductVersion())) continue;
            return LicenseAssignmentError.ProductVersionDoesNotMatch;
        }
        return LicenseAssignmentError.None;
    }

    private static boolean isEntityDlfVersionSupported(Assignment assignment, LicenseKey[] licenseKeyArray) {
        if (assignment.getDlfVersion() == null) {
            return true;
        }
        if (licenseKeyArray == null) {
            return false;
        }
        for (LicenseKey licenseKey : licenseKeyArray) {
            if (licenseKey.getProductName() == null || licenseKey.getProductVersion() == null || !licenseKey.getProductName().equals(assignment.getProductName()) || !licenseKey.getProductVersion().equals(assignment.getProductVersion()) || !LicenseMutationProvider.checkLicenseForDlfVersion(licenseKey, assignment.getDlfVersion())) continue;
            return true;
        }
        return false;
    }

    private static boolean areEntitiesDlfVersionSupported(Assignment[] assignmentArray, LicenseKey licenseKey) {
        if (licenseKey.isEvaluation()) {
            return true;
        }
        for (Assignment assignment : assignmentArray) {
            if (LicenseMutationProvider.checkLicenseForDlfVersion(licenseKey, assignment.getDlfVersion())) continue;
            return false;
        }
        return true;
    }

    private static boolean checkLicenseForDlfVersion(LicenseKey licenseKey, String string) {
        if (licenseKey == null) {
            return false;
        }
        if (string == null) {
            return true;
        }
        if (string.equals(licenseKey.getDlfVersion())) {
            return true;
        }
        for (String string2 : licenseKey.getLicenseVersions()) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private static LicenseAssignmentError isLicenseAssignable(Assignment[] assignmentArray, LicenseKey licenseKey) {
        if (licenseKey.isEvaluation() && !LicenseMutationProvider.canSwitchToEvaluation(assignmentArray)) {
            return LicenseAssignmentError.ExpiredEvaluation;
        }
        if (LicenseMutationProvider.isLicenseExpired(licenseKey)) {
            return LicenseAssignmentError.ExpiredLicense;
        }
        if (LicenseMutationProvider.isLicenseWithCapacityRestriction(licenseKey)) {
            double d;
            double d2 = LicenseMutationProvider.getCombinedEntityCost(assignmentArray, licenseKey);
            double d3 = d = licenseKey.getUsed() == null ? 0.0 : (double)licenseKey.getUsed().intValue();
            if (d2 > (double)licenseKey.getTotal() - d) {
                return LicenseAssignmentError.UnsufficientCapacity;
            }
        }
        return LicenseAssignmentError.None;
    }

    private static double getCombinedEntityCost(Assignment[] assignmentArray, LicenseKey licenseKey) {
        double d = 0.0;
        for (Assignment assignment : assignmentArray) {
            if (assignment.getLicenseKey().getLicenseKey().equals(licenseKey.getLicenseKey())) continue;
            double d2 = assignment.getEntityUsage() == null ? 0.0 : (double)assignment.getEntityUsage().intValue();
            d += d2;
        }
        return d;
    }

    private static boolean canSwitchToEvaluation(Assignment[] assignmentArray) {
        for (Assignment assignment : assignmentArray) {
            Long l = assignment.getEvalExpirationTime();
            if (l == null || l > 0L) continue;
            return false;
        }
        return true;
    }

    private Assignment[] retrieveAssignments(Object[] objectArray) throws LicenseRetrievalException {
        if (objectArray.length == 0) {
            return new Assignment[0];
        }
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        if (objectArray.length == 1) {
            Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(ManagementUtil.getEntityId(objectArray[0]), ManagementUtil.getEntityScope(objectArray[0]), null);
            if (ArrayUtil.isNullOrEmpty((Object[])assignmentArray)) {
                ManagementUtil.reportNotExistingObject();
            }
            arrayList.add(assignmentArray[0]);
        } else {
            Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(null, ManagementUtil.getEntityScope(objectArray[0]), null);
            Map<String, Assignment> map = LicensePropertyUtil.groupAssignmentsByEntityIdentifier(assignmentArray);
            for (Object object : objectArray) {
                Assignment assignment = LicensePropertyUtil.getAssignmentForEntity(map, object);
                if (assignment == null) {
                    if (object instanceof ManagedObjectReference && ManagementUtil.isCluster((ManagedObjectReference)object)) {
                        String string = ManagementUtil.getLocalizedString("error.assignLicense.clustersNotRegistered");
                        throw new RuntimeException(string);
                    }
                    ManagementUtil.reportNotExistingObjects();
                }
                arrayList.add(assignment);
            }
        }
        return arrayList.toArray(new Assignment[arrayList.size()]);
    }

    private static LicenseAssignmentError getLicenseAssigmentError(Assignment[] assignmentArray, LicenseKey licenseKey) {
        LicenseAssignmentError licenseAssignmentError = LicenseMutationProvider.isLicenseAvailableForAssignment(assignmentArray, licenseKey);
        if (licenseAssignmentError != LicenseAssignmentError.None) {
            return licenseAssignmentError;
        }
        return LicenseMutationProvider.isLicenseAssignable(assignmentArray, licenseKey);
    }

    private static LicenseKey getLicenseAvailableForAssignment(Assignment[] assignmentArray, LicenseKey licenseKey) {
        Assignment assignment;
        if (assignmentArray == null || licenseKey == null) {
            return null;
        }
        ArrayList<LicenseKey> arrayList = new ArrayList<LicenseKey>();
        arrayList.add(licenseKey);
        if (licenseKey.isPrimarySuiteLicense()) {
            arrayList.addAll(Arrays.asList(licenseKey.getSecondarySuiteLicenses()));
        }
        LicenseKey licenseKey2 = null;
        Assignment[] assignmentArray2 = assignmentArray;
        int n = assignmentArray2.length;
        for (int i = 0; i < n && (licenseKey2 = LicenseMutationProvider.getLicenseAvailableForAssignment(arrayList, assignment = assignmentArray2[i])) != null; ++i) {
        }
        return licenseKey2;
    }

    private static LicenseKey getLicenseAvailableForAssignment(List<LicenseKey> list, Assignment assignment) {
        if (assignment == null || list == null) {
            return null;
        }
        Assignment[] assignmentArray = new Assignment[]{assignment};
        for (LicenseKey licenseKey : list) {
            if (LicenseMutationProvider.isLicenseAvailableForAssignment(assignmentArray, licenseKey) != LicenseAssignmentError.None) continue;
            return licenseKey;
        }
        return null;
    }
}

