/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.adapter;

import com.vmware.license.client.management.adapter.BaseLicensePropertyProvider;
import com.vmware.license.client.management.adapter.LicenseCollectUriException;
import com.vmware.license.client.management.adapter.LicenseProductPropertyProvider;
import com.vmware.license.client.management.adapter.LicenseProviderInitializationException;
import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.editor.EntityType;
import com.vmware.license.client.management.editor.LicenseEditor;
import com.vmware.license.client.management.editor.LicenseRetrievalException;
import com.vmware.license.client.util.LicensePropertyUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.core.model.NumberDataObject;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.StringUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseSolutionPropertyProvider
extends BaseLicensePropertyProvider {
    private static final String LICENSE_ENTITY_PROPERTY = "licenseEntity";
    HashMap<String, Assignment> _solutionsByUriValue = null;
    private LicenseEditor _licenseEditor;
    private Log _logger = LogFactory.getLog(LicenseProductPropertyProvider.class);

    public LicenseSolutionPropertyProvider(LicenseEditor licenseEditor) {
        this._licenseEditor = licenseEditor;
    }

    @type(value="LicenseSolution")
    public boolean getIsRegisteredForLicensing(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return LicensePropertyUtil.isEntityRegisteredForLicensing(assignment);
    }

    @type(value="LicenseSolution")
    public String getName(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getEntityDisplayName();
    }

    @type(value="LicenseSolution")
    public String getLicenseKeyString(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getLicenseKey().getLicenseKey();
    }

    @type(value="LicenseSolution")
    public String getLicenseProductKeyString(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getLicenseKey().getProductKey();
    }

    @type(value="LicenseSolution")
    public String getLicenseProductNameString(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getLicenseKey().getProductName();
    }

    @type(value="LicenseSolution")
    public String getLicenseCostUnitString(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getLicenseKey().getCostUnit();
    }

    @type(value="LicenseSolution")
    public NumberDataObject getLicenseUsage(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return ManagementUtil.createNumberDataObject(assignment.getEntityUsage());
    }

    @type(value="LicenseSolution")
    public KeyAnyValue[] getLicenseProperties(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getProperties();
    }

    @type(value="LicenseSolution")
    public boolean getLicenseIsInEvaluation(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getLicenseKey().isEvaluation();
    }

    @type(value="LicenseSolution")
    public String getLicenseFormattedKeyString(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getLicenseKey().getFormattedLicenseKey();
    }

    @type(value="LicenseSolution")
    public String getLicenseFormattedProductNameString(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getLicenseKey().getFormattedProductName();
    }

    @type(value="LicenseSolution")
    public NumberDataObject getLicenseExpirationTime(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return ManagementUtil.createNumberDataObject(LicensePropertyUtil.getExpirationTime(assignment));
    }

    @type(value="LicenseSolution")
    public String getLicenseFormattedExpirationDate(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return LicensePropertyUtil.getFormattedExpirationDate(LicensePropertyUtil.getExpirationTime(assignment));
    }

    @type(value="LicenseSolution")
    public String getLicenseFormattedUsage(URI uRI) {
        Assignment assignment = this.retrieveLicenseSolution(uRI);
        return assignment.getFormattedEntityUsage();
    }

    @Override
    protected void refreshData() throws LicenseProviderInitializationException {
        if (this._solutionsByUriValue != null) {
            this._solutionsByUriValue.clear();
            this._solutionsByUriValue = null;
        }
        try {
            Assignment[] assignmentArray = this._licenseEditor.getLicenseAssignments(null, this._scope, this._forceRefresh);
            this._solutionsByUriValue = this.getSolutions(assignmentArray);
        }
        catch (LicenseRetrievalException licenseRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error initializing LicenseSolutionPropertyProvider ", (Throwable)licenseRetrievalException);
            }
            throw new LicenseProviderInitializationException(licenseRetrievalException);
        }
    }

    @Override
    protected URI[] getAllUriObjects() {
        if (this._solutionsByUriValue == null || this._solutionsByUriValue.isEmpty()) {
            return new URI[0];
        }
        ArrayList<URI> arrayList = new ArrayList<URI>(this._solutionsByUriValue.size());
        Collection<Assignment> collection = this._solutionsByUriValue.values();
        for (Assignment assignment : collection) {
            URI uRI = ManagementUtil.buildLicenseUri("LicenseSolution", assignment.getEntityId(), this._scope);
            arrayList.add(uRI);
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    @Override
    protected URI[] getRelatedUriObjects(Object object, String string) throws LicenseCollectUriException {
        ArrayList<URI> arrayList;
        block5: {
            Collection<Assignment> collection;
            String string2;
            String string3;
            String string4;
            block4: {
                if (object == null || StringUtil.isNullOrEmpty((String)string) || this._solutionsByUriValue == null || this._solutionsByUriValue.isEmpty()) {
                    return new URI[0];
                }
                if (!URI.class.isInstance(object) || !LICENSE_ENTITY_PROPERTY.equals(string)) {
                    return new URI[0];
                }
                URI uRI = (URI)object;
                string4 = DefaultUriSchemeUtil.getType((URI)uRI);
                string3 = ManagementUtil.getLicenseUriValue(uRI);
                string2 = ManagementUtil.getLicenseUriScope(uRI);
                arrayList = new ArrayList<URI>();
                collection = this._solutionsByUriValue.values();
                if (!"LicenseKey".equals(string4)) break block4;
                for (Assignment assignment : collection) {
                    if (!string3.equals(assignment.getLicenseKey().getLicenseKey())) continue;
                    URI uRI2 = LicenseSolutionPropertyProvider.buildLicenseSolutionUri(assignment.getEntityId(), string2);
                    arrayList.add(uRI2);
                }
                break block5;
            }
            if (!"LicenseProduct".equals(string4)) break block5;
            for (Assignment assignment : collection) {
                if (!string3.equals(assignment.getLicenseKey().getProductKey())) continue;
                URI uRI = LicenseSolutionPropertyProvider.buildLicenseSolutionUri(assignment.getEntityId(), string2);
                arrayList.add(uRI);
            }
        }
        return arrayList.toArray(new URI[arrayList.size()]);
    }

    @Override
    protected String getProvidedType() {
        return "LicenseSolution";
    }

    @Override
    protected void validateObjectsExistence(URI[] uRIArray) {
        Set<String> set;
        Set<String> set2 = set = this._solutionsByUriValue == null ? null : this._solutionsByUriValue.keySet();
        if (!ManagementUtil.doesSetContainLicenseUriValuesForUris(set, uRIArray)) {
            ManagementUtil.reportNotExistingObject();
        }
    }

    private Assignment retrieveLicenseSolution(URI uRI) {
        Assignment assignment = this._solutionsByUriValue.get(ManagementUtil.getLicenseUriValue(uRI));
        assert (assignment != null) : "license solution not found for uri: " + uRI;
        return assignment;
    }

    private static URI buildLicenseSolutionUri(String string, String string2) {
        return ManagementUtil.buildLicenseUri("LicenseSolution", string, string2);
    }

    private HashMap<String, Assignment> getSolutions(Assignment[] assignmentArray) {
        HashMap<String, Assignment> hashMap = new HashMap<String, Assignment>();
        for (Assignment assignment : assignmentArray) {
            if (EntityType.SOLUTION != assignment.getEntityType()) continue;
            hashMap.put(assignment.getEntityId(), assignment);
        }
        return hashMap;
    }
}

