/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.management.editor.impl;

import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.ds.LicenseKey;
import com.vmware.license.client.management.editor.AssignmentRetrievalException;
import com.vmware.license.client.management.editor.LicenseEditor;
import com.vmware.license.client.management.editor.LicenseEntityMutationException;
import com.vmware.license.client.management.editor.LicenseKeyMutationException;
import com.vmware.license.client.management.editor.LicenseKeyRetrievalException;
import com.vmware.license.client.management.editor.LicenseManagerRetrievalException;
import com.vmware.license.client.management.editor.LicenseRetrievalException;
import com.vmware.license.client.util.LicensePropertyUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.license.client.vc.LinkedVcGroupProvider;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.LicenseAssignmentManager;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.vim.commons.cache.BoundedSessionCache;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseEditorImpl
implements LicenseEditor {
    private static final String SESSION_DATA_SYNC_KEY = "com.vmware.license.client.management.editor.impl.SESSION_DATA_SYNC_KEY";
    private static final String LICENSES_CACHE_KEY = "licenseCacheKey";
    private static final String ASSIGNMENTS_CACHE_KEY = "assignmentsCacheKey";
    private static final String[] CACHE_KEYS = new String[]{"licenseCacheKey", "assignmentsCacheKey"};
    private LinkedVcGroupProvider _linkedVcGroupProvider;
    private BoundedSessionCache _licenseDataCache;
    private Log _logger = LogFactory.getLog(LicenseEditorImpl.class);

    public LicenseEditorImpl(LinkedVcGroupProvider linkedVcGroupProvider, BoundedSessionCache boundedSessionCache) {
        this._linkedVcGroupProvider = linkedVcGroupProvider;
        this._licenseDataCache = boundedSessionCache;
    }

    @Override
    public LicenseKey[] getLicenseKeys(String string, Boolean bl) throws LicenseRetrievalException {
        if (!Boolean.FALSE.equals(bl)) {
            this.clearLicenseDataCache();
        }
        LicenseManager.LicenseInfo[] licenseInfoArray = this.getLicenseInfos(string, bl);
        Set<String> set = this.getAssignedLicenseKeySet(string, bl);
        boolean bl2 = false;
        ArrayList<LicenseKey> arrayList = new ArrayList<LicenseKey>();
        for (LicenseManager.LicenseInfo licenseInfo : licenseInfoArray) {
            boolean bl3 = set.contains(licenseInfo.licenseKey);
            LicenseKey licenseKey = LicensePropertyUtil.buildLicenseKey(licenseInfo, bl3);
            arrayList.add(licenseKey);
            if (!licenseKey.isEvaluation()) continue;
            bl2 = true;
        }
        if (!bl2) {
            arrayList.add(LicensePropertyUtil.buildEvaluationLicenseKey());
        }
        return arrayList.toArray(new LicenseKey[arrayList.size()]);
    }

    @Override
    public Assignment[] getLicenseAssignments(String string, String string2, Boolean bl) throws LicenseRetrievalException {
        if (!Boolean.FALSE.equals(bl)) {
            this.clearLicenseDataCache();
        }
        LicenseAssignmentManager.LicenseAssignment[] licenseAssignmentArray = this.getAssignments(string, string2, bl);
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        for (LicenseAssignmentManager.LicenseAssignment licenseAssignment : licenseAssignmentArray) {
            arrayList.add(LicensePropertyUtil.buildAssignment(licenseAssignment));
        }
        return arrayList.toArray(new Assignment[arrayList.size()]);
    }

    @Override
    public LicenseKey addLicense(String string, KeyValue[] keyValueArray, String string2) throws LicenseKeyMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseManager(string2).addLicense(string, keyValueArray, (Future)blockingFuture);
            LicenseManager.LicenseInfo licenseInfo = (LicenseManager.LicenseInfo)blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
            return LicensePropertyUtil.buildLicenseKey(licenseInfo, false);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error adding license key: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.createLicense"), throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error adding license key: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.createLicense"), interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error adding license key: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.createLicense"), timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error adding license key: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.createLicense"), licenseManagerRetrievalException);
        }
    }

    @Override
    public LicenseKey decodeLicense(String string, String string2) throws LicenseKeyMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseManager(string2).decodeLicense(string, (Future)blockingFuture);
            LicenseManager.LicenseInfo licenseInfo = (LicenseManager.LicenseInfo)blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
            return LicensePropertyUtil.buildLicenseKey(licenseInfo, false);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error decoding license key: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.decodeLicense"), throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error decoding license key: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.decodeLicense"), interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error decoding license key: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.decodeLicense"), timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error decoding license key: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.decodeLicense"), licenseManagerRetrievalException);
        }
    }

    @Override
    public void removeLicense(String string, String string2) throws LicenseKeyMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseManager(string2).removeLicense(string, (Future)blockingFuture);
            blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicense"), throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicense"), interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicense"), timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicense"), licenseManagerRetrievalException);
        }
    }

    @Override
    public void updateLabel(String string, String string2, String string3, String string4) throws LicenseKeyMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseManager(string4).updateLabel(string, string2, string3, (Future)blockingFuture);
            blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error updating license key label: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.udateLicenseLabel"), throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error updating license key label: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.udateLicenseLabel"), interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error updating license key label: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.udateLicenseLabel"), timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error updating license key label: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.udateLicenseLabel"), licenseManagerRetrievalException);
        }
    }

    @Override
    public void removeLabel(String string, String string2, String string3) throws LicenseKeyMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseManager(string3).removeLabel(string, string2, (Future)blockingFuture);
            blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicenseLabel"), throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicenseLabel"), interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicenseLabel"), timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license key label: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeLicenseLabel"), licenseManagerRetrievalException);
        }
    }

    @Override
    public LicenseKey updateAssigedLicense(String string, String string2, String string3, String string4) throws LicenseKeyMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseAssignmentManager(string4).updateAssignedLicense(string, string2, string3, (Future)blockingFuture);
            LicenseManager.LicenseInfo licenseInfo = (LicenseManager.LicenseInfo)blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
            return LicensePropertyUtil.buildLicenseKey(licenseInfo, true);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error assigning license: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.updateAssignment"), throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error assigning license: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.updateAssignment"), interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error assigning license: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.updateAssignment"), timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error assigning license: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.updateAssignment"), licenseManagerRetrievalException);
        }
    }

    @Override
    public void removeAssignedLicense(String string, String string2) throws LicenseKeyMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseAssignmentManager(string2).removeAssignedLicense(string, (Future)blockingFuture);
            blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license assignment: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeAssignment"), throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license assignment: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeAssignment"), interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license assignment: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeAssignment"), timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error removing license assignment: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyMutationException(ManagementUtil.getLocalizedString("error.removeAssignment"), licenseManagerRetrievalException);
        }
    }

    @Override
    public void unregisterEntity(String string, String string2) throws LicenseEntityMutationException {
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseAssignmentManager(string2).unregisterEntity(string, (Future)blockingFuture);
            blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error unregistering license entity: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseEntityMutationException(throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error unregistering license entity: ", (Throwable)interruptedException);
            }
            throw new LicenseEntityMutationException(interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error unregistering license entity: ", (Throwable)timeoutException);
            }
            throw new LicenseEntityMutationException(timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error unregistering license entity: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseEntityMutationException(licenseManagerRetrievalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getLicenseData(String string, Boolean bl, String string2, LicenseDataRetriever<T> licenseDataRetriever) throws LicenseRetrievalException {
        Object object;
        if (bl == null) {
            return licenseDataRetriever == null ? null : (T)licenseDataRetriever.getData(string);
        }
        Object object2 = null;
        Object object3 = object = this._licenseDataCache.getSyncObject(SESSION_DATA_SYNC_KEY);
        synchronized (object3) {
            if (!bl.booleanValue()) {
                object2 = this._licenseDataCache.getData(string2);
            }
            if (object2 == null) {
                object2 = licenseDataRetriever.getData(string);
                this._licenseDataCache.setData(string2, object2);
            }
        }
        return (T)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLicenseDataCache() {
        Object object;
        Object object2 = object = this._licenseDataCache.getSyncObject(SESSION_DATA_SYNC_KEY);
        synchronized (object2) {
            for (String string : CACHE_KEYS) {
                this._licenseDataCache.removeData(string);
            }
        }
    }

    private synchronized LicenseManager retrieveLicenseManager(String string) throws LicenseManagerRetrievalException {
        try {
            LinkedVcGroup linkedVcGroup = this._linkedVcGroupProvider.getLinkedVcGroup(string);
            VcService vcService = linkedVcGroup.getVcService(string);
            ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
            ManagedObjectReference managedObjectReference = serviceInstanceContent.licenseManager;
            return (LicenseManager)linkedVcGroup.getManagedObject(managedObjectReference);
        }
        catch (Exception exception) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving LicenseManager: ", (Throwable)exception);
            }
            throw new LicenseManagerRetrievalException(exception);
        }
    }

    private synchronized LicenseAssignmentManager retrieveLicenseAssignmentManager(String string) throws LicenseManagerRetrievalException {
        try {
            ManagedObjectReference managedObjectReference = this.retrieveLicenseManager(string).getLicenseAssignmentManager();
            LinkedVcGroup linkedVcGroup = this._linkedVcGroupProvider.getLinkedVcGroup(string);
            return (LicenseAssignmentManager)linkedVcGroup.getManagedObject(managedObjectReference);
        }
        catch (Exception exception) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving LicenseAssignmentManager: ", (Throwable)exception);
            }
            throw new LicenseManagerRetrievalException(exception);
        }
    }

    private LicenseManager.LicenseInfo[] getLicenseInfos(String string, Boolean bl) throws LicenseRetrievalException {
        LicenseManager.LicenseInfo[] licenseInfoArray = this.getLicenseData(string, bl, LICENSES_CACHE_KEY, new LicenseDataRetriever<LicenseManager.LicenseInfo[]>(){

            @Override
            public LicenseManager.LicenseInfo[] getData(String string) throws LicenseKeyRetrievalException {
                return LicenseEditorImpl.this.getCurrentLicenseInfos(string);
            }
        });
        return licenseInfoArray == null ? new LicenseManager.LicenseInfo[]{} : licenseInfoArray;
    }

    private LicenseManager.LicenseInfo[] getCurrentLicenseInfos(String string) throws LicenseKeyRetrievalException {
        LicenseManager.LicenseInfo[] licenseInfoArray;
        try {
            BlockingFuture blockingFuture = new BlockingFuture();
            this.retrieveLicenseManager(string).getLicenses((Future)blockingFuture);
            licenseInfoArray = (LicenseManager.LicenseInfo[])blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving license keys: ", (Throwable)executionException);
            }
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            throw new LicenseKeyRetrievalException(throwable);
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving license keys: ", (Throwable)interruptedException);
            }
            throw new LicenseKeyRetrievalException(interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving license keys: ", (Throwable)timeoutException);
            }
            throw new LicenseKeyRetrievalException(timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving license keys: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new LicenseKeyRetrievalException(licenseManagerRetrievalException);
        }
        return licenseInfoArray == null ? new LicenseManager.LicenseInfo[]{} : licenseInfoArray;
    }

    private LicenseAssignmentManager.LicenseAssignment[] getAssignments(String string, String string2, Boolean bl) throws LicenseRetrievalException {
        LicenseAssignmentManager.LicenseAssignment[] licenseAssignmentArray = string != null ? this.getCurrentAssignments(string, string2) : this.getLicenseData(string2, bl, ASSIGNMENTS_CACHE_KEY, new LicenseDataRetriever<LicenseAssignmentManager.LicenseAssignment[]>(){

            @Override
            public LicenseAssignmentManager.LicenseAssignment[] getData(String string) throws AssignmentRetrievalException {
                return LicenseEditorImpl.this.getCurrentAssignments(null, string);
            }
        });
        return licenseAssignmentArray == null ? new LicenseAssignmentManager.LicenseAssignment[]{} : licenseAssignmentArray;
    }

    private LicenseAssignmentManager.LicenseAssignment[] getCurrentAssignments(String string, String string2) throws AssignmentRetrievalException {
        LicenseAssignmentManager.LicenseAssignment[] licenseAssignmentArray = null;
        BlockingFuture blockingFuture = new BlockingFuture();
        try {
            this.retrieveLicenseAssignmentManager(string2).queryAssignedLicenses(string, (Future)blockingFuture);
            licenseAssignmentArray = (LicenseAssignmentManager.LicenseAssignment[])blockingFuture.get(180000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException;
            if (executionException.getCause() != null) {
                throwable = executionException.getCause();
            }
            if (!this.isEntityNotRegisteredError(string, throwable)) {
                if (this._logger.isErrorEnabled()) {
                    this._logger.error((Object)"Error retrieving license assignments: ", (Throwable)executionException);
                }
                throw new AssignmentRetrievalException(throwable);
            }
        }
        catch (InterruptedException interruptedException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving license assignments: ", (Throwable)interruptedException);
            }
            throw new AssignmentRetrievalException(interruptedException);
        }
        catch (TimeoutException timeoutException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving license assignments: ", (Throwable)timeoutException);
            }
            throw new AssignmentRetrievalException(timeoutException);
        }
        catch (LicenseManagerRetrievalException licenseManagerRetrievalException) {
            if (this._logger.isErrorEnabled()) {
                this._logger.error((Object)"Error retrieving license assignments: ", (Throwable)licenseManagerRetrievalException);
            }
            throw new AssignmentRetrievalException(licenseManagerRetrievalException);
        }
        return licenseAssignmentArray == null ? new LicenseAssignmentManager.LicenseAssignment[]{} : licenseAssignmentArray;
    }

    private boolean isEntityNotRegisteredError(String string, Throwable throwable) {
        return string != null && throwable instanceof SystemError;
    }

    private Set<String> getAssignedLicenseKeySet(String string, Boolean bl) throws LicenseRetrievalException {
        LicenseAssignmentManager.LicenseAssignment[] licenseAssignmentArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (LicenseAssignmentManager.LicenseAssignment licenseAssignment : licenseAssignmentArray = this.getAssignments(null, string, bl)) {
            String string2 = licenseAssignment.assignedLicense.licenseKey;
            hashSet.add(string2);
        }
        return hashSet;
    }

    private static interface LicenseDataRetriever<T> {
        public T getData(String var1) throws LicenseRetrievalException;
    }
}

