/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.util;

import com.vmware.license.client.management.ds.Assignment;
import com.vmware.license.client.management.ds.LicenseKey;
import com.vmware.license.client.management.editor.EntityType;
import com.vmware.license.client.util.DateUtil;
import com.vmware.license.client.util.LicenseUtil;
import com.vmware.license.client.util.ManagementUtil;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.LicenseAssignmentManager;
import com.vmware.vim.binding.vim.LicenseManager;
import com.vmware.vim.binding.vim.host.ConnectInfo;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LicensePropertyUtil {
    private static final String PROPERTY_KEY_LICENSE_INFO = "LicenseInfo";
    private static final String EXPIRATION_HOURS_KEY = "expirationHours";
    private static final String EXPIRATION_MINUTES_KEY = "expirationMinutes";
    private static final String EXPIRATION_DATE_KEY = "expirationDate";
    private static final String SYSTEM_TIME_KEY = "system_time";
    private static final String PROPERTY_KEY_PRODUCT_NAME = "ProductName";
    private static final String PROPERTY_KEY_PRODUCT_VERSION = "ProductVersion";
    private static final String PROPERTY_KEY_DLF_FILE_VERSION = "FileVersion";
    private static final String PROPERTY_KEY_LI_ERROR = "lc_error";
    private static final String PROPERTY_KEY_LICENSE_NO_SET = "license_not_set";
    private static final String PROPERTY_KEY_SUITE_LICENSE = "suiteLicense";
    private static final String PROPERTY_VALUE_PRIMARY_SUITE_LICENSE = "primary";
    private static final String PROPERTY_KEY_SUITE_LICENSE_INFO = "SuiteLicenseInfo";
    private static String PROPERTY_KEY_MAX_SSD_PER_HOST = "maxSSDPerHost";
    private static final String LICENSE_ASSIGNMENT_PROPERTY_KEY_EVALUATION = "Evaluation";
    private static final String PROPERTY_KEY_DIAGNOSTIC = "diagnostic";
    private static final String PROPERTY_KEY_LOCALIZED_DIAGNOSTIC = "localizedDiagnostic";
    private static final String ENTITY_USAGE_PROPERTY_KEY = "entityCost";
    private static final String HOST_PRODUCT_NAME = "VMware ESX Server";
    private static final String VC_PRODUCT_NAME = "VMware VirtualCenter Server";
    private static final String VSAN_CLUSTER_PRODUCT_NAME = "VMware VSAN";
    private static final String EVALUATION_LICENSE = "00000-00000-00000-00000-00000";
    private static final String MASKED_EVALUATION_LICENSE = "00000-#####-#####-#####-00000";
    private static final String PRODUCT_EVALUATION_KEY = "eval";
    private static final String PRODUCT_KEY_CONCATENATION = "-";
    private static final long LICENSE_NOT_SET_INVALID_VALUE = 1L;
    private static final String COST_UNIT_LOOKUP_PREFIX = "costUnit.";
    private static final String COST_UNIT_LOOKUP_SINGLE_SUFFIX = ".value";
    private static final String COST_UNIT_LOOKUP_PLURAL_SUFFIX = ".valuePlural";
    private static final String LABEL_KEY = "VpxClientLicenseLabel";
    private static final String ENTITY_IDENTIFIER_DELIM = "~";
    private static final String SOLUTION_ENTITY_SCOPE = "";
    public static final int UNLIMITED_TOTAL = 0;

    public static Object getPropertyValue(KeyAnyValue[] keyAnyValueArray, String string) {
        if (keyAnyValueArray == null) {
            return null;
        }
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            if (!string.equals(keyAnyValue.getKey())) continue;
            return keyAnyValue.getValue();
        }
        return null;
    }

    public static LicenseKey buildLicenseKey(LicenseManager.LicenseInfo licenseInfo, boolean bl) {
        if (licenseInfo == null) {
            return null;
        }
        LicenseKey licenseKey = new LicenseKey();
        licenseKey.setLicenseKey(licenseInfo.licenseKey.toUpperCase(Locale.ENGLISH));
        licenseKey.setName(licenseInfo.name);
        licenseKey.setCostUnit(licenseInfo.costUnit);
        licenseKey.setTotal(licenseInfo.total);
        licenseKey.setUsed(licenseInfo.used);
        licenseKey.setProperties(licenseInfo.properties);
        licenseKey.setLabels(licenseInfo.labels);
        licenseKey.setAssigned(bl);
        LicensePropertyUtil.populateAdditionalProperties(licenseKey, licenseInfo);
        LicensePropertyUtil.populateDerivativeProperties(licenseKey);
        LicensePropertyUtil.populateFormattedProperties(licenseKey);
        return licenseKey;
    }

    public static LicenseKey buildEvaluationLicenseKey() {
        LicenseKey licenseKey = new LicenseKey();
        licenseKey.setLicenseKey(EVALUATION_LICENSE);
        licenseKey.setExpirationTime(null);
        licenseKey.setTotal(0);
        licenseKey.setUsed(0);
        licenseKey.setProperties(new KeyAnyValue[0]);
        licenseKey.setLabels(new KeyValue[0]);
        licenseKey.setLicenseVersions(new String[0]);
        licenseKey.setAssigned(false);
        LicensePropertyUtil.populateDerivativeProperties(licenseKey);
        LicensePropertyUtil.populateFormattedProperties(licenseKey);
        return licenseKey;
    }

    public static Assignment buildAssignment(LicenseAssignmentManager.LicenseAssignment licenseAssignment) {
        if (licenseAssignment == null) {
            return null;
        }
        Assignment assignment = new Assignment();
        assignment.setLicenseKey(LicensePropertyUtil.buildLicenseKey(licenseAssignment.assignedLicense, true));
        assignment.setEntityDisplayName(licenseAssignment.entityDisplayName);
        assignment.setEntityId(licenseAssignment.entityId);
        assignment.setProperties(licenseAssignment.properties);
        assignment.setScope(licenseAssignment.scope);
        LicensePropertyUtil.populateAdditionalProperties(assignment, licenseAssignment);
        LicensePropertyUtil.populateFormattedProperties(assignment);
        return assignment;
    }

    public static Assignment buildAssignment(ConnectInfo connectInfo) {
        LicenseKey licenseKey;
        if (connectInfo == null) {
            return null;
        }
        Assignment assignment = new Assignment();
        ConnectInfo.LicenseInfo licenseInfo = connectInfo.getLicense();
        if (licenseInfo != null) {
            licenseKey = LicensePropertyUtil.buildLicenseKey(connectInfo.getLicense().license, true);
            assignment.setLicenseKey(licenseKey);
            if (licenseKey != null) {
                assignment.setLicenseKey(licenseKey);
                assignment.setDlfVersion(licenseKey.getDlfVersion());
            }
            if (licenseInfo.evaluation != null) {
                assignment.setEvalExpirationTime(LicensePropertyUtil.getExpirationTime(licenseInfo.evaluation.properties));
            }
        }
        if (connectInfo.host != null && connectInfo.host.hardware != null) {
            assignment.setEntityUsage(Integer.valueOf(connectInfo.host.hardware.numCpuPkgs));
        }
        if ((licenseKey = LicensePropertyUtil.getAboutInfo(connectInfo)) != null) {
            assignment.setProductName(((AboutInfo)licenseKey).licenseProductName);
            assignment.setProductVersion(((AboutInfo)licenseKey).licenseProductVersion);
        }
        return assignment;
    }

    public static Long getExpirationTime(Assignment assignment) {
        if (assignment == null) {
            return null;
        }
        LicenseKey licenseKey = assignment.getLicenseKey();
        return licenseKey.isEvaluation() ? assignment.getEvalExpirationTime() : licenseKey.getExpirationTime();
    }

    public static boolean isEntityRegisteredForLicensing(Assignment assignment) {
        return assignment != null && assignment.getEntityId() != null;
    }

    public static String getErrorMessage(VcService vcService, LicenseKey licenseKey) {
        LocalizableMessage localizableMessage;
        String string = null;
        if (vcService != null && (localizableMessage = (LocalizableMessage)LicensePropertyUtil.getPropertyValue(licenseKey.getProperties(), PROPERTY_KEY_LOCALIZED_DIAGNOSTIC)) != null) {
            string = LocalizationUtil.getLocalizedMessage((String)localizableMessage.getKey(), (KeyAnyValue[])localizableMessage.getArg());
        }
        if (string == null) {
            string = (String)LicensePropertyUtil.getPropertyValue(licenseKey.getProperties(), PROPERTY_KEY_DIAGNOSTIC);
        }
        return string == null ? SOLUTION_ENTITY_SCOPE : string;
    }

    public static Map<String, Assignment> groupAssignmentsByEntityId(Assignment[] assignmentArray) {
        if (assignmentArray == null) {
            return new HashMap<String, Assignment>();
        }
        HashMap<String, Assignment> hashMap = new HashMap<String, Assignment>();
        for (Assignment assignment : assignmentArray) {
            hashMap.put(assignment.getEntityId(), assignment);
        }
        return hashMap;
    }

    public static Map<String, Assignment> groupAssignmentsByEntityIdentifier(Assignment[] assignmentArray) {
        HashMap<String, Assignment> hashMap = new HashMap<String, Assignment>();
        if (ArrayUtil.isNullOrEmpty((Object[])assignmentArray)) {
            return hashMap;
        }
        for (Assignment assignment : assignmentArray) {
            String string = LicensePropertyUtil.getEntityIdentifierForAssignment(assignment);
            hashMap.put(string, assignment);
        }
        return hashMap;
    }

    public static String getEntityIdentifierForAssignment(Assignment assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException("assignment should not be null.");
        }
        String string = LicensePropertyUtil.getEntityScopeForAssignment(assignment);
        String string2 = LicensePropertyUtil.buildEntityIdentifier(assignment.getEntityId(), string);
        return string2;
    }

    public static Assignment getAssignmentForEntity(Map<String, Assignment> map, Object object) {
        if (map == null) {
            return null;
        }
        String string = LicensePropertyUtil.getEntityIdentifier(object);
        return map.get(string);
    }

    public static String getEntityIdentifier(Object object) {
        if (object == null) {
            return null;
        }
        String string = ManagementUtil.getEntityId(object);
        String string2 = URI.class.isInstance(object) ? SOLUTION_ENTITY_SCOPE : ManagementUtil.getEntityScope(object);
        String string3 = LicensePropertyUtil.buildEntityIdentifier(string, string2);
        return string3;
    }

    public static String buildProductKey(String string, String string2, boolean bl, boolean bl2) {
        String string3 = SOLUTION_ENTITY_SCOPE;
        string3 = bl ? PRODUCT_EVALUATION_KEY : (bl2 ? string : string + PRODUCT_KEY_CONCATENATION + string2);
        return string3;
    }

    public static String getFormattedNumberPresentation(Number number, String string, boolean bl) {
        if (number == null) {
            return ManagementUtil.getLocalizedString("costUnit.undefined");
        }
        String string2 = bl && number.intValue() == 0 ? ManagementUtil.getLocalizedString("costUnit.unlimited") : number.toString();
        String string3 = LicensePropertyUtil.getCostUnitFormattedSuffix(string, number);
        return ManagementUtil.getLocalizedString("costUnit.format", new String[]{string2, string3});
    }

    public static String getFormattedExpirationDate(Long l) {
        if (l == null) {
            return ManagementUtil.getLocalizedString("licenseKey.permanent");
        }
        if (l <= 0L) {
            return ManagementUtil.getLocalizedString("licenseKey.expired");
        }
        Date date = new Date();
        Date date2 = new Date(date.getTime() + l);
        DateFormat dateFormat = DateFormat.getDateInstance(2, ResourceUtil.getLocale());
        return dateFormat.format(date2);
    }

    public static Long getEvalExpirationTime(LicenseManager.EvaluationInfo evaluationInfo) {
        if (evaluationInfo == null) {
            return null;
        }
        return LicensePropertyUtil.getExpirationTime(evaluationInfo.properties);
    }

    public static void populateAssignmentProperties(Assignment assignment, KeyAnyValue[] keyAnyValueArray) {
        if (assignment == null || keyAnyValueArray == null) {
            return;
        }
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            LicenseManager.EvaluationInfo evaluationInfo;
            if (PROPERTY_KEY_PRODUCT_NAME.equals(keyAnyValue.getKey())) {
                assignment.setProductName((String)keyAnyValue.getValue());
                assignment.setEntityType(LicensePropertyUtil.getRelatedEnityType((String)keyAnyValue.getValue()));
                continue;
            }
            if (PROPERTY_KEY_PRODUCT_VERSION.equals(keyAnyValue.getKey())) {
                assignment.setProductVersion((String)keyAnyValue.getValue());
                continue;
            }
            if (ENTITY_USAGE_PROPERTY_KEY.equals(keyAnyValue.getKey())) {
                assignment.setEntityUsage((Integer)keyAnyValue.getValue());
                continue;
            }
            if (PROPERTY_KEY_DLF_FILE_VERSION.equals(keyAnyValue.getKey())) {
                assignment.setDlfVersion((String)keyAnyValue.getValue());
                continue;
            }
            if (!LICENSE_ASSIGNMENT_PROPERTY_KEY_EVALUATION.equals(keyAnyValue.getKey()) || (evaluationInfo = (LicenseManager.EvaluationInfo)keyAnyValue.getValue()) == null) continue;
            assignment.setEvalExpirationTime(LicensePropertyUtil.getExpirationTime(evaluationInfo.properties));
        }
    }

    private static boolean isUnlimitedTotal(int n) {
        return n == 0;
    }

    public static boolean isEvaluationLicenseKey(String string) {
        return EVALUATION_LICENSE.equals(string) || MASKED_EVALUATION_LICENSE.equals(string);
    }

    private static boolean isLicenseKeyRemovable(boolean bl, boolean bl2) {
        return !bl && !bl2;
    }

    private static String getCostUnitFormattedSuffix(String string, Number number) {
        if (!LicenseUtil.isValidCostUnit(string).booleanValue()) {
            return SOLUTION_ENTITY_SCOPE;
        }
        String string2 = string;
        if (LicenseUtil.isCpuPackageCoreLimitCostUnit(string).booleanValue()) {
            string2 = "cpuPackage";
        }
        String string3 = number == null || !number.equals(1) ? COST_UNIT_LOOKUP_PLURAL_SUFFIX : COST_UNIT_LOOKUP_SINGLE_SUFFIX;
        return ManagementUtil.getLocalizedString(COST_UNIT_LOOKUP_PREFIX + string2 + string3);
    }

    private static String getAssignmentStatePresentation(LicenseKey licenseKey) {
        return licenseKey != null && licenseKey.isAssigned() ? ManagementUtil.getLocalizedString("licenseKey.isAssigned.true") : ManagementUtil.getLocalizedString("licenseKey.isAssigned.false");
    }

    private static String getLicenseKeyLabel(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return SOLUTION_ENTITY_SCOPE;
        }
        KeyValue[] keyValueArray = licenseKey.getLabels();
        if (keyValueArray == null) {
            return SOLUTION_ENTITY_SCOPE;
        }
        for (KeyValue keyValue : keyValueArray) {
            if (!LABEL_KEY.equals(keyValue.key)) continue;
            return keyValue.value;
        }
        return SOLUTION_ENTITY_SCOPE;
    }

    private static String getFormattedLicenseKey(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return ManagementUtil.getLocalizedString("licenseKey.unlicensed");
        }
        if (LicensePropertyUtil.isEvaluationLicenseKey(string)) {
            return ManagementUtil.getLocalizedString("licenseKey.evaluation");
        }
        return string;
    }

    private static boolean isVsanLicense(LicenseKey licenseKey) {
        return EntityType.CLUSTER.equals((Object)licenseKey.getEntityType());
    }

    private static String getFormattedProductName(String string, String string2, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4) {
        if (bl2.booleanValue()) {
            return ManagementUtil.getLocalizedString("licenseProduct.unlicensed");
        }
        if (bl.booleanValue()) {
            return ManagementUtil.getLocalizedString("licenseProduct.evaluation");
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return SOLUTION_ENTITY_SCOPE;
        }
        if (!LicenseUtil.isValidCostUnit(string2).booleanValue() || bl3.booleanValue() || bl4.booleanValue()) {
            return string;
        }
        String string3 = SOLUTION_ENTITY_SCOPE;
        if (LicenseUtil.isCpuPackageCoreLimitCostUnit(string2).booleanValue()) {
            string3 = ManagementUtil.getLocalizedString("licenseProductFormatedNameSuffix.fixedCores", new String[]{LicenseUtil.getCpuPackageCoreLimit(string2)});
        } else if ("cpuPackage".equals(string2)) {
            string3 = ManagementUtil.getLocalizedString("licenseProductFormatedNameSuffix.cpuPackageUnlimitedCores");
        }
        return string3.isEmpty() ? string : ManagementUtil.getLocalizedString("licenseProductFormatedName.pattern", new String[]{string, string3});
    }

    private static void populateAdditionalProperties(LicenseKey licenseKey, LicenseManager.LicenseInfo licenseInfo) {
        if (licenseKey == null || licenseInfo == null || licenseInfo.properties == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Number number = null;
        Number number2 = null;
        Calendar calendar = null;
        Calendar calendar2 = null;
        for (KeyAnyValue keyAnyValue : licenseInfo.properties) {
            Object object;
            Object object2;
            if (PROPERTY_KEY_PRODUCT_NAME.equals(keyAnyValue.getKey())) {
                licenseKey.setProductName((String)keyAnyValue.getValue());
                licenseKey.setEntityType(LicensePropertyUtil.getRelatedEnityType((String)keyAnyValue.getValue()));
                continue;
            }
            if (PROPERTY_KEY_PRODUCT_VERSION.equals(keyAnyValue.getKey())) {
                licenseKey.setProductVersion((String)keyAnyValue.getValue());
                continue;
            }
            if (PROPERTY_KEY_DLF_FILE_VERSION.equals(keyAnyValue.getKey())) {
                licenseKey.setDlfVersion((String)keyAnyValue.getValue());
                continue;
            }
            if (PROPERTY_KEY_DIAGNOSTIC.equals(keyAnyValue.getKey()) || PROPERTY_KEY_LI_ERROR.equals(keyAnyValue.getKey())) {
                if (licenseKey.isInvalid()) continue;
                licenseKey.setInvalid(keyAnyValue.getValue() != null);
                continue;
            }
            if (PROPERTY_KEY_LICENSE_NO_SET.equals(keyAnyValue.getKey())) {
                if (keyAnyValue.getValue() == null || licenseKey.isInvalid()) continue;
                licenseKey.setInvalid((Long)keyAnyValue.getValue() == 1L);
                continue;
            }
            if (PROPERTY_KEY_LICENSE_INFO.equals(keyAnyValue.getKey())) {
                object2 = (LicenseManager.LicenseInfo)keyAnyValue.getValue();
                if (object2 == null || (object = (String)LicensePropertyUtil.getPropertyValue(object2.properties, PROPERTY_KEY_DLF_FILE_VERSION)) == null) continue;
                arrayList.add((String)object);
                continue;
            }
            if (PROPERTY_KEY_MAX_SSD_PER_HOST.equals(keyAnyValue.getKey())) {
                object2 = (Number)keyAnyValue.getValue();
                licenseKey.setVsanPerHostSsdEntitlementInGb((Number)object2);
                continue;
            }
            if (EXPIRATION_HOURS_KEY.equals(keyAnyValue.getKey())) {
                number = (Number)keyAnyValue.getValue();
                continue;
            }
            if (EXPIRATION_MINUTES_KEY.equals(keyAnyValue.getKey())) {
                number2 = (Number)keyAnyValue.getValue();
                continue;
            }
            if (EXPIRATION_DATE_KEY.equals(keyAnyValue.getKey())) {
                calendar = LicensePropertyUtil.getCalendar(keyAnyValue.getValue());
                continue;
            }
            if (SYSTEM_TIME_KEY.equals(keyAnyValue.getKey())) {
                calendar2 = LicensePropertyUtil.getCalendar(keyAnyValue.getValue());
                continue;
            }
            if (PROPERTY_KEY_SUITE_LICENSE.equals(keyAnyValue.getKey())) {
                object2 = (String)keyAnyValue.getValue();
                licenseKey.setSuiteLicense(!StringUtil.isNullOrEmpty((String)object2));
                licenseKey.setPrimarySuiteLicense(PROPERTY_VALUE_PRIMARY_SUITE_LICENSE.equals(object2));
                continue;
            }
            if (!PROPERTY_KEY_SUITE_LICENSE_INFO.equals(keyAnyValue.getKey()) || (object2 = (LicenseManager.LicenseInfo)keyAnyValue.getValue()) == null) continue;
            object = LicensePropertyUtil.buildLicenseKey(object2, false);
            arrayList2.add((String)object);
        }
        licenseKey.setLicenseVersions(arrayList.toArray(new String[arrayList.size()]));
        licenseKey.setSecondarySuiteLicenses(arrayList2.toArray(new LicenseKey[arrayList2.size()]));
        Long l = LicensePropertyUtil.getExpirationTime(number, number2, calendar, calendar2);
        licenseKey.setExpirationTime(l);
    }

    private static Calendar getCalendar(Object object) {
        if (object == null) {
            return null;
        }
        if (Calendar.class.isInstance(object)) {
            return (Calendar)object;
        }
        if (Date.class.isInstance(object)) {
            return DateUtil.createUTCCalendar((Date)object);
        }
        throw new IllegalArgumentException("The object parameter is of type not supported by this method");
    }

    private static void populateDerivativeProperties(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return;
        }
        licenseKey.setEvaluation(LicensePropertyUtil.isEvaluationLicenseKey(licenseKey.getLicenseKey()));
        licenseKey.setProductKey(LicensePropertyUtil.buildProductKey(licenseKey.getName(), licenseKey.getCostUnit(), licenseKey.isEvaluation(), licenseKey.isSuiteLicense()));
        licenseKey.setUnlimitedCapacity(LicensePropertyUtil.isUnlimitedTotal(licenseKey.getTotal()));
        licenseKey.setRemovable(LicensePropertyUtil.isLicenseKeyRemovable(licenseKey.isAssigned(), licenseKey.isEvaluation()));
    }

    private static void populateFormattedProperties(LicenseKey licenseKey) {
        if (licenseKey == null) {
            return;
        }
        String string = licenseKey.getCostUnit();
        licenseKey.setFormattedTotal(LicensePropertyUtil.getFormattedNumberPresentation(licenseKey.getTotal(), string, true));
        licenseKey.setFormattedUsed(LicensePropertyUtil.getFormattedNumberPresentation(licenseKey.getUsed(), string, false));
        licenseKey.setFormattedLabel(LicensePropertyUtil.getLicenseKeyLabel(licenseKey));
        licenseKey.setFormattedAssignmentState(LicensePropertyUtil.getAssignmentStatePresentation(licenseKey));
        licenseKey.setFormattedLicenseKey(LicensePropertyUtil.getFormattedLicenseKey(licenseKey.getLicenseKey()));
        licenseKey.setFormattedProductName(LicensePropertyUtil.getFormattedProductName(licenseKey.getName(), string, licenseKey.isEvaluation(), licenseKey.isInvalid(), licenseKey.isSuiteLicense(), LicensePropertyUtil.isVsanLicense(licenseKey)));
    }

    public static void populateFormattedProperties(Assignment assignment) {
        if (assignment == null) {
            return;
        }
        assignment.setFormattedEntityUsage(LicensePropertyUtil.getFormattedNumberPresentation(assignment.getEntityUsage(), assignment.getLicenseKey().getCostUnit(), false));
    }

    private static void populateAdditionalProperties(Assignment assignment, LicenseAssignmentManager.LicenseAssignment licenseAssignment) {
        if (assignment == null || licenseAssignment == null || licenseAssignment.properties == null) {
            return;
        }
        for (KeyAnyValue keyAnyValue : licenseAssignment.properties) {
            LicenseManager.EvaluationInfo evaluationInfo;
            if (PROPERTY_KEY_PRODUCT_NAME.equals(keyAnyValue.getKey())) {
                assignment.setProductName((String)keyAnyValue.getValue());
                assignment.setEntityType(LicensePropertyUtil.getRelatedEnityType((String)keyAnyValue.getValue()));
                continue;
            }
            if (PROPERTY_KEY_PRODUCT_VERSION.equals(keyAnyValue.getKey())) {
                assignment.setProductVersion((String)keyAnyValue.getValue());
                continue;
            }
            if (ENTITY_USAGE_PROPERTY_KEY.equals(keyAnyValue.getKey())) {
                assignment.setEntityUsage((Integer)keyAnyValue.getValue());
                continue;
            }
            if (PROPERTY_KEY_DLF_FILE_VERSION.equals(keyAnyValue.getKey())) {
                assignment.setDlfVersion((String)keyAnyValue.getValue());
                continue;
            }
            if (!LICENSE_ASSIGNMENT_PROPERTY_KEY_EVALUATION.equals(keyAnyValue.getKey()) || (evaluationInfo = (LicenseManager.EvaluationInfo)keyAnyValue.getValue()) == null) continue;
            assignment.setEvalExpirationTime(LicensePropertyUtil.getExpirationTime(evaluationInfo.properties));
        }
    }

    private static Long getExpirationTime(KeyAnyValue[] keyAnyValueArray) {
        if (keyAnyValueArray == null) {
            return null;
        }
        Number number = (Number)LicensePropertyUtil.getPropertyValue(keyAnyValueArray, EXPIRATION_HOURS_KEY);
        Number number2 = (Number)LicensePropertyUtil.getPropertyValue(keyAnyValueArray, EXPIRATION_MINUTES_KEY);
        Object object = LicensePropertyUtil.getPropertyValue(keyAnyValueArray, EXPIRATION_DATE_KEY);
        Calendar calendar = LicensePropertyUtil.getCalendar(object);
        Object object2 = LicensePropertyUtil.getPropertyValue(keyAnyValueArray, SYSTEM_TIME_KEY);
        Calendar calendar2 = LicensePropertyUtil.getCalendar(object2);
        return LicensePropertyUtil.getExpirationTime(number, number2, calendar, calendar2);
    }

    private static Long getExpirationTime(Number number, Number number2, Calendar calendar, Calendar calendar2) {
        if (number == null && number2 == null && calendar == null) {
            return null;
        }
        if (number != null || number2 != null) {
            long l = number != null ? number.longValue() : 0L;
            long l2 = number2 != null ? number2.longValue() : 0L;
            return l * 3600000L + l2 * 60000L;
        }
        if (calendar2 == null) {
            return calendar.getTimeInMillis() - new Date().getTime();
        }
        return calendar.getTimeInMillis() - calendar2.getTimeInMillis();
    }

    private static AboutInfo getAboutInfo(ConnectInfo connectInfo) {
        if (connectInfo == null || connectInfo.host == null) {
            return null;
        }
        Summary.ConfigSummary configSummary = connectInfo.host.config;
        return configSummary != null ? configSummary.product : null;
    }

    private static EntityType getRelatedEnityType(String string) {
        boolean bl = true;
        if (string == null) {
            return EntityType.UNKNOWN;
        }
        if (HOST_PRODUCT_NAME.equals(string)) {
            return EntityType.HOST;
        }
        if (VC_PRODUCT_NAME.equals(string)) {
            return EntityType.VIRTUAL_CENTER;
        }
        if (bl && VSAN_CLUSTER_PRODUCT_NAME.equals(string)) {
            return EntityType.CLUSTER;
        }
        return EntityType.SOLUTION;
    }

    private static String getEntityScopeForAssignment(Assignment assignment) {
        EntityType entityType = assignment.getEntityType();
        String string = null;
        string = EntityType.SOLUTION.equals((Object)entityType) ? SOLUTION_ENTITY_SCOPE : (EntityType.VIRTUAL_CENTER.equals((Object)entityType) ? assignment.getEntityId() : assignment.getScope());
        return string;
    }

    private static String buildEntityIdentifier(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Both entityId and entityScope should be passed to get entity identifier.");
        }
        String string3 = string2 == null ? string : string + ENTITY_IDENTIFIER_DELIM + string2;
        return string3;
    }
}

