/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.NumberDataObject;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import java.net.URI;
import java.util.Set;

public class ManagementUtil {
    public static final String NEW_LINE = "\n";
    public static final String LICENSE_KEY_TYPE = "LicenseKey";
    public static final String LICENSE_PRODUCT_TYPE = "LicenseProduct";
    public static final String LICENSE_SOLUTION_TYPE = "LicenseSolution";
    public static final String HOST_SYSTEM_TYPE = "HostSystem";
    public static final String VIRTUAL_CENTER_TYPE = "Folder";
    public static final String CLUSTER_TYPE = "ClusterComputeResource";
    public static final String[] LICENSABLE_MANAGED_OBJECT_TYPES = new String[]{"HostSystem", "Folder", "ClusterComputeResource"};
    public static final int TWO_DECIMAL_PRECISION = 100;
    public static final String FORCE_REFRESH_KEY = "forceRefresh";
    private static final String LICENSE_SERVICE_STRINGS = "licenseservice";
    private static final String VIRTUAL_CENTER_VALUE = "group-d1";
    private static final int LICENSE_URI_VALUE_INDEX = 0;
    private static final int LICENSE_URI_SCOPE_INDEX = 1;
    private static final String GLOBAL_LICENSES_PRIVILEGE = "Global.Licenses";

    public static String getLocalizedString(String string) {
        return ResourceUtil.getString((String)LICENSE_SERVICE_STRINGS, (String)string, (ClassLoader)ManagementUtil.class.getClassLoader());
    }

    public static String getLocalizedString(String string, String[] stringArray) {
        return ResourceUtil.getString((String)LICENSE_SERVICE_STRINGS, (String)string, (String[])stringArray, (ClassLoader)ManagementUtil.class.getClassLoader());
    }

    public static ManagedObjectReference buildMoRef(String string, String string2, String string3) {
        return new ManagedObjectReference(string, string2, string3);
    }

    public static ManagedObjectReference buildVcMoRef(String string) {
        return ManagementUtil.buildMoRef(VIRTUAL_CENTER_TYPE, VIRTUAL_CENTER_VALUE, string);
    }

    public static String getEntityId(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return "";
        }
        if (ManagementUtil.isVirtualCenter(managedObjectReference)) {
            return managedObjectReference.getServerGuid();
        }
        return managedObjectReference.getValue();
    }

    public static String getEntityId(Object object) {
        if (ManagedObjectReference.class.isInstance(object)) {
            return ManagementUtil.getEntityId((ManagedObjectReference)object);
        }
        if (URI.class.isInstance(object)) {
            return ManagementUtil.getLicenseUriValue((URI)object);
        }
        return "";
    }

    public static String getEntityScope(Object object) {
        if (ManagedObjectReference.class.isInstance(object)) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            return managedObjectReference.getServerGuid();
        }
        if (URI.class.isInstance(object)) {
            return ManagementUtil.getLicenseUriScope((URI)object);
        }
        return "";
    }

    public static boolean isLicensableAsset(ManagedObjectReference managedObjectReference) {
        for (String string : LICENSABLE_MANAGED_OBJECT_TYPES) {
            if (!ManagementUtil.isManagedObjectReferenceOfType(managedObjectReference, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVirtualCenter(ManagedObjectReference managedObjectReference) {
        return ManagementUtil.isManagedObjectReferenceOfType(managedObjectReference, VIRTUAL_CENTER_TYPE);
    }

    public static boolean isHostSystem(ManagedObjectReference managedObjectReference) {
        return ManagementUtil.isManagedObjectReferenceOfType(managedObjectReference, HOST_SYSTEM_TYPE);
    }

    public static boolean isCluster(ManagedObjectReference managedObjectReference) {
        return ManagementUtil.isManagedObjectReferenceOfType(managedObjectReference, CLUSTER_TYPE);
    }

    public static boolean isManagedObjectReferenceOfType(ManagedObjectReference managedObjectReference, String string) {
        if (string == null) {
            throw new IllegalArgumentException("type should not be null");
        }
        return managedObjectReference != null && string.equals(managedObjectReference.getType());
    }

    public static URI buildLicenseUri(String string, String string2, String string3) {
        return DefaultUriSchemeUtil.createUri((String)string, (String[])new String[]{string2, string3});
    }

    public static boolean isUriOfType(Object object, String string) {
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        return ObjectUtil.objectsEqual((Object)string, (Object)DefaultUriSchemeUtil.getType((URI)uRI));
    }

    public static String getLicenseUriValue(URI uRI) {
        return ManagementUtil.getLicenseIdSegment(uRI, 0);
    }

    public static String getLicenseUriScope(URI uRI) {
        return ManagementUtil.getLicenseIdSegment(uRI, 1);
    }

    public static Double roundNumber(Number number, int n) {
        if (number == null) {
            return null;
        }
        Integer n2 = (int)(number.doubleValue() * (double)n);
        return n2.doubleValue() / (double)n;
    }

    public static NumberDataObject createNumberDataObject(Number number) {
        if (number == null) {
            return null;
        }
        NumberDataObject numberDataObject = new NumberDataObject();
        if (number != null) {
            numberDataObject.setValue(number);
        }
        return numberDataObject;
    }

    public static boolean isLicensePrivilegeGranted(LegacyAuthorizationService legacyAuthorizationService, String string) throws Exception {
        if (legacyAuthorizationService == null || string == null) {
            return false;
        }
        ManagedObjectReference managedObjectReference = ManagementUtil.buildVcMoRef(string);
        return legacyAuthorizationService.checkPrivileges(new ManagedObjectReference[]{managedObjectReference}, new String[]{GLOBAL_LICENSES_PRIVILEGE});
    }

    public static PropertyValue buildPropertyValue(String string, Object object, Object object2) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = object2;
        propertyValue.propertyName = string;
        propertyValue.value = object;
        return propertyValue;
    }

    public static Object getPropertyParameterValue(String string, PropertySpec[] propertySpecArray) {
        if (propertySpecArray == null) {
            return null;
        }
        for (PropertySpec propertySpec : propertySpecArray) {
            ParameterSpec[] parameterSpecArray = propertySpec.parameters;
            if (parameterSpecArray == null) continue;
            for (ParameterSpec parameterSpec : parameterSpecArray) {
                if (parameterSpec == null || !string.equals(parameterSpec.propertyName)) continue;
                return parameterSpec.parameter;
            }
        }
        return null;
    }

    public static Boolean isFreshDataRequested(PropertySpec[] propertySpecArray) {
        Object object = ManagementUtil.getPropertyParameterValue(FORCE_REFRESH_KEY, propertySpecArray);
        return object != null && object instanceof Boolean ? (Boolean)object : null;
    }

    public static <T> boolean doesSetContainLicenseUriValuesForUris(Set<String> set, URI[] uRIArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])uRIArray)) {
            return true;
        }
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (URI uRI : uRIArray) {
            if (set.contains(ManagementUtil.getLicenseUriValue(uRI))) continue;
            return false;
        }
        return true;
    }

    public static void reportNotExistingObjects() {
        ManagementUtil.reportNotExistingObjects(ManagementUtil.getLocalizedString("error.notExistingObject.plural"));
    }

    public static void reportNotExistingObject() {
        ManagementUtil.reportNotExistingObjects(ManagementUtil.getLocalizedString("error.notExistingObject"));
    }

    public static void reportNotExistingObjects(String string) {
        throw new RuntimeException(string);
    }

    public static MethodFault buildLicenseMethodFault(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        return ManagementUtil.buildLicenseMethodFault("", throwable);
    }

    private static MethodFault buildLicenseMethodFault(String string, Throwable throwable) {
        MethodFault methodFault;
        if (string == null && throwable == null) {
            throw new IllegalArgumentException("To build MethodFault is needed either message or cause.");
        }
        if (throwable == null) {
            methodFault = new MethodFault(string);
        } else {
            String string2;
            String string3 = string2 = StringUtil.isNullOrEmpty((String)string) ? throwable.getMessage() : string + NEW_LINE + throwable.getMessage();
            if (throwable.getCause() == null) {
                methodFault = MixedUtil.getMethodFault((Throwable)throwable);
                methodFault.setMessage(string2);
            } else {
                methodFault = ManagementUtil.buildLicenseMethodFault(string2, throwable.getCause());
            }
        }
        return methodFault;
    }

    private static String getLicenseIdSegment(URI uRI, int n) {
        String[] stringArray = DefaultUriSchemeUtil.getIdSegments((URI)uRI);
        if (stringArray.length > n) {
            return stringArray[n];
        }
        return "";
    }
}

