/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.scheduling.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vim.TaskHistoryCollector;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskManager;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskInfo;
import com.vmware.vim.binding.vim.scheduler.TaskScheduler;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.scheduling.ScheduledTaskExecutionInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.task.TaskSearchHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduledOpsSearchProvider
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(ScheduledOpsSearchProvider.class);
    private static final long MAX_EXECUTION_INFO_LENGTH = 5L;
    private static String PROPERTY_HOST_FOLDER = "hostFolder";
    private static String PROPERTY_VM_FOLDER = "vmFolder";
    private static String PROPERTY_NETWORK_FOLDER = "networkFolder";
    private static String PROPERTY_STORAGE_FOLDER = "datastoreFolder";
    private static String PROPERTY_SCHEDULED_TASK = "scheduledTask";
    private DataService _dataService = null;
    private final TaskSearchHelper _taskSearchHelper;

    public ScheduledOpsSearchProvider(DataServiceExtensionRegistry dataServiceExtensionRegistry, DataService dataService, TaskSearchHelper taskSearchHelper) {
        dataServiceExtensionRegistry.registerDataAdapter((DataProviderAdapter)this, this.getProvidedTypes());
        _logger.debug((Object)"Instance created");
        this._dataService = dataService;
        this._taskSearchHelper = taskSearchHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            QuerySpec querySpec = querySpecArray[i];
            try {
                resultSetArray[i] = this.processQuery(querySpec);
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)"Error retrieving scheduled operation info:", (Throwable)exception);
                resultSetArray[i] = this.processException(exception);
                continue;
            }
            finally {
                if (resultSetArray[i] != null) {
                    resultSetArray[i].queryName = querySpec.name;
                }
            }
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    private String[] getProvidedTypes() {
        String[] stringArray = new String[]{"vsphere:ScheduledTask", "ScheduledTask"};
        return stringArray;
    }

    private ResultSet processException(Exception exception) {
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = 0;
        resultSet.error = exception;
        return resultSet;
    }

    private ResultSet processQuery(QuerySpec querySpec) throws Exception {
        if (querySpec.resourceSpec == null) {
            return this.newEmptyResultSet();
        }
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint instanceof ObjectIdentityConstraint) {
            return this.processObjectIdentityQuery(querySpec);
        }
        if (constraint instanceof RelationalConstraint) {
            return this.processRelationalQuery(querySpec);
        }
        return null;
    }

    ResultSet processObjectIdentityQuery(QuerySpec querySpec) throws Exception {
        ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)querySpec.resourceSpec.constraint;
        if (!(objectIdentityConstraint.target instanceof ManagedObjectReference)) {
            return this.newEmptyResultSet();
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)objectIdentityConstraint.target;
        PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
        String string = querySpec.resourceSpec.constraint.targetType;
        if (!"vsphere:ScheduledTask".equals(string)) {
            return this.newEmptyResultSet();
        }
        return this.processScheduledTaskQuery(managedObjectReference, propertySpecArray);
    }

    private List<ManagedObjectReference> getScheduledTasks(ManagedObjectReference managedObjectReference) throws Exception {
        ResultSet resultSet;
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        List<Object> list = new ArrayList();
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference)) {
            list = this.getAllVcScheduledTasks(managedObjectReference.getServerGuid());
        } else {
            resultSet = (Object[])QueryUtil.getProperty((DataService)this._dataService, (Object)managedObjectReference, (String)PROPERTY_SCHEDULED_TASK);
            ArrayUtil.append(list, (Object[])resultSet);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, Datacenter.class)) {
            resultSet = this.getScheduledTaskForDCInventoryFolders(managedObjectReference);
            for (ResultItem resultItem : resultSet.items) {
                for (PropertyValue propertyValue : resultItem.properties) {
                    Object[] objectArray = (Object[])propertyValue.value;
                    ArrayUtil.append(list, (Object[])objectArray);
                }
            }
        }
        ArrayUtil.append(arrayList, list);
        return arrayList;
    }

    private ResultSet getScheduledTaskForDCInventoryFolders(ManagedObjectReference managedObjectReference) throws Exception {
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)PROPERTY_HOST_FOLDER, (Constraint)objectIdentityConstraint, (Boolean)true, (String)Folder.class.getSimpleName());
        RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)PROPERTY_VM_FOLDER, (Constraint)objectIdentityConstraint, (Boolean)true, (String)Folder.class.getSimpleName());
        RelationalConstraint relationalConstraint3 = QueryUtil.createRelationalConstraint((String)PROPERTY_NETWORK_FOLDER, (Constraint)objectIdentityConstraint, (Boolean)true, (String)Folder.class.getSimpleName());
        RelationalConstraint relationalConstraint4 = QueryUtil.createRelationalConstraint((String)PROPERTY_STORAGE_FOLDER, (Constraint)objectIdentityConstraint, (Boolean)true, (String)Folder.class.getSimpleName());
        Constraint[] constraintArray = new Constraint[]{relationalConstraint, relationalConstraint2, relationalConstraint3, relationalConstraint4};
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])constraintArray, (Conjoiner)Conjoiner.OR);
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{PROPERTY_SCHEDULED_TASK});
        return QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
    }

    private List<Object> getAllVcScheduledTasks(String string) throws Exception {
        ResultItem[] resultItemArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Constraint constraint = new Constraint();
        constraint.targetType = "ScheduledTask";
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"name"});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                ManagedObjectReference managedObjectReference = (ManagedObjectReference)resultItem.resourceObject;
                if (!managedObjectReference.getServerGuid().equals(string)) continue;
                arrayList.add(managedObjectReference);
            }
        }
        return arrayList;
    }

    private com.vmware.vise.core.model.scheduling.ScheduledTaskInfo newPlatformScheduledTaskInfo(ScheduledTaskInfo scheduledTaskInfo) {
        com.vmware.vise.core.model.scheduling.ScheduledTaskInfo scheduledTaskInfo2 = new com.vmware.vise.core.model.scheduling.ScheduledTaskInfo();
        scheduledTaskInfo2.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)scheduledTaskInfo.name);
        scheduledTaskInfo2.description = scheduledTaskInfo.description;
        scheduledTaskInfo2.enabled = scheduledTaskInfo.enabled;
        scheduledTaskInfo2.notification = scheduledTaskInfo.notification;
        if (scheduledTaskInfo.nextRunTime != null) {
            scheduledTaskInfo2.nextRunTime = scheduledTaskInfo.nextRunTime.getTime();
        }
        ScheduledTaskExecutionInfo scheduledTaskExecutionInfo = null;
        if (scheduledTaskInfo.prevRunTime != null) {
            scheduledTaskExecutionInfo = new ScheduledTaskExecutionInfo();
            scheduledTaskExecutionInfo.startTime = scheduledTaskInfo.prevRunTime.getTime();
            scheduledTaskExecutionInfo.state = SchedulingUtil.toExecutionState((TaskInfo.State)scheduledTaskInfo.state);
        }
        scheduledTaskInfo2.lastRunInfo = scheduledTaskExecutionInfo;
        scheduledTaskInfo2.scheduledTask = scheduledTaskInfo.scheduledTask;
        scheduledTaskInfo2.lastModifiedUser = scheduledTaskInfo.lastModifiedUser;
        scheduledTaskInfo2.lastModifiedTime = scheduledTaskInfo.lastModifiedTime.getTime();
        scheduledTaskInfo2.recurrence = SchedulingUtil.toPlatformScheduler((TaskScheduler)scheduledTaskInfo.scheduler);
        scheduledTaskInfo2.spec = new Object[]{scheduledTaskInfo.action};
        scheduledTaskInfo2.object = new Object[]{scheduledTaskInfo.taskObject};
        return scheduledTaskInfo2;
    }

    private ResultSet newEmptyResultSet() {
        return null;
    }

    private ResultSet processScheduledTaskQuery(ManagedObjectReference managedObjectReference, PropertySpec[] propertySpecArray) throws Exception {
        if (propertySpecArray == null || propertySpecArray.length == 0 || propertySpecArray[0].propertyNames == null || propertySpecArray[0].propertyNames.length == 0) {
            return this.newEmptyResultSet();
        }
        List<ResultItem> list = null;
        String string = propertySpecArray[0].propertyNames[0];
        if (string.equals("scheduledTaskInfo")) {
            list = this.getScheduledOpeartionInfo(managedObjectReference);
        } else if (string.equals("name")) {
            list = this.getScheduledOperationName(managedObjectReference);
        } else if (string.equals("scheduledTaskExecutionInfo")) {
            list = this.getScheduledOperationExecutionInfo(managedObjectReference);
        }
        if (list != null) {
            ResultSet resultSet = new ResultSet();
            resultSet.totalMatchedObjectCount = list.size();
            resultSet.items = (ResultItem[])ArrayUtil.toArrayOrNull(list, ResultItem.class);
            return resultSet;
        }
        return this.newEmptyResultSet();
    }

    private ResultSet processRelationalQuery(QuerySpec querySpec) throws Exception {
        RelationalConstraint relationalConstraint = (RelationalConstraint)querySpec.resourceSpec.constraint;
        if (!"vsphere:ScheduledTask".equals(relationalConstraint.targetType)) {
            return this.newEmptyResultSet();
        }
        if (!"scheduledTask".equals(relationalConstraint.relation)) {
            return this.newEmptyResultSet();
        }
        if (!(relationalConstraint.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
            return this.newEmptyResultSet();
        }
        ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)relationalConstraint.constraintOnRelatedObject;
        if (!(objectIdentityConstraint.target instanceof ManagedObjectReference)) {
            return this.newEmptyResultSet();
        }
        PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
        if (propertySpecArray == null || propertySpecArray.length == 0 || propertySpecArray[0].propertyNames == null || propertySpecArray[0].propertyNames.length == 0) {
            return this.newEmptyResultSet();
        }
        String string = querySpec.resourceSpec.propertySpecs[0].propertyNames[0];
        if (!string.equals("scheduledTaskInfo")) {
            return this.newEmptyResultSet();
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)objectIdentityConstraint.target;
        List<ManagedObjectReference> list = this.getScheduledTasks(managedObjectReference);
        if (list.size() == 0) {
            return this.newEmptyResultSet();
        }
        List<ResultItem> list2 = this.getScheduledOperationInfo(list);
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = list2.size();
        resultSet.items = (ResultItem[])ArrayUtil.toArrayOrNull(list2, ResultItem.class);
        return resultSet;
    }

    private List<ResultItem> getScheduledOperationInfo(List<ManagedObjectReference> list) throws Exception {
        PropertyValue[] propertyValueArray;
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        Object[] objectArray = (ManagedObjectReference[])ArrayUtil.toArray(list, ManagedObjectReference.class);
        for (PropertyValue propertyValue : propertyValueArray = QueryUtil.getProperty((DataService)this._dataService, (Object[])objectArray, (String)"info")) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
            ScheduledTaskInfo scheduledTaskInfo = (ScheduledTaskInfo)propertyValue.value;
            com.vmware.vise.core.model.scheduling.ScheduledTaskInfo scheduledTaskInfo2 = this.newPlatformScheduledTaskInfo(scheduledTaskInfo);
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.resourceObject = managedObjectReference;
            propertyValue2.propertyName = "scheduledTaskInfo";
            propertyValue2.value = scheduledTaskInfo2;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = managedObjectReference;
            resultItem.properties = new PropertyValue[]{propertyValue2};
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private List<ResultItem> getScheduledOpeartionInfo(ManagedObjectReference managedObjectReference) throws Exception {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        arrayList.add(managedObjectReference);
        return this.getScheduledOperationInfo(arrayList);
    }

    private List<ResultItem> getScheduledOperationName(List<ManagedObjectReference> list) throws Exception {
        PropertyValue[] propertyValueArray;
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        Object[] objectArray = (ManagedObjectReference[])ArrayUtil.toArray(list, ManagedObjectReference.class);
        for (PropertyValue propertyValue : propertyValueArray = QueryUtil.getProperty((DataService)this._dataService, (Object[])objectArray, (String)"info.name")) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
            String string = (String)propertyValue.value;
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.resourceObject = managedObjectReference;
            propertyValue2.propertyName = "name";
            propertyValue2.value = string;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = managedObjectReference;
            resultItem.properties = new PropertyValue[]{propertyValue2};
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private List<ResultItem> getScheduledOperationName(ManagedObjectReference managedObjectReference) throws Exception {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        arrayList.add(managedObjectReference);
        return this.getScheduledOperationName(arrayList);
    }

    private List<ResultItem> getScheduledOperationExecutionInfo(List<ManagedObjectReference> list) throws Exception {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        ManagedObjectReference[] managedObjectReferenceArray = (ManagedObjectReference[])ArrayUtil.toArray(list, ManagedObjectReference.class);
        if (managedObjectReferenceArray.length == 0) {
            return arrayList;
        }
        ManagedObjectReference managedObjectReference = managedObjectReferenceArray[0];
        VcService vcService = VimSessionUtil.getService((String)managedObjectReference.getServerGuid());
        managedObjectReference = vcService.getServiceInstanceContent().getTaskManager();
        TaskManager taskManager = (TaskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        for (ManagedObjectReference managedObjectReference2 : managedObjectReferenceArray) {
            TaskFilterSpec taskFilterSpec = new TaskFilterSpec();
            taskFilterSpec.scheduledTask = managedObjectReference2;
            managedObjectReference = taskManager.createCollector(taskFilterSpec);
            TaskHistoryCollector taskHistoryCollector = (TaskHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            ResultItem resultItem = taskHistoryCollector.getLatestPage();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.resourceObject = managedObjectReference2;
            propertyValue.propertyName = "scheduledTaskExecutionInfo";
            ArrayList<ScheduledTaskExecutionInfo> arrayList2 = new ArrayList<ScheduledTaskExecutionInfo>();
            for (TaskInfo taskInfo : resultItem) {
                ScheduledTaskExecutionInfo scheduledTaskExecutionInfo = new ScheduledTaskExecutionInfo();
                scheduledTaskExecutionInfo.startTime = taskInfo.startTime != null ? taskInfo.startTime.getTime() : null;
                scheduledTaskExecutionInfo.endTime = taskInfo.completeTime != null ? taskInfo.completeTime.getTime() : null;
                scheduledTaskExecutionInfo.state = SchedulingUtil.toExecutionState((TaskInfo.State)taskInfo.state);
                OperationResult operationResult = new OperationResult();
                operationResult.result = this._taskSearchHelper.getClientTaskInfo(taskInfo);
                scheduledTaskExecutionInfo.result = new OperationResult[]{operationResult};
                arrayList2.add(scheduledTaskExecutionInfo);
                if ((long)arrayList2.size() >= 5L) break;
            }
            propertyValue.value = ArrayUtil.toArray(arrayList2, ScheduledTaskExecutionInfo.class);
            ResultItem resultItem2 = new ResultItem();
            resultItem2.resourceObject = managedObjectReference2;
            resultItem2.properties = new PropertyValue[]{propertyValue};
            arrayList.add(resultItem2);
            taskHistoryCollector.remove();
        }
        return arrayList;
    }

    private List<ResultItem> getScheduledOperationExecutionInfo(ManagedObjectReference managedObjectReference) throws Exception {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        arrayList.add(managedObjectReference);
        return this.getScheduledOperationExecutionInfo(arrayList);
    }
}

