/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.richtext.AbstractRichParagraphNode;
import com.adobe.internal.fxg.dom.richtext.TextHelper;
import com.adobe.internal.fxg.dom.types.BaselineOffset;
import com.adobe.internal.fxg.dom.types.BlockProgression;
import com.adobe.internal.fxg.dom.types.LineBreak;
import com.adobe.internal.fxg.dom.types.NumberAuto;
import com.adobe.internal.fxg.dom.types.NumberInherit;
import com.adobe.internal.fxg.dom.types.VerticalAlign;

public abstract class AbstractRichBlockTextNode
extends AbstractRichParagraphNode {
    protected static final double PADDING_MIN_INCLUSIVE = 0.0;
    protected static final double PADDING_MAX_INCLUSIVE = 1000.0;
    protected static final double BASELINEOFFSET_MIN_INCLUSIVE = 0.0;
    protected static final double BASELINEOFFSET_MAX_INCLUSIVE = 1000.0;
    protected static final int COLUMNCOUNT_MIN_INCLUSIVE = 0;
    protected static final int COLUMNCOUNT_MAX_INCLUSIVE = 50;
    protected static final double COLUMNGAP_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNGAP_MAX_INCLUSIVE = 1000.0;
    protected static final double COLUMNWIDTH_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNWIDTH_MAX_INCLUSIVE = 8000.0;
    public BlockProgression blockProgression = BlockProgression.TB;
    public NumberInherit paddingLeft = NumberInherit.newInstance(0.0);
    public NumberInherit paddingRight = NumberInherit.newInstance(0.0);
    public NumberInherit paddingTop = NumberInherit.newInstance(0.0);
    public NumberInherit paddingBottom = NumberInherit.newInstance(0.0);
    public LineBreak lineBreak = LineBreak.TOFIT;
    public NumberInherit columnGap = NumberInherit.newInstance(20.0);
    public NumberAuto columnCount = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public NumberAuto columnWidth = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public BaselineOffset firstBaselineOffset = BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
    public VerticalAlign verticalAlign = VerticalAlign.TOP;

    public void setAttribute(String name, String value) {
        if ("blockProgression".equals(name)) {
            this.blockProgression = TextHelper.getBlockProgression(this, value);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingLeft.getNumberInheritAsDbl(), "UnknownPaddingLeft");
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingRight.getNumberInheritAsDbl(), "UnknownPaddingRight");
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingTop.getNumberInheritAsDbl(), "UnknownPaddingTop");
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingBottom.getNumberInheritAsDbl(), "UnknownPaddingBottom");
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = TextHelper.getLineBreak(this, value);
        } else if ("columnGap".equals(name)) {
            this.columnGap = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.columnGap.getNumberInheritAsDbl(), "UnknownColumnGap");
        } else if ("columnCount".equals(name)) {
            this.columnCount = this.getNumberAutoInt(this, name, value, 0, 50, this.columnCount.getNumberAutoAsInt(), "UnknownColumnCount");
        } else if ("columnWidth".equals(name)) {
            this.columnWidth = this.getNumberAutoDbl(this, name, value, 0.0, 8000.0, this.columnWidth.getNumberAutoAsDbl(), "UnknownColumnWidth");
        } else if ("firstBaselineOffset".equals(name)) {
            this.firstBaselineOffset = this.getFirstBaselineOffset(this, name, value, 0.0, 1000.0, this.firstBaselineOffset.getBaselineOffsetAsDbl());
        } else if ("verticalAlign".equals(name)) {
            this.verticalAlign = TextHelper.getVerticalAlign(this, value);
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private BaselineOffset getFirstBaselineOffset(FXGNode node, String name, String value, double min, double max, double defaultValue) {
        if ("auto".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
        }
        if ("ascent".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.ASCENT);
        }
        if ("lineHeight".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.LINEHEIGHT);
        }
        try {
            return BaselineOffset.newInstance(DOMParserHelper.parseDouble(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownFirstBaselineOffset", value);
        }
    }

    private NumberAuto getNumberAutoDbl(FXGNode node, String name, String value, double min, double max, double defaultValue, String errorCode) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseDouble(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }

    private NumberAuto getNumberAutoInt(FXGNode node, String name, String value, int min, int max, int defaultValue, String errorCode) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseInt(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }

    private NumberInherit getNumberInherit(FXGNode node, String name, String value, double min, double max, double defaultValue, String errorCode) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }
}

