/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcextension.impl;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vcextension.common.VcExtensionManagerProxy;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingVcExtensionManagerProxy
implements VcExtensionManagerProxy {
    private static final Log _logger = LogFactory.getLog(CachingVcExtensionManagerProxy.class);
    private final SelfPopulatingCache _cache;
    private final ExecutorService _taskExecutor;

    public CachingVcExtensionManagerProxy(ExecutorService taskExecutor, String cacheConfigPath) {
        Validate.notNull((Object)taskExecutor, (String)"Executor service");
        Validate.notNull((Object)cacheConfigPath, (String)"Configuration path");
        URL cacheConfig = this.getClass().getResource(cacheConfigPath);
        if (cacheConfig == null) {
            throw new IllegalArgumentException("Cache configuration not found at '" + cacheConfigPath + "'");
        }
        this._cache = this.createCache(cacheConfig);
        this._taskExecutor = taskExecutor;
    }

    public Map<String, List<Extension>> getAllExtensionsForServers(Set<String> serverGuids) {
        Validate.notNull(serverGuids, (String)"Server GUIDs");
        for (String serverGuid : serverGuids) {
            this.validateServerGuid(serverGuid);
        }
        if (serverGuids.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.getExtensionsInternal(serverGuids);
    }

    public List<Extension> getExtensionsForServer(String serverGuid, Set<String> extensionKeys) {
        this.validateServerGuid(serverGuid);
        Validate.notNull(extensionKeys, (String)"Extension key set");
        if (extensionKeys.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> serverGuids = new HashSet<String>(1);
        serverGuids.add(serverGuid);
        Map<String, List<Extension>> extensions = this.getExtensionsInternal(serverGuids);
        assert (extensions.size() == 1) : "Unexpected size of returned map";
        assert (extensions.containsKey(serverGuid)) : "Server entry missing in returned map";
        ArrayList<Extension> result = new ArrayList<Extension>(extensionKeys.size());
        for (Extension extension : extensions.get(serverGuid)) {
            assert (extension != null) : "Unexpected null extension in cache entry value";
            if (!extensionKeys.contains(extension.getKey())) continue;
            result.add(extension);
        }
        return result;
    }

    private void validateServerGuid(String serverGuid) {
        Validate.notNull((Object)serverGuid, (String)"Server GUID");
        if (serverGuid.isEmpty()) {
            throw new IllegalArgumentException("Server GUID is an empty string");
        }
    }

    private SelfPopulatingCache createCache(URL cacheConfigLocation) {
        assert (cacheConfigLocation != null) : "Cache config URI null";
        _logger.info((Object)("Loading cache configuration from " + cacheConfigLocation));
        CacheManager cacheManager = CacheManager.create((URL)cacheConfigLocation);
        cacheManager.addCache("vcExtensionManagerCache");
        return new SelfPopulatingCache((Ehcache)cacheManager.getCache("vcExtensionManagerCache"), (CacheEntryFactory)new ExtensionLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Extension>> getExtensionsInternal(Set<String> serverGuids) {
        assert (!CollectionUtil.isNullOrEmpty(serverGuids)) : "null or empty server set";
        HashMap<String, List<Extension>> result = new HashMap<String, List<Extension>>(serverGuids.size());
        HashSet<String> cacheHits = new HashSet<String>();
        Map cachedElements = Collections.emptyMap();
        SelfPopulatingCache selfPopulatingCache = this._cache;
        synchronized (selfPopulatingCache) {
            this._cache.evictExpiredElements();
            for (String key : serverGuids) {
                assert (key != null) : "null server GUID";
                if (!this._cache.isKeyInCache((Object)key)) continue;
                cacheHits.add(key);
            }
            cachedElements = this._cache.getAll(cacheHits);
        }
        this.addEntries(result, cachedElements.values());
        Set cacheMisses = CollectionUtil.minus(serverGuids, cacheHits);
        _logger.info((Object)(cachedElements.size() + " cache hits and " + cacheMisses.size() + " misses."));
        List<Element> retrievedElements = Collections.emptyList();
        if (cacheMisses.size() == 1) {
            retrievedElements = this.getElements(cacheMisses);
        } else if (cacheMisses.size() > 1) {
            try {
                retrievedElements = this.getElementsAsync(cacheMisses);
            }
            catch (InterruptedException e) {
                _logger.warn((Object)"Interrupted during async extension retrieval.");
                return result;
            }
        }
        this.addEntries(result, retrievedElements);
        return result;
    }

    private List<Element> getElements(Set<String> serverGuids) {
        assert (!CollectionUtil.isNullOrEmpty(serverGuids)) : "null or empty server set";
        ArrayList<Element> result = new ArrayList<Element>();
        for (String serverGuid : serverGuids) {
            Element element = this._cache.get((Serializable)((Object)serverGuid));
            result.add(element);
        }
        return result;
    }

    private List<Element> getElementsAsync(Set<String> serverGuids) throws InterruptedException {
        assert (!CollectionUtil.isNullOrEmpty(serverGuids)) : "null or empty server set";
        List<Callable<Element>> queryTasks = this.createGetTasks(serverGuids);
        List results = ExecutorUtil.executeTasks(queryTasks, (Executor)this._taskExecutor);
        ArrayList<Element> retrievedElements = new ArrayList<Element>();
        for (ExecutorUtil.TaskResult cacheRetrieval : results) {
            Element element = (Element)cacheRetrieval.getResult();
            assert (element != null) : "Null cache entry";
            assert (element.getObjectValue() != null) : "Null cache entry element value";
            retrievedElements.add(element);
        }
        return retrievedElements;
    }

    private List<Callable<Element>> createGetTasks(Set<String> serverGuids) {
        ArrayList<Callable<Element>> result = new ArrayList<Callable<Element>>();
        for (final String serverGuid : serverGuids) {
            Callable<Element> requestTask = new Callable<Element>(){
                private final String _serverGuid;
                {
                    this._serverGuid = serverGuid;
                }

                @Override
                public Element call() {
                    return CachingVcExtensionManagerProxy.this._cache.get((Serializable)((Object)this._serverGuid));
                }
            };
            result.add(requestTask);
        }
        return result;
    }

    private void addEntries(Map<String, List<Extension>> result, Collection<Element> cacheEntries) {
        assert (result != null && cacheEntries != null) : "null argument";
        for (Element cacheEntry : cacheEntries) {
            assert (cacheEntry != null) : "Unexpected null cache element";
            assert (cacheEntry.getObjectKey() != null) : "Unexpected null element key";
            assert (cacheEntry.getObjectValue() != null) : "Unexpected null element value";
            assert (cacheEntry.getObjectKey() instanceof String) : "Unexpected element key type";
            assert (cacheEntry.getObjectValue() instanceof List) : "Unexpected element value type";
            assert (!result.containsKey((String)cacheEntry.getObjectKey())) : "Result already exists";
            List entryValue = (List)cacheEntry.getObjectValue();
            ArrayList entryCopy = new ArrayList(entryValue);
            result.put((String)cacheEntry.getObjectKey(), entryCopy);
        }
    }

    private static class ExtensionLoader
    implements CacheEntryFactory {
        private ExtensionLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object createEntry(Object key) {
            assert (key instanceof String) : "Cache entry key not of type String";
            List result = Collections.emptyList();
            String serverGuid = (String)key;
            StopWatch timer = new StopWatch();
            timer.start();
            try {
                VcService sourceVcServer = VimSessionUtil.getService((String)serverGuid);
                ManagedObjectReference extensionManagerRef = sourceVcServer.getServiceInstanceContent().extensionManager;
                ExtensionManager extensionManager = (ExtensionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)extensionManagerRef);
                Object[] extensions = extensionManager.getExtensionList();
                if (!ArrayUtil.isNullOrEmpty((Object[])extensions)) {
                    result = new ArrayList(extensions.length);
                    for (Object extension : extensions) {
                        if (extension == null) {
                            _logger.error((Object)"Unexpected null Extension returned by ExtensionManager");
                            continue;
                        }
                        result.add(extension);
                    }
                }
            }
            catch (Exception exception) {
                _logger.error((Object)("Exception during extension retrieval from server with GUID " + serverGuid + ". An empty extension list was stored in the cache."), (Throwable)exception);
            }
            finally {
                timer.stop();
                _logger.info((Object)("Retrieval of VC extensions from server with GUID " + serverGuid + " took " + timer.getTime() + " ms"));
            }
            return result;
        }
    }
}

