/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.AuthCalculator;
import com.vmware.vim.sso.http.Request;
import com.vmware.vim.sso.http.SignatureAlgorithm;
import com.vmware.vim.sso.http.impl.CryptoEngines;
import com.vmware.vim.sso.http.impl.Token;
import com.vmware.vim.sso.http.impl.TokenFormatter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

public final class AuthCalculatorImpl
implements AuthCalculator {
    public static final int MIN_TOKEN_CHUNK_LENGTH = 128;
    private final CryptoEngines _crypto;
    private final int _maxTokenChunkLength;

    public AuthCalculatorImpl(SignatureAlgorithm alg, int maxTokenChunkLength) {
        assert (alg != null) : "No signature algorithm specified!";
        assert (maxTokenChunkLength >= 128) : "The desired max chunk length is lower than the minimum supported one!";
        try {
            this._crypto = new CryptoEngines(alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(alg.name() + " is not supported!", e);
        }
        this._maxTokenChunkLength = maxTokenChunkLength;
    }

    @Override
    public String[] computeToken(Request req, PrivateKey secret, String samlTokenXml) throws IOException {
        assert (req != null) : "HTTP request is a mandatory argument!";
        assert (secret != null) : "The User's Private Key is a mandatory argument!";
        assert (samlTokenXml != null) : "The User's SAML token is a mandatory argument!";
        Token token = new Token(samlTokenXml, this._crypto, req, secret);
        return TokenFormatter.newInstance().format(token, this._maxTokenChunkLength);
    }
}

