/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.impl.ParamFormatter;
import com.vmware.vim.sso.http.impl.ParamValue;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ChunkParser
implements Iterator<ParamValue> {
    private static final Pattern PARAM_DELIMITER = Pattern.compile("\\s*,\\s*");
    private final String txt;
    private final Matcher prefixMatcher;
    private final Matcher paramDelimiterMatcher;
    private boolean firstParam = true;

    ChunkParser(String txt, String prefix) {
        assert (txt != null);
        this.txt = txt;
        this.prefixMatcher = prefix != null ? Pattern.compile(prefix).matcher(txt) : null;
        this.paramDelimiterMatcher = PARAM_DELIMITER.matcher(txt);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParamValue next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int nextParamStart = this.lookingAtPrefix();
        ParsePosition pos = new ParsePosition(nextParamStart);
        ParamValue param = ParamFormatter.parse(this.txt, pos);
        if (param == null) {
            this.throwParseEx(this.paramDelimiterMatcher);
        }
        this.movePosition(pos.getIndex());
        return param;
    }

    @Override
    public boolean hasNext() {
        return this.position(this.paramDelimiterMatcher) < this.txt.length();
    }

    private int lookingAtPrefix() {
        int nextStartIndex = 0;
        if (this.firstParam) {
            assert (this.position(this.paramDelimiterMatcher) == 0);
            if (this.prefixMatcher != null) {
                nextStartIndex = this.lookAt(this.prefixMatcher);
            }
        } else {
            nextStartIndex = this.lookAt(this.paramDelimiterMatcher);
        }
        this.firstParam = false;
        return nextStartIndex;
    }

    private int lookAt(Matcher matcher) {
        assert (matcher != null);
        if (!matcher.lookingAt()) {
            this.throwParseEx(matcher);
        }
        return matcher.end();
    }

    private void throwParseEx(Matcher matcher) {
        throw new IllegalArgumentException("The HTTP token has invalid syntax arround index " + this.position(matcher));
    }

    private void movePosition(int start) {
        this.paramDelimiterMatcher.region(start, this.paramDelimiterMatcher.regionEnd());
    }

    private int position(Matcher matcher) {
        return matcher.regionStart();
    }
}

