/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import java.util.Date;
import java.util.Random;

final class Nonce
implements Comparable<Nonce> {
    static final char DELIMITER = ':';
    private final Date _createdOn;
    private final String _appender;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean result = false;
        if (obj instanceof Nonce) {
            Nonce other = (Nonce)obj;
            result = this._createdOn.equals(other._createdOn) && this._appender.equals(other._appender);
        }
        return result;
    }

    public int hashCode() {
        return this._createdOn.hashCode() * 13 + this._appender.hashCode();
    }

    public String toString() {
        return Long.toString(this._createdOn.getTime()) + ':' + this._appender;
    }

    @Override
    public int compareTo(Nonce o) {
        int datesComp = this._createdOn.compareTo(o._createdOn);
        return datesComp != 0 ? datesComp : this._appender.compareTo(o._appender);
    }

    Date createdOn() {
        return this._createdOn;
    }

    String appender() {
        return this._appender;
    }

    static Nonce generateNow() {
        return new Nonce(new Date(), String.valueOf(Math.abs(new Random().nextInt())));
    }

    static Nonce parse(String nonceTxt) {
        assert (nonceTxt != null);
        int delimiterIndex = nonceTxt.indexOf(58);
        if (delimiterIndex == -1 || delimiterIndex == 0 || delimiterIndex == nonceTxt.length() - 1) {
            throw new IllegalArgumentException("The delimiter is not found or is at a wrong place!");
        }
        return new Nonce(new Date(Long.parseLong(nonceTxt.substring(0, delimiterIndex))), nonceTxt.substring(delimiterIndex + 1));
    }

    static Nonce firstAt(Date createdOn) {
        return new Nonce(createdOn, "\u0000");
    }

    private Nonce(Date createdOn, String appender) {
        assert (createdOn != null);
        assert (appender != null && appender.length() > 0);
        this._createdOn = createdOn;
        this._appender = appender;
    }
}

