/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

final class ParamValue {
    private final Param _key;
    private final String _value;

    ParamValue(Param key, String value) {
        assert (key != null);
        assert (value != null && !value.isEmpty());
        this._key = key;
        this._value = value;
    }

    public int hashCode() {
        return 31 * this._key.hashCode() + this._value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean result = false;
        if (obj instanceof ParamValue) {
            ParamValue o = (ParamValue)obj;
            result = this._key.equals((Object)o._key) && this._value.equals(o._value);
        }
        return result;
    }

    public String toString() {
        return String.format("Param(%s, %s)", new Object[]{this._key, this._value});
    }

    Param key() {
        return this._key;
    }

    String value() {
        return this._value;
    }

    ParamValue ltrim(int chars) {
        assert (chars >= 0 && chars <= this._value.length());
        return chars == 0 ? this : (chars == this._value.length() ? null : new ParamValue(this._key, this._value.substring(chars)));
    }

    ParamValue first(int chars) {
        assert (chars >= 0);
        return chars == 0 ? null : (chars == this._value.length() ? this : new ParamValue(this._key, this._value.substring(0, chars)));
    }

    ParamValue concat(ParamValue param) {
        assert (param != null && param.key().equals((Object)this._key));
        return new ParamValue(this._key, this._value.concat(param.value()));
    }

    static enum Param {
        token,
        nonce,
        bodyhash,
        signature_alg,
        signature;


        boolean required() {
            return this != bodyhash;
        }
    }
}

