/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.AuthException;
import com.vmware.vim.sso.http.Request;
import com.vmware.vim.sso.http.SignatureAlgorithm;
import com.vmware.vim.sso.http.impl.CryptoEngines;
import com.vmware.vim.sso.http.impl.Nonce;
import com.vmware.vim.sso.http.impl.UTF8Convertor;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;

final class Token {
    private static final char NORMALIZATION_DELIMITER = '\n';
    private static final int NORMALIZATION_DELIMITER_LENGTH = 1;
    private static final int INT_LENGTH_IN_BYTES = 4;
    private static final int BITS_IN_BYTE = 8;
    private final String _samlTokenXml;
    private final Nonce _nonce;
    private final CryptoEngines _crypto;
    private final byte[] _bodyHash;
    private final byte[] _signature;

    Token(String samlTokenXml, CryptoEngines crypto, Request req, PrivateKey secret) throws IOException {
        assert (samlTokenXml != null);
        assert (crypto != null);
        assert (req != null);
        assert (secret != null);
        this._samlTokenXml = samlTokenXml;
        this._nonce = Nonce.generateNow();
        this._crypto = crypto;
        this._bodyHash = this.computeBodyHash(req);
        this._signature = this.computeSignature(req, secret);
    }

    Token(String samlTokenXml, Nonce nonce, CryptoEngines crypto, byte[] bodyHash, byte[] signature) {
        assert (samlTokenXml != null);
        assert (nonce != null);
        assert (crypto != null);
        assert (signature != null);
        this._samlTokenXml = samlTokenXml;
        this._nonce = nonce;
        this._crypto = crypto;
        this._bodyHash = bodyHash;
        this._signature = signature;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean result = false;
        if (obj instanceof Token) {
            Token other = (Token)obj;
            result = other._samlTokenXml.equals(this._samlTokenXml) && other.nonce().equals(this._nonce) && other._crypto.algorithm() == this._crypto.algorithm() && Arrays.equals(other._bodyHash, this._bodyHash) && Arrays.equals(other._signature, this._signature);
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        for (int offset = 0; offset < Math.min(4, this._signature.length); ++offset) {
            result = result << 8 & this._signature[offset];
        }
        return result;
    }

    String samlToken() {
        return this._samlTokenXml;
    }

    Nonce nonce() {
        return this._nonce;
    }

    byte[] bodyHash() {
        byte[] res = null;
        if (this._bodyHash != null) {
            res = new byte[this._bodyHash.length];
            System.arraycopy(this._bodyHash, 0, res, 0, res.length);
        }
        return res;
    }

    SignatureAlgorithm signAlgorithm() {
        return this._crypto.algorithm();
    }

    byte[] signature() {
        byte[] res = new byte[this._signature.length];
        System.arraycopy(this._signature, 0, res, 0, res.length);
        return res;
    }

    void checkBodyHash(Request req) throws IOException {
        assert (req != null);
        if (!Arrays.equals(this._bodyHash, this.computeBodyHash(req))) {
            throw new AuthException("Body hash does not match!");
        }
    }

    void checkSignature(Request req, PublicKey confKey) {
        assert (req != null);
        assert (confKey != null);
        Signature verifier = this.verifierSetup(confKey);
        assert (verifier != null);
        try {
            verifier.update(this.normalizeMsg(req));
            if (!verifier.verify(this._signature)) {
                throw new AuthException("The message signature is not correct!");
            }
        }
        catch (SignatureException e) {
            throw new AuthException("Unable to verify the message!", e);
        }
    }

    private byte[] computeBodyHash(Request req) throws IOException {
        assert (req != null);
        InputStream is = req.payload();
        if (is == null) {
            return null;
        }
        MessageDigest hasher = this._crypto.digestEngine();
        assert (hasher != null);
        byte[] buf = new byte[2048];
        int nb = 0;
        while ((nb = is.read(buf)) != -1) {
            hasher.update(buf, 0, nb);
        }
        return hasher.digest();
    }

    private byte[] computeSignature(Request req, PrivateKey secret) {
        Signature signer = this.signerSetup(secret);
        assert (signer != null);
        try {
            signer.update(this.normalizeMsg(req));
            return signer.sign();
        }
        catch (SignatureException e) {
            throw new AuthException("Unable to sign the message!", e);
        }
    }

    private byte[] normalizeMsg(Request req) {
        assert (req != null);
        StringBuilder txtMsg = new StringBuilder();
        this.appendElement(txtMsg, this._nonce.toString());
        this.appendElement(txtMsg, req.method().name());
        this.appendElement(txtMsg, req.requestURI());
        this.appendElement(txtMsg, req.hostName().toLowerCase());
        this.appendElement(txtMsg, Integer.toString(req.port()));
        byte[] txtMsgUtf8Bytes = UTF8Convertor.toUTF8Bytes(txtMsg.toString());
        byte[] res = new byte[txtMsgUtf8Bytes.length + (this._bodyHash != null ? this._bodyHash.length : 0) + 1];
        int offset = 0;
        System.arraycopy(txtMsgUtf8Bytes, 0, res, offset, txtMsgUtf8Bytes.length);
        offset += txtMsgUtf8Bytes.length;
        if (this._bodyHash != null) {
            System.arraycopy(this._bodyHash, 0, res, offset, this._bodyHash.length);
            offset += this._bodyHash.length;
        }
        res[offset] = 10;
        return res;
    }

    private void appendElement(StringBuilder sb, String element) {
        sb.append(element);
        sb.append('\n');
    }

    private Signature signerSetup(PrivateKey secret) {
        Signature signer = this._crypto.signatureEngine();
        try {
            signer.initSign(secret);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("The private key is invalid!", e);
        }
        return signer;
    }

    private Signature verifierSetup(PublicKey confKey) {
        Signature verifier = this._crypto.signatureEngine();
        try {
            verifier.initVerify(confKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("The confirmation key is invalid!", e);
        }
        return verifier;
    }
}

