/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import com.vmware.vim.sso.http.SignatureAlgorithm;
import com.vmware.vim.sso.http.impl.ApacheCommonsBase64;
import com.vmware.vim.sso.http.impl.ChunkBuilder;
import com.vmware.vim.sso.http.impl.ChunkParser;
import com.vmware.vim.sso.http.impl.CryptoEngines;
import com.vmware.vim.sso.http.impl.GZipJ2SECompress;
import com.vmware.vim.sso.http.impl.Nonce;
import com.vmware.vim.sso.http.impl.ParamValue;
import com.vmware.vim.sso.http.impl.Token;
import com.vmware.vim.sso.http.impl.UTF8Convertor;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

final class TokenFormatter {
    public static final int MIN_TOKEN_CHUNK_LENGTH = 128;
    private static final String SCHEMA_ID = "SIGN";
    private static final String SCHEMA_ID_REGEX = "SIGN\\s";
    private final Base64 _base64;
    private final Compress _compress;
    static final /* synthetic */ boolean $assertionsDisabled;

    static TokenFormatter newInstance() {
        return new TokenFormatter(new ApacheCommonsBase64(), new GZipJ2SECompress());
    }

    TokenFormatter(Base64 base64, Compress compress) {
        if (!$assertionsDisabled && base64 == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && compress == null) {
            throw new AssertionError();
        }
        this._base64 = base64;
        this._compress = compress;
    }

    Token parse(String[] token) {
        if (!$assertionsDisabled && token == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && token.length <= 0) {
            throw new AssertionError();
        }
        ParamValue[] params = new ParamValue[ParamValue.Param.values().length];
        for (int i = 0; i < token.length; ++i) {
            ChunkParser chunkParser = new ChunkParser(token[i], i == 0 ? SCHEMA_ID_REGEX : null);
            while (chunkParser.hasNext()) {
                ParamValue param = chunkParser.next();
                if (!$assertionsDisabled && param == null) {
                    throw new AssertionError();
                }
                int ordinal = param.key().ordinal();
                params[ordinal] = params[ordinal] == null ? param : params[ordinal].concat(param);
            }
        }
        this.checkMissingParams(params);
        String samlToken = UTF8Convertor.fromUTF8Bytes(this._compress.decompress(this._base64.decode(this.paramValue(params, ParamValue.Param.token))));
        Nonce nonce = Nonce.parse(this.paramValue(params, ParamValue.Param.nonce));
        CryptoEngines crypto = TokenFormatter.createCrypto(this.paramValue(params, ParamValue.Param.signature_alg));
        byte[] bodyHash = this._base64.decode(this.paramValue(params, ParamValue.Param.bodyhash));
        byte[] signature = this._base64.decode(this.paramValue(params, ParamValue.Param.signature));
        return new Token(samlToken, nonce, crypto, bodyHash, signature);
    }

    String[] format(Token token, int maxChunkLength) throws IOException {
        if (!$assertionsDisabled && token == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && maxChunkLength < 128) {
            throw new AssertionError();
        }
        ArrayList<ParamValue> params = new ArrayList<ParamValue>(ParamValue.Param.values().length);
        params.add(new ParamValue(ParamValue.Param.token, this._base64.encode(this._compress.compress(UTF8Convertor.toUTF8Bytes(token.samlToken())))));
        params.add(new ParamValue(ParamValue.Param.nonce, token.nonce().toString()));
        params.add(new ParamValue(ParamValue.Param.bodyhash, this._base64.encode(token.bodyHash())));
        params.add(new ParamValue(ParamValue.Param.signature_alg, token.signAlgorithm().toString()));
        params.add(new ParamValue(ParamValue.Param.signature, this._base64.encode(token.signature())));
        ArrayList<String> res = new ArrayList<String>();
        ChunkBuilder chunkFormatter = new ChunkBuilder(maxChunkLength, "SIGN ");
        for (ParamValue param : params) {
            chunkFormatter = this.appendParam(res, chunkFormatter, maxChunkLength, param);
        }
        res.add(chunkFormatter.value());
        return res.toArray(new String[res.size()]);
    }

    private String paramValue(ParamValue[] params, ParamValue.Param key) {
        ParamValue paramValue = params[key.ordinal()];
        return paramValue == null ? null : paramValue.value();
    }

    private void checkMissingParams(ParamValue[] params) {
        for (ParamValue.Param param : ParamValue.Param.values()) {
            if (!param.required() || params[param.ordinal()] != null) continue;
            throw new IllegalArgumentException("Required parameter " + param.name() + " is missing!");
        }
    }

    private ChunkBuilder appendParam(List<String> chunks, ChunkBuilder chunkFormatter, int maxLength, ParamValue param) {
        ChunkBuilder res = chunkFormatter;
        while (param != null) {
            ParamValue next = res.append(param);
            if (next != null && next.equals(param)) {
                chunks.add(res.value());
                res = new ChunkBuilder(maxLength);
            }
            param = next;
        }
        return res;
    }

    private static CryptoEngines createCrypto(String algoName) {
        CryptoEngines crypto;
        SignatureAlgorithm alg = SignatureAlgorithm.pickup(algoName);
        if (alg == null) {
            throw new IllegalArgumentException("The signature algorithm name in not known!");
        }
        try {
            crypto = new CryptoEngines(alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(alg.name() + " is not supported!", e);
        }
        if (!$assertionsDisabled && crypto == null) {
            throw new AssertionError();
        }
        return crypto;
    }

    static {
        boolean bl = $assertionsDisabled = !TokenFormatter.class.desiredAssertionStatus();
        if (!$assertionsDisabled && 128 <= SCHEMA_ID.length() + ParamValue.Param.signature_alg.name().length() + 4) {
            throw new AssertionError();
        }
    }

    static interface Compress {
        public byte[] compress(byte[] var1);

        public byte[] decompress(byte[] var1);
    }

    static interface Base64 {
        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }
}

