/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.http.impl;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

final class UTF8Convertor {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    UTF8Convertor() {
    }

    static byte[] toUTF8Bytes(String txt) {
        ByteBuffer encoded;
        assert (txt != null);
        CharsetEncoder encoder = UTF8_CHARSET.newEncoder();
        try {
            encoded = encoder.encode(CharBuffer.wrap(txt));
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("The character sequence contains invalid code points!", e);
        }
        byte[] result = new byte[encoded.remaining()];
        encoded.get(result);
        return result;
    }

    static String fromUTF8Bytes(byte[] utf8Bytes) {
        CharBuffer decoded;
        assert (utf8Bytes != null);
        CharsetDecoder decoder = UTF8_CHARSET.newDecoder();
        try {
            decoded = decoder.decode(ByteBuffer.wrap(utf8Bytes));
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("The byte sequence contains invalid UTF-8 values!", e);
        }
        char[] result = new char[decoded.remaining()];
        decoded.get(result);
        return new String(result);
    }
}

