/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host;

import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.cm.ComponentManagerService;
import com.vmware.vise.vim.cm.UserSpecificCmFactory;
import java.util.Locale;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserSessionListenerImpl
implements UserSessionListener {
    private static final Log _logger = LogFactory.getLog(UserSessionListenerImpl.class);
    private final UserSpecificCmFactory _cmFactory;

    public UserSessionListenerImpl(UserSpecificCmFactory cmFactory) {
        this._cmFactory = cmFactory;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        SessionUtil.setData((String)"com.vmware.mhm", (Object)this.validateMhmServiceInstalled());
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
    }

    private boolean validateMhmServiceInstalled() {
        ServiceEndPointTypeImpl endPointType = new ServiceEndPointTypeImpl();
        endPointType.setTypeId("com.vmware.gateway");
        SearchCriteriaImpl searchCriteria = new SearchCriteriaImpl();
        searchCriteria.setEndPointType((ServiceEndPointType)endPointType);
        searchCriteria.setResultFieldList(new String[]{ServiceInfo.ServiceField.SERVICE_TYPE.toString()});
        ComponentManagerService cmService = this._cmFactory.getComponentManagerService();
        Object[] allGateways = null;
        try {
            allGateways = cmService.search((SearchCriteria)searchCriteria);
        }
        catch (ComponentManagerFault e) {
            _logger.error((Object)"Error while validating if MHM is installed", (Throwable)e);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])allGateways)) {
            for (Object serviceInfo : allGateways) {
                String productId = serviceInfo.getServiceType().getProductId();
                if (!"com.vmware.mhm".equals(productId)) continue;
                return true;
            }
        }
        return false;
    }
}

