/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.PropertyParam;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.host.IpConfig;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@QueryModel(value="HostSystem")
public class HostExtendedDataModel {
    @Property(value="HostSystem/runtime/powerState")
    String powerState;
    @Property(value="HostSystem/runtime/inMaintenanceMode")
    Boolean inMaintenanceMode;
    @Property(value="HostSystem/runtime/inMaintenanceMode")
    String inMaintenanceModeString;
    @Property(value="HostSystem/runtime/connectionState")
    String connectionState;
    @Property(value="HostSystem/network")
    String[] allNetwork;
    @Property(value="HostSystem/config/product")
    AboutInfo product;
    @Property(value="HostSystem/config/network/consoleVnic")
    VirtualNic[] nics;
    @Property(value="HostSystem/configManager/storageSystem")
    String storageSystem;
    @Property(value="HostSystem/configManager/datastoreSystem")
    String datastoreSystem;
    @Property(value="HostSystem/configManager/cacheConfigurationManager")
    String cacheConfigurationManager;
    @Property(value="HostSystem/configManager/diagnosticSystem")
    String diagnosticSystem;
    @Property(value="HostSystem/configManager/firewallSystem")
    String firewallSystem;
    @Relationship(value={"HostSystem/parent"})
    @Property(value="ClusterComputeResource/@modelKey")
    ManagedObjectReference cluster;
    @Relationship(value={"HostSystem/parent"})
    @Property(value="ClusterComputeResource/name")
    String hostClusterName;
    @Relationship(value={"HostSystem/parent", "ComputeResource/resourcePool"})
    @Property(value="ResourcePool/@modelKey")
    ManagedObjectReference rootRp;
    @Relationship(value={"HostSystem/parent", "ComputeResource/resourcePool"})
    @Property(value="ResourcePool/@modelKey")
    ManagedObjectReference rp;
    @Relationship(value={"HostSystem/network"})
    @Property(value="DistributedVirtualPortgroup/@modelKey")
    ManagedObjectReference[] dvpg;
    @Relationship(value={"HostSystem/network"})
    @Property(value="Network/@modelKey")
    ManagedObjectReference[] standardnetwork;
    @Relationship(value={"HostSystem/network"})
    @Property(value="OpaqueNetwork/@modelKey")
    ManagedObjectReference[] opaquenetwork;
    @Relationship(value={"HostSystem/datastore", "Datastore/parent"})
    @Property(value="StoragePod/@modelKey")
    ManagedObjectReference[] storagePod;
    @Relationship(value={"AnyStorage/hostKey~"})
    @Property(value="AnyStorage/@modelKey")
    ManagedObjectReference[] storage;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/notBefore")
    Date certificateValidFrom;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/notAfter")
    Date certificateValidTo;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/status")
    String certificateStatus;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/issuer")
    String certificateIssuer;
    @Relationship(value={"HostSystem/configManager/certificateManager"})
    @Property(value="HostCertificateManager/certificateInfo/subject")
    String certificateSubject;
    @Relationship(value={"HostSystem/parent", "AnyComputeResource/resourcePool"})
    @Property(value="ResourcePool/@modelKey")
    ManagedObjectReference resourcePool;
    @Relationship(value={"HostSystem/network"})
    @Property(value="DistributedVirtualPortgroup/config/distributedVirtualSwitch")
    ManagedObjectReference[] dvs;
    @Relationship(value={"HostSystem/network"})
    @Property(value="HostNetwork/@modelKey")
    ManagedObjectReference[] hostNetwork;
    @Relationship(value={"HostSystem/hp"})
    @Property(value="HostProfile/name")
    String associatedProfileName;
    @Relationship(value={"HostSystem/hp"})
    @Property(value="HostProfile/@modelKey")
    ManagedObjectReference associatedProfile;
    @Property(value="HostSystem/hostProfileComplianceStatus")
    String hostCompliance;
    @Relationship(value={"HostSystem/parent", "ComputeResource/resourcePool"})
    @Property(value="ResourcePool/rpcontents")
    ManagedObjectReference[] rootRpContents;
    @Relationship(value={"ScheduledTask/info/taskObject~"})
    @Property(value="ScheduledTask/@modelKey")
    ManagedObjectReference[] scheduledTask;

    @DerivedProperty
    public static String[] getIp(@PropertyParam(value="HostSystem/config/network/vnic") VirtualNic[] vnic, @PropertyParam(value="HostSystem/config/network/consoleVnic") VirtualNic[] consoleVnic, @PropertyParam(value="HostSystem/config/network/pnic") PhysicalNic[] pnic) {
        List<String> ipAll = HostExtendedDataModel.getVnicIpV4Addresses(vnic);
        ipAll.addAll(HostExtendedDataModel.getVnicIpV4Addresses(consoleVnic));
        ipAll.addAll(HostExtendedDataModel.getPnicIpV4Addresses(pnic));
        return ipAll.toArray(new String[ipAll.size()]);
    }

    @DerivedProperty
    public static String[] getIpv6(@PropertyParam(value="HostSystem/config/network/vnic") VirtualNic[] vnic, @PropertyParam(value="HostSystem/config/network/consoleVnic") VirtualNic[] consoleVnic, @PropertyParam(value="HostSystem/config/network/pnic") PhysicalNic[] pnic) {
        List<String> ipAll = HostExtendedDataModel.getVnicIpV6Addresses(vnic);
        ipAll.addAll(HostExtendedDataModel.getVnicIpV6Addresses(consoleVnic));
        ipAll.addAll(HostExtendedDataModel.getPnicIpV6Addresses(pnic));
        return ipAll.toArray(new String[ipAll.size()]);
    }

    @DerivedProperty
    public static String getEncryptionStatus(@PropertyParam(value="HostSystem/runtime/cryptoState") String cryptoState) {
        if (cryptoState == null) {
            return "na";
        }
        return cryptoState;
    }

    private static List<String> getVnicIpV4Addresses(VirtualNic[] vnic) {
        if (ArrayUtil.isNullOrEmpty((Object[])vnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < vnic.length; ++i) {
            VirtualNic.Specification vnicSpec = vnic[i].spec;
            if (vnicSpec == null || vnicSpec.ip == null || StringUtil.isNullOrEmpty((String)vnicSpec.ip.ipAddress)) continue;
            ipAll.add(vnicSpec.ip.ipAddress);
        }
        return ipAll;
    }

    private static List<String> getVnicIpV6Addresses(VirtualNic[] vnic) {
        if (ArrayUtil.isNullOrEmpty((Object[])vnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < vnic.length; ++i) {
            List<String> ipv6s;
            VirtualNic.Specification vnicSpec = vnic[i].spec;
            if (vnicSpec == null || vnicSpec.ip == null || (ipv6s = HostExtendedDataModel.getIPv6(vnicSpec.ip.ipV6Config)).size() <= 0) continue;
            ipAll.addAll(ipv6s);
        }
        return ipAll;
    }

    private static List<String> getPnicIpV4Addresses(PhysicalNic[] pnic) {
        if (ArrayUtil.isNullOrEmpty((Object[])pnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < pnic.length; ++i) {
            PhysicalNic.Specification pnicSpec = pnic[i].spec;
            if (pnicSpec == null || pnicSpec.ip == null || StringUtil.isNullOrEmpty((String)pnicSpec.ip.ipAddress)) continue;
            ipAll.add(pnicSpec.ip.ipAddress);
        }
        return ipAll;
    }

    private static List<String> getPnicIpV6Addresses(PhysicalNic[] pnic) {
        if (ArrayUtil.isNullOrEmpty((Object[])pnic)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> ipAll = new ArrayList<String>();
        for (int i = 0; i < pnic.length; ++i) {
            List<String> ipv6s;
            PhysicalNic.Specification pnicSpec = pnic[i].spec;
            if (pnicSpec == null || pnicSpec.ip == null || (ipv6s = HostExtendedDataModel.getIPv6(pnicSpec.ip.ipV6Config)).size() <= 0) continue;
            ipAll.addAll(ipv6s);
        }
        return ipAll;
    }

    private static List<String> getIPv6(IpConfig.IpV6AddressConfiguration ipV6Config) {
        if (ipV6Config == null || ArrayUtil.isNullOrEmpty((Object[])ipV6Config.ipV6Address)) {
            return new ArrayList<String>(0);
        }
        IpConfig.IpV6Address[] ipV6Addr = ipV6Config.ipV6Address;
        ArrayList<String> ipv6s = new ArrayList<String>();
        for (int i = 0; i < ipV6Addr.length; ++i) {
            if (StringUtil.isNullOrEmpty((String)ipV6Addr[i].ipAddress)) continue;
            ipv6s.add(ipV6Addr[i].ipAddress);
        }
        return ipv6s;
    }
}

