/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.cluster.ConfigSpec;
import com.vmware.vim.binding.vim.cluster.EVCManager;
import com.vmware.vim.binding.vim.fault.GatewayToHostTrustVerifyFault;
import com.vmware.vim.binding.vim.fault.HostConnectFault;
import com.vmware.vim.binding.vim.fault.InvalidLogin;
import com.vmware.vim.binding.vim.fault.SSLVerifyFault;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.ConnectInfo;
import com.vmware.vim.binding.vim.host.ConnectSpec;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.GatewaySpec;
import com.vmware.vim.binding.vim.host.GraphicsConfig;
import com.vmware.vim.binding.vim.host.GraphicsManager;
import com.vmware.vim.binding.vim.host.HostAccessManager;
import com.vmware.vim.binding.vim.host.ImageConfigManager;
import com.vmware.vim.binding.vim.host.IpmiInfo;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceSystem;
import com.vmware.vim.binding.vim.host.SystemResourceInfo;
import com.vmware.vim.binding.vim.host.SystemSwapConfiguration;
import com.vmware.vim.binding.vim.option.OptionDef;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.advancedsettings.AdvancedSettingsUtil;
import com.vmware.vsphere.client.common.compositecommand.BaseCommandSpec;
import com.vmware.vsphere.client.common.compositecommand.CommandExecutionEngine;
import com.vmware.vsphere.client.common.compositecommand.CommandFactory;
import com.vmware.vsphere.client.common.util.RpUtil;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.host.HostStandbyInfo;
import com.vmware.vsphere.client.host.HostStandbyValidationResult;
import com.vmware.vsphere.client.host.add.HostAddSpec;
import com.vmware.vsphere.client.host.add.HostConnectionSpec;
import com.vmware.vsphere.client.host.add.HostConnectionValidationResult;
import com.vmware.vsphere.client.host.add.MhmValidationSpec;
import com.vmware.vsphere.client.host.certificates.HostCertificateOpManager;
import com.vmware.vsphere.client.host.certificates.HostCertificateOpSpec;
import com.vmware.vsphere.client.host.compositecommand.factory.HostCommandFactory;
import com.vmware.vsphere.client.host.compositecommand.specs.ReconfigureHostDasCommandSpec;
import com.vmware.vsphere.client.host.compositecommand.specs.SetClusterAdvancedOptionsCommandSpec;
import com.vmware.vsphere.client.host.config.HostAdvancedSettingsSpec;
import com.vmware.vsphere.client.host.config.HostEncryptionModeSpec;
import com.vmware.vsphere.client.host.config.HostLockdownModeUpdateSpec;
import com.vmware.vsphere.client.host.config.HostSwapFileReconfigureSpec;
import com.vmware.vsphere.client.host.config.ImageProfileAcceptanceLevelSpec;
import com.vmware.vsphere.client.host.config.ReconfigureDasSpec;
import com.vmware.vsphere.client.host.config.RefreshServicesSpec;
import com.vmware.vsphere.client.host.config.RulesetEnableSpec;
import com.vmware.vsphere.client.host.config.RulesetSpec;
import com.vmware.vsphere.client.host.config.ServiceActionSpec;
import com.vmware.vsphere.client.host.config.ServicePolicySpec;
import com.vmware.vsphere.client.host.config.SuppressHostNoRedundantManagementNetworkWarningSpec;
import com.vmware.vsphere.client.host.connection.HostConnectionOpManager;
import com.vmware.vsphere.client.host.connection.api.HostConnectionStateSpec;
import com.vmware.vsphere.client.host.impl.EnterStandbyQueryObject;
import com.vmware.vsphere.client.host.maintenance.HostMaintenanceOpManager;
import com.vmware.vsphere.client.host.maintenance.HostMaintenanceSpec;
import com.vmware.vsphere.client.host.powerops.HostPowerOpManager;
import com.vmware.vsphere.client.host.powerops.HostPowerSpec;
import com.vmware.vsphere.client.host.standby.HostStandbyOpManager;
import com.vmware.vsphere.client.host.standby.HostStandbySpec;
import com.vmware.vsphere.client.host.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostMutationProvider
implements MutationProvider {
    private static final String DC_PROPERTY_NAME = "dc";
    private static final String HOST_FOLDER_PROPERTY_NAME = "hostFolder";
    private static final String RESOURCE_POOL_PROPERTY_NAME = "resourcePool";
    private static final String CLUSTER_HA_ENABLED_PROP_NAME = "configurationEx[@type='ClusterConfigInfoEx'].dasConfig.enabled";
    private static final String CLUSTER_IGNORE_REDUNDANT_NET_WARNING_OPTION_NAME = "das.ignoreRedundantNetWarning";
    private static final ValidationResult[] EMPTY_VALIDATION_RESULTS = new ValidationResult[0];
    private static final String HOST_VERSION_SUPPORTING_VMCA = "6.0";
    private static final Log _logger = LogFactory.getLog(HostMutationProvider.class);
    private final DataService _dataService;
    private final TaskMonitor _taskMonitor;
    private final MutationService _mutationService;
    private final QueryExecutor _queryExecutor;

    public HostMutationProvider(DataService dataService, TaskMonitor taskMonitor, MutationService mutationService, QueryExecutor queryExecutor) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._mutationService = mutationService;
        this._queryExecutor = queryExecutor;
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostMaintenanceSpec spec) {
        return HostMaintenanceOpManager.applyMaintenanceOp(hostRef, spec);
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostStandbySpec spec) {
        return HostStandbyOpManager.applyStandbyOp(hostRef, spec);
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostPowerSpec spec) {
        return HostPowerOpManager.applyPowerOp(hostRef, spec);
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostSwapFileReconfigureSpec hspec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            ComputeResource cr = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hspec.computeResource);
            if (hspec.swapFileLocationType.equals(ConfigInfo.SwapPlacementType.hostLocal.name())) {
                DatastoreSystem ds = Util.getHostDatastoreSystem(hostRef);
                ds.updateLocalSwapDatastore(hspec.datastore);
            }
            if (hspec.reconfigure.booleanValue()) {
                this.applyComputeResourceReconfigure(hspec.swapFileLocationType, cr, opResult);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error when applying swap file spec to host", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, SystemResourceInfo info) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            hs.updateSystemResources(info);
            opResult.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception e) {
            _logger.error((Object)"Error Updating System resource info on host.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, SuppressHostNoRedundantManagementNetworkWarningSpec spec) {
        ManagedObjectReference clusterRef = null;
        ManagedObjectReference[] hostsRefs = null;
        try {
            clusterRef = (ManagedObjectReference)this._queryExecutor.getProperty((Object)hostRef, "cluster");
        }
        catch (Exception e) {
            _logger.error((Object)"Error fetching host's cluster.", (Throwable)e);
            OperationResult opResult = new OperationResult();
            opResult.entity = hostRef;
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
            return opResult;
        }
        try {
            hostsRefs = (ManagedObjectReference[])this._queryExecutor.getProperty((Object)clusterRef, "host");
        }
        catch (Exception e) {
            _logger.error((Object)"Error fetching cluster child hosts.", (Throwable)e);
            OperationResult opResult = new OperationResult();
            opResult.entity = hostRef;
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
            return opResult;
        }
        BaseCommandSpec[] hostsCommandsSpecs = new BaseCommandSpec[hostsRefs.length];
        for (int i = 0; i < hostsRefs.length; ++i) {
            ReconfigureHostDasCommandSpec hostCommandSpec = new ReconfigureHostDasCommandSpec();
            hostCommandSpec.mor = hostsRefs[i];
            hostsCommandsSpecs[i] = hostCommandSpec;
        }
        SetClusterAdvancedOptionsCommandSpec clusterCommandSpec = new SetClusterAdvancedOptionsCommandSpec();
        clusterCommandSpec.mor = clusterRef;
        clusterCommandSpec.dependentSpecs = hostsCommandsSpecs;
        clusterCommandSpec.options = new HashMap<String, Object>();
        clusterCommandSpec.options.put(CLUSTER_IGNORE_REDUNDANT_NET_WARNING_OPTION_NAME, Boolean.TRUE.toString());
        HostCommandFactory commandFactory = new HostCommandFactory();
        CommandExecutionEngine engine = new CommandExecutionEngine((BaseCommandSpec)clusterCommandSpec, this._dataService, (CommandFactory)commandFactory);
        engine.execute();
        return engine.getResult();
    }

    public OperationResult apply(ManagedObjectReference hostRef, ReconfigureDasSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            opResult.task = hs.reconfigureDAS();
        }
        catch (Exception e) {
            _logger.error((Object)"Error reconfiguring Das on host.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostLockdownModeUpdateSpec hspec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            HostAccessManager hostAccessMgr = Util.getHostAccessManager(hostRef);
            if (hostAccessMgr == null) {
                this.setLegacyHostLockdownMode(hostRef, hspec);
                return opResult;
            }
            hostAccessMgr.updateLockdownExceptions(hspec.exceptionUsers);
            hostAccessMgr.changeLockdownMode(this.getLockdownModeFor(hspec.lockdownMode));
        }
        catch (Exception e) {
            _logger.error((Object)"Error performing host lock down", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private void setLegacyHostLockdownMode(ManagedObjectReference hostRef, HostLockdownModeUpdateSpec hspec) throws Exception {
        HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        if (HostAccessManager.LockdownMode.lockdownNormal.name().equalsIgnoreCase(hspec.lockdownMode)) {
            hs.enterLockdownMode();
        } else if (HostAccessManager.LockdownMode.lockdownDisabled.name().equalsIgnoreCase(hspec.lockdownMode)) {
            hs.exitLockdownMode();
        } else {
            _logger.warn((Object)("Lockdown mode " + hspec.lockdownMode + " is not applicable for host " + hs.getName()));
        }
    }

    private HostAccessManager.LockdownMode getLockdownModeFor(String mode) {
        if (HostAccessManager.LockdownMode.lockdownNormal.toString().equalsIgnoreCase(mode)) {
            return HostAccessManager.LockdownMode.lockdownNormal;
        }
        if (HostAccessManager.LockdownMode.lockdownStrict.toString().equalsIgnoreCase(mode)) {
            return HostAccessManager.LockdownMode.lockdownStrict;
        }
        return HostAccessManager.LockdownMode.lockdownDisabled;
    }

    public OperationResult apply(ManagedObjectReference hostRef, ServiceActionSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        ConfigManager cm = null;
        ServiceSystem ss = null;
        try {
            cm = Util.getHostConfigManager(hostRef);
            ss = (ServiceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cm.serviceSystem);
            if (spec.action.equals((Object)ServiceActionSpec.Action.start)) {
                ss.start(spec.serviceKey);
            } else if (spec.action.equals((Object)ServiceActionSpec.Action.stop)) {
                ss.stop(spec.serviceKey);
            } else if (spec.action.equals((Object)ServiceActionSpec.Action.restart)) {
                ss.restart(spec.serviceKey);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error when performing Service action", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        if (ss != null) {
            Service[] services;
            for (Service service : services = ss.getServiceInfo().service) {
                if (!service.key.equals(spec.serviceKey)) continue;
                opResult.result = service.running;
            }
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, RefreshServicesSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            ManagedObjectReference serviceSystemMor = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"configManager.serviceSystem");
            ServiceSystem serviceSystem = (ServiceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceSystemMor);
            serviceSystem.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"Error when performing refresh services action", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, RulesetEnableSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            ConfigManager cm = Util.getHostConfigManager(hostRef);
            FirewallSystem fs = (FirewallSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cm.firewallSystem);
            if (spec.enabled.booleanValue()) {
                fs.enableRuleset(spec.rulesetKey);
            } else {
                fs.disableRuleset(spec.rulesetKey);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error when enable ruleset", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, ServicePolicySpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            ConfigManager cm = Util.getHostConfigManager(hostRef);
            ServiceSystem ss = (ServiceSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cm.serviceSystem);
            ss.updatePolicy(spec.serviceKey, spec.policy.name());
        }
        catch (Exception e) {
            _logger.error((Object)"Error when updating service policy", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, RulesetSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            ConfigManager cm = Util.getHostConfigManager(hostRef);
            FirewallSystem fs = (FirewallSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cm.firewallSystem);
            fs.updateRuleset(spec.rulesetKey, spec.rulesetSpec);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when updating ruleset spec", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, ImageProfileAcceptanceLevelSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            ManagedObjectReference imgConfigMgrRef = hs.getConfigManager().getImageConfigManager();
            ImageConfigManager imgMgr = (ImageConfigManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)imgConfigMgrRef);
            imgMgr.updateAcceptanceLevel(spec.acceptanceLevel.name());
        }
        catch (Exception e) {
            _logger.debug((Object)"Error when updating Host image profile acceptance level", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostEncryptionModeSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            if (HostSystem.CryptoState.safe.name().equals(spec.encryptionMode)) {
                HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
                hs.configureCryptoKey(null);
            }
        }
        catch (Exception e) {
            _logger.debug((Object)"Error when updating host encryption mode", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, IpmiInfo ipmiInfo) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            host.updateIpmi(ipmiInfo);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when updating a host's ipmi info", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostConnectionStateSpec spec) {
        return HostConnectionOpManager.applyConnectionOp(hostRef, spec);
    }

    public OperationResult apply(ManagedObjectReference hostRef, HostAdvancedSettingsSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            if (spec == null || spec.hostSettingsChangeset == null) {
                throw new IllegalArgumentException("No advanced settings specified for edit.");
            }
            OptionManager optionManager = Util.getHostOptionManager(hostRef);
            OptionValue[] optionValues = spec.hostSettingsChangeset;
            OptionDef[] optionDefs = optionManager.getSupportedOption();
            optionValues = AdvancedSettingsUtil.transformAdvancedSettingsValueTypes((OptionValue[])optionValues, (OptionDef[])optionDefs);
            optionManager.updateValues(optionValues);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when editing a host advanced settings", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, SystemSwapConfiguration spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        opResult.effect = OperationEffect.newDelayedEffect();
        try {
            HostSystem hs = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            hs.updateSystemSwapConfiguration(spec);
        }
        catch (Exception e) {
            _logger.error((Object)"Error updating system swap policy.", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, GraphicsConfig spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        ConfigManager cm = null;
        GraphicsManager gm = null;
        try {
            cm = Util.getHostConfigManager(hostRef);
            gm = (GraphicsManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cm.graphicsManager);
            gm.updateGraphicsConfig(spec);
            opResult.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception e) {
            _logger.error((Object)"Error invoking GraphicsManager.updateGraphicsConfig(...)", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult add(HostAddSpec spec) {
        return this.processAdd(spec, null);
    }

    private OperationResult processAdd(HostAddSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        OperationResult opResult = new OperationResult();
        try {
            if (spec == null || spec.container == null) {
                throw new IllegalArgumentException("No target container hostAddSpecified for the host to add.");
            }
            opResult.entity = spec.container;
            ManagedObjectReference task = null;
            if (spec.container.getType().equals(Datacenter.class.getSimpleName())) {
                task = this.addHostToDatacenter(spec, scheduleSpec);
            } else if (spec.container.getType().equals(Folder.class.getSimpleName())) {
                task = this.addHostToFolder(spec, scheduleSpec);
            } else if (spec.container.getType().equals(ClusterComputeResource.class.getSimpleName())) {
                task = this.addHostToCluster(spec, scheduleSpec);
            } else {
                throw new IllegalArgumentException("Unexpected container type provided.");
            }
            if (scheduleSpec == null) {
                opResult.task = task;
            } else {
                opResult.entity = task;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error when adding a host", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public ValidationResult validate(MhmValidationSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.result = SessionUtil.getData((String)"com.vmware.mhm") == Boolean.TRUE;
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference container, HostConnectionSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = container;
        HostConnectionValidationResult hostConnectionValidationResult = new HostConnectionValidationResult();
        validationResult.result = hostConnectionValidationResult;
        Datacenter dc = null;
        try {
            dc = this.retrieveDc(container);
        }
        catch (Exception e) {
            _logger.error((Object)"Error retrieving DC while validating host connection", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
            return validationResult;
        }
        try {
            if (container == null) {
                throw new IllegalArgumentException("No target container specified for the host to validate.");
            }
            if (spec == null) {
                throw new IllegalArgumentException("No host connection details specified.");
            }
            hostConnectionValidationResult.connectInfo = !StringUtil.isNullOrEmpty((String)spec.hypervisorType) ? this.queryConnectionInfoViaSpec(dc, spec.hostName, spec.hostPort, spec.userName, spec.password, spec.sslThumbprint, spec.hypervisorType, spec.trustVerificationToken) : dc.queryConnectionInfo(spec.hostName, spec.hostPort, spec.userName, StringUtil.isNullOrEmpty((String)spec.password) ? "" : spec.password, spec.sslThumbprint);
            String evcValidationError = this.checkAddHostToCluster(container, spec);
            if (!StringUtil.isNullOrEmpty((String)evcValidationError)) {
                validationResult.error = MixedUtil.getRuntimeFault((String)evcValidationError);
            }
        }
        catch (SSLVerifyFault e) {
            this.logConnectionFault(spec, (MethodFault)e);
            hostConnectionValidationResult.isEsx60OrHigher = this.isEsx60OrHigher(spec, dc, e.getThumbprint());
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        catch (GatewayToHostTrustVerifyFault e) {
            this.logConnectionFault(spec, (MethodFault)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when validating host connection", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    public ValidationResult[] validateOnMultiEntity(ManagedObjectReference[] hostRefs, HostConnectionStateSpec spec) {
        return HostConnectionOpManager.validateOnMultiEntity(this._dataService, hostRefs, spec);
    }

    private static void countHostsByCluster(Collection<EnterStandbyQueryObject> dataQueryResults) {
        String objUid;
        Object clusterRef;
        assert (dataQueryResults != null);
        HashMap<String, Integer> hostCountByClusterId = new HashMap<String, Integer>(dataQueryResults.size());
        for (EnterStandbyQueryObject queryResult : dataQueryResults) {
            clusterRef = queryResult.clusterEntity;
            if (clusterRef == null) continue;
            objUid = QueryUtil.getReferenceUid((Object)clusterRef);
            if (hostCountByClusterId.containsKey(objUid)) {
                int hostCount = (Integer)hostCountByClusterId.get(objUid);
                hostCountByClusterId.put(objUid, hostCount + 1);
                continue;
            }
            hostCountByClusterId.put(objUid, 1);
        }
        for (EnterStandbyQueryObject queryResult : dataQueryResults) {
            clusterRef = queryResult.clusterEntity;
            if (clusterRef == null) continue;
            objUid = QueryUtil.getReferenceUid((Object)clusterRef);
            queryResult.clusterHostsEnteringStandby = (Integer)hostCountByClusterId.get(objUid);
        }
    }

    private static boolean isHighAvailabilityCompromise(EnterStandbyQueryObject queryResult) {
        assert (queryResult != null);
        Boolean clusterHaEnabled = queryResult.clusterHaEnabled;
        if (clusterHaEnabled == null || !clusterHaEnabled.booleanValue()) {
            return false;
        }
        Integer configuredFailoverLevel = queryResult.clusterConfiguredFailoverLevel;
        if (configuredFailoverLevel == null) {
            return true;
        }
        Integer currentFailoverLevel = queryResult.clusterCurrentFailoverLevel;
        if (currentFailoverLevel == null) {
            return true;
        }
        Integer hostStandbyCount = queryResult.clusterHostsEnteringStandby;
        if (hostStandbyCount == null) {
            return true;
        }
        int failoverTolerance = configuredFailoverLevel - currentFailoverLevel;
        return hostStandbyCount > failoverTolerance;
    }

    private static boolean isDrsEnabled(EnterStandbyQueryObject queryResult) {
        assert (queryResult != null);
        Boolean clusterDrsEnabled = queryResult.clusterDrsEnabled;
        if (clusterDrsEnabled == null || !clusterDrsEnabled.booleanValue()) {
            return false;
        }
        Integer numEffectiveHosts = queryResult.clusterNumberOfEffectiveHosts;
        if (numEffectiveHosts == null) {
            return false;
        }
        Integer hostStandbyCount = queryResult.clusterHostsEnteringStandby;
        if (hostStandbyCount == null) {
            return false;
        }
        return numEffectiveHosts > hostStandbyCount;
    }

    private static HostStandbyValidationResult generateHostStandbyResponseData(EnterStandbyQueryObject queryResult, HostStandbyInfo hostStandbyInfo) {
        assert (queryResult != null);
        HostStandbyValidationResult validationResultData = new HostStandbyValidationResult();
        validationResultData.parentClusterName = queryResult.clusterName;
        validationResultData.hostName = queryResult.hostName;
        if (queryResult.hostVmsPoweredOn != null) {
            validationResultData.vmsPoweredOn = queryResult.hostVmsPoweredOn;
        }
        if (queryResult.vms != null) {
            validationResultData.vmsCount = queryResult.vms.length;
        }
        validationResultData.drsEnabled = false;
        validationResultData.highAvailabilityCompromise = false;
        Object clusterRef = queryResult.clusterEntity;
        if (clusterRef != null) {
            validationResultData.highAvailabilityCompromise = HostMutationProvider.isHighAvailabilityCompromise(queryResult);
            validationResultData.drsEnabled = HostMutationProvider.isDrsEnabled(queryResult);
        }
        validationResultData.lastStandbyExitUncertain = hostStandbyInfo == null ? true : hostStandbyInfo.lastExitSucceeded == false;
        return validationResultData;
    }

    private static ValidationResult[] processValidateHostEnterStandby(ManagedObjectReference[] hostRefs, DataService dataService) throws Exception {
        assert (hostRefs != null);
        for (ManagedObjectReference hostRef : hostRefs) {
            assert (hostRef != null);
            assert (ManagedObjectUtil.isOfType((ManagedObjectReference)hostRef, HostSystem.class));
        }
        assert (dataService != null);
        HashMap<String, ManagedObjectReference> hostRefsByUid = new HashMap<String, ManagedObjectReference>(hostRefs.length);
        for (ManagedObjectReference hostRef : hostRefs) {
            String hostRefUid = QueryUtil.getReferenceUid((Object)hostRef);
            hostRefsByUid.put(hostRefUid, hostRef);
        }
        Class<EnterStandbyQueryObject> queryDataModel = EnterStandbyQueryObject.class;
        DataFetchCommand fetchService = DataFetchCommandFactory.getDataFetchCommand((DataService)dataService);
        Collection dataQueryResults = fetchService.execute(queryDataModel, (Object[])hostRefs);
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(hostRefs.length);
        HostMutationProvider.countHostsByCluster(dataQueryResults);
        for (EnterStandbyQueryObject queryResult : dataQueryResults) {
            String hostRefUid = QueryUtil.getReferenceUid((Object)queryResult.provider);
            ManagedObjectReference morHostRef = (ManagedObjectReference)hostRefsByUid.get(hostRefUid);
            HostStandbyInfo hostStandbyInfo = Util.getHostStandbyInfo(morHostRef);
            HostStandbyValidationResult validationResultData = HostMutationProvider.generateHostStandbyResponseData(queryResult, hostStandbyInfo);
            ValidationResult validationResult = new ValidationResult();
            validationResult.entity = queryResult.provider;
            validationResult.result = validationResultData;
            validationResults.add(validationResult);
        }
        ValidationResult[] resultDataContainer = validationResults.toArray(EMPTY_VALIDATION_RESULTS);
        return resultDataContainer;
    }

    public ValidationResult[] validateOnMultiEntity(ManagedObjectReference[] entities, HostStandbySpec spec) {
        if (entities == null) {
            _logger.warn((Object)"Null entities passed to validateOnMultiEntity");
            return new ValidationResult[0];
        }
        if (entities.length == 0) {
            _logger.warn((Object)"Empty entities passed to validateOnMultiEntity");
            return new ValidationResult[0];
        }
        try {
            for (ManagedObjectReference hostRef : entities) {
                if (hostRef == null) {
                    throw new IllegalArgumentException("Null host ref.");
                }
                if (HostSystem.class.getSimpleName().equals(hostRef.getType())) continue;
                throw new IllegalArgumentException("Expecting entity of type host system.");
            }
            if (spec == null) {
                throw new IllegalArgumentException("No host connection details specified.");
            }
            if (!spec.standbyOpType.equals((Object)HostStandbySpec.StandbyOpType.enter)) {
                throw new UnsupportedOperationException("not supported for op type" + (Object)((Object)spec.standbyOpType));
            }
            ValidationResult[] validationResults = HostMutationProvider.processValidateHostEnterStandby(entities, this._dataService);
            return validationResults;
        }
        catch (Exception e) {
            _logger.error((Object)"Error when host enter standby", (Throwable)e);
            ValidationResult[] errorResult = new ValidationResult[]{new ValidationResult()};
            errorResult[0].error = MixedUtil.getMethodFault((Throwable)e);
            return errorResult;
        }
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] entities, HostCertificateOpSpec spec) {
        OperationResult[] result = HostCertificateOpManager.applyCertificateOp(entities, spec);
        return result;
    }

    private ManagedObjectReference addHostToDatacenter(HostAddSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ManagedObjectReference hostFolderMoref = this.retrieveRelatedObject(spec.container, HOST_FOLDER_PROPERTY_NAME);
        return this.addHostToFolder(spec, hostFolderMoref, scheduleSpec);
    }

    private ManagedObjectReference addHostToFolder(HostAddSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        return this.addHostToFolder(spec, spec.container, scheduleSpec);
    }

    private ManagedObjectReference addHostToFolder(HostAddSpec spec, ManagedObjectReference hostFolderRef, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        Folder hostFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostFolderRef);
        ConnectSpec connectSpec = this.createConnectSpec(spec);
        ManagedObjectReference addHostTask = null;
        addHostTask = spec.enableLockDownMode.booleanValue() ? (scheduleSpec == null ? hostFolder.addStandaloneHostWithAdminDisabled(connectSpec, null, true, spec.licenseKey) : this.addStandaloneHostWithAdminDisabledScheduled(connectSpec, null, true, spec.licenseKey, scheduleSpec, hostFolderRef)) : (scheduleSpec == null ? hostFolder.addStandaloneHost(connectSpec, null, true, spec.licenseKey) : this.addStandaloneHostScheduled(connectSpec, null, true, spec.licenseKey, scheduleSpec, hostFolderRef));
        return addHostTask;
    }

    private ManagedObjectReference addHostToCluster(HostAddSpec spec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ManagedObjectReference clusterRef = spec.container;
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        Boolean clusterHaEnabled = (Boolean)QueryUtil.getProperty((DataService)this._dataService, (Object)clusterRef, (String)CLUSTER_HA_ENABLED_PROP_NAME);
        ConnectSpec connectSpec = this.createConnectSpec(spec);
        ManagedObjectReference rp = null;
        if (!StringUtil.isNullOrEmpty((String)spec.newRpName)) {
            rp = this.createChildResourcePool(cluster, spec.newRpName);
        }
        ManagedObjectReference addHostTask = null;
        if (spec.enableLockDownMode.booleanValue()) {
            if (scheduleSpec == null) {
                addHostTask = cluster.addHostWithAdminDisabled(connectSpec, true, rp, spec.licenseKey);
                if (clusterHaEnabled.booleanValue() || rp != null) {
                    TaskInfo taskInfo = null;
                    try {
                        taskInfo = this._taskMonitor.monitorTask(addHostTask);
                    }
                    catch (Exception e) {
                        _logger.error((Object)"Error monitoring cluster.addHostWithAdminDisabledtask", (Throwable)e);
                    }
                    if (rp != null && taskInfo != null && taskInfo.error != null) {
                        this.removeEntity(rp);
                    }
                }
            } else {
                addHostTask = this.addHostWithAdminDisabledScheduled(connectSpec, true, rp, spec.licenseKey, scheduleSpec, spec.container);
            }
        } else if (scheduleSpec == null) {
            addHostTask = cluster.addHost(connectSpec, true, rp, spec.licenseKey);
            if (clusterHaEnabled.booleanValue() || rp != null) {
                TaskInfo taskInfo = null;
                try {
                    taskInfo = this._taskMonitor.monitorTask(addHostTask);
                }
                catch (Exception e) {
                    _logger.error((Object)"Error monitoring cluster.addHost task", (Throwable)e);
                }
                if (rp != null && taskInfo != null && taskInfo.error != null) {
                    this.removeEntity(rp);
                }
            }
        } else {
            addHostTask = this.addHostScheduled(connectSpec, true, rp, spec.licenseKey, scheduleSpec, spec.container);
        }
        return addHostTask;
    }

    private String checkAddHostToCluster(ManagedObjectReference container, HostConnectionSpec spec) throws Exception {
        if (!container.getType().equals(ClusterComputeResource.class.getSimpleName())) {
            return null;
        }
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)container);
        if (((ClusterComputeResource.Summary)cluster.getSummary()).currentEVCModeKey == null) {
            return null;
        }
        ConnectSpec connectSpec = HostMutationProvider.createConnectSpec(spec);
        return this.checkAddHostViaEvcManager(cluster, connectSpec);
    }

    private String checkAddHostViaEvcManager(ClusterComputeResource cluster, ConnectSpec connectSpec) throws Exception {
        EVCManager evcManager = (EVCManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cluster.evcManager());
        ManagedObjectReference checkAddHostTask = evcManager.checkAddHostEvc(connectSpec);
        TaskInfo checkAddHostTaskInfo = this._taskMonitor.monitorTask(checkAddHostTask);
        if (checkAddHostTaskInfo.error != null) {
            return checkAddHostTaskInfo.error.getMessage();
        }
        Object[] result = (EVCManager.CheckResult[])checkAddHostTaskInfo.result;
        if (!ArrayUtil.isNullOrEmpty((Object[])result)) {
            StringBuffer errors = new StringBuffer();
            for (Object checkResult : result) {
                if (!StringUtil.isNullOrEmpty((String)errors.toString())) {
                    errors.append("\n");
                }
                errors.append(((EVCManager.CheckResult)checkResult).error.getMessage());
            }
            return errors.toString();
        }
        return null;
    }

    private ManagedObjectReference createChildResourcePool(ClusterComputeResource cluster, String rpName) throws Exception {
        ManagedObjectReference rpMoref = this.retrieveRelatedObject(cluster._getRef(), RESOURCE_POOL_PROPERTY_NAME);
        ResourcePool rootRp = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)rpMoref);
        ResourceConfigSpec rpSpec = RpUtil.createChildResourcePoolSpec();
        ManagedObjectReference childRpMoref = rootRp.createResourcePool(rpName, rpSpec);
        return childRpMoref;
    }

    private Datacenter retrieveDc(ManagedObjectReference container) throws Exception {
        ManagedObjectReference dcMoref = null;
        dcMoref = container.getType().equals(Datacenter.class.getSimpleName()) ? container : this.retrieveRelatedObject(container, DC_PROPERTY_NAME);
        Datacenter dc = (Datacenter)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dcMoref);
        return dc;
    }

    private ManagedObjectReference retrieveRelatedObject(ManagedObjectReference serverObject, String property) throws Exception {
        ManagedObjectReference relatedObject = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)serverObject, (String)property);
        if (relatedObject == null) {
            throw new Exception(String.format("Failed to retrieve %1s for %2s", property, serverObject.toString()));
        }
        return relatedObject;
    }

    private ConnectSpec createConnectSpec(HostAddSpec hostAddSpec) throws Exception {
        ConnectSpec connectSpec = new ConnectSpec();
        connectSpec.hostName = hostAddSpec.hostName;
        if (hostAddSpec.hostPort != -1) {
            connectSpec.port = hostAddSpec.hostPort;
        }
        connectSpec.userName = hostAddSpec.userName;
        connectSpec.password = StringUtil.isNullOrEmpty((String)hostAddSpec.password) ? "" : hostAddSpec.password;
        connectSpec.sslThumbprint = hostAddSpec.sslThumbprint;
        connectSpec.vmFolder = hostAddSpec.vmFolder;
        connectSpec.force = true;
        if (this.isHostAccessManagerSupported(hostAddSpec)) {
            connectSpec.lockdownMode = hostAddSpec.lockdownMode;
        }
        if (!StringUtil.isNullOrEmpty((String)hostAddSpec.hypervisorType)) {
            connectSpec.setHostGateway(HostMutationProvider.createGatewaySpec(hostAddSpec.hypervisorType, hostAddSpec.trustVerificationToken));
        }
        return connectSpec;
    }

    private static ConnectSpec createConnectSpec(HostConnectionSpec hostConnectionSpec) {
        ConnectSpec connectSpec = new ConnectSpec();
        connectSpec.hostName = hostConnectionSpec.hostName;
        if (hostConnectionSpec.hostPort != -1) {
            connectSpec.port = hostConnectionSpec.hostPort;
        }
        connectSpec.userName = hostConnectionSpec.userName;
        connectSpec.password = StringUtil.isNullOrEmpty((String)hostConnectionSpec.password) ? "" : hostConnectionSpec.password;
        connectSpec.sslThumbprint = hostConnectionSpec.sslThumbprint;
        connectSpec.force = true;
        if (!StringUtil.isNullOrEmpty((String)hostConnectionSpec.hypervisorType)) {
            connectSpec.setHostGateway(HostMutationProvider.createGatewaySpec(hostConnectionSpec.hypervisorType, hostConnectionSpec.trustVerificationToken));
        }
        return connectSpec;
    }

    private static GatewaySpec createGatewaySpec(String hypervisorType, String trustVerificationToken) {
        GatewaySpec gatewaySpec = new GatewaySpec();
        gatewaySpec.setGatewayType(hypervisorType);
        gatewaySpec.setTrustVerificationToken(trustVerificationToken);
        return gatewaySpec;
    }

    private void applyComputeResourceReconfigure(String type2, ComputeResource cr, OperationResult opResult) throws Exception {
        ComputeResource.ConfigSpec spec = new ComputeResource.ConfigSpec();
        spec.vmSwapPlacement = type2;
        opResult.task = cr.reconfigureEx(spec, true);
    }

    public OperationResult addDeferred(HostAddSpec hostAddSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        OperationResult result = new OperationResult();
        try {
            result = this.processAdd(hostAddSpec, scheduleSpec);
        }
        catch (Exception ex) {
            _logger.error((Object)("Exception in addDeferred:" + ex.getMessage()));
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private ManagedObjectReference createAddHostScheduledTask(String methodName, Object[] vcMethodArgs, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec, ManagedObjectReference hostMoref) throws Exception {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        MethodAction action = SchedulingUtil.newMethodAction((String)methodName, (Object[])vcMethodArgs);
        vcTaskSpec.action = action;
        ManagedObjectReference taskRef = null;
        taskRef = scheduleSpec.scheduledTask != null ? SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec) : SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)hostMoref, (ScheduledTaskSpec)vcTaskSpec);
        return taskRef;
    }

    private ManagedObjectReference addHostScheduled(ConnectSpec spec, boolean asConnected, ManagedObjectReference rp, String licenseKey, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec, ManagedObjectReference hostContainer) throws Exception {
        Object[] vcMethodArgs = new Object[]{spec, asConnected, rp, licenseKey};
        return this.createAddHostScheduledTask("AddHost_Task", vcMethodArgs, scheduleSpec, hostContainer);
    }

    private ManagedObjectReference addHostWithAdminDisabledScheduled(ConnectSpec spec, boolean asConnected, ManagedObjectReference rp, String licenseKey, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec, ManagedObjectReference hostContainer) throws Exception {
        Object[] vcMethodArgs = new Object[]{spec, asConnected, rp, licenseKey};
        return this.createAddHostScheduledTask("AddHostWithAdminDisabled_Task", vcMethodArgs, scheduleSpec, hostContainer);
    }

    private void removeEntity(ManagedObjectReference moRef) {
        OperationResult result = this._mutationService.remove((Object)moRef, null);
        if (result.error != null) {
            _logger.error((Object)"Error when removing entity, no task started.");
            return;
        }
        ManagedObjectReference removeEntityTaskRef = (ManagedObjectReference)result.task;
        try {
            TaskInfo removeEntityTaskInfo = this._taskMonitor.monitorTask(removeEntityTaskRef);
            if (removeEntityTaskInfo.error != null) {
                _logger.error((Object)"Error when removing entity", (Throwable)removeEntityTaskInfo.error);
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"Error when removing entity", (Throwable)ex);
        }
    }

    private ManagedObjectReference addStandaloneHostScheduled(ConnectSpec spec, ConfigSpec compResSpec, boolean addConnected, String licenseKey, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec, ManagedObjectReference hostContainer) throws Exception {
        Object[] vcMethodArgs = new Object[]{spec, compResSpec, addConnected, licenseKey};
        return this.createAddHostScheduledTask("AddStandaloneHost_Task", vcMethodArgs, scheduleSpec, hostContainer);
    }

    private ManagedObjectReference addStandaloneHostWithAdminDisabledScheduled(ConnectSpec spec, ConfigSpec compResSpec, boolean addConnected, String licenseKey, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec, ManagedObjectReference hostContainer) throws Exception {
        Object[] vcMethodArgs = new Object[]{spec, compResSpec, addConnected, licenseKey};
        return this.createAddHostScheduledTask("AddStandaloneHostWithAdminDisabled_Task", vcMethodArgs, scheduleSpec, hostContainer);
    }

    private boolean isEsx60OrHigher(HostConnectionSpec spec, Datacenter dc, String thumbprint) {
        boolean result = false;
        try {
            ConnectInfo connectInfo = dc.queryConnectionInfo(spec.hostName, spec.hostPort, spec.userName, StringUtil.isNullOrEmpty((String)spec.password) ? "" : spec.password, thumbprint);
            result = Util.isEsxVersionEqualOrHigher(connectInfo.host.config.product.version, HOST_VERSION_SUPPORTING_VMCA);
        }
        catch (Exception e) {
            _logger.error((Object)"Error when getting host connection information", (Throwable)e);
        }
        return result;
    }

    private boolean isHostAccessManagerSupported(HostAddSpec spec) throws Exception {
        Datacenter dc = this.retrieveDc(spec.container);
        ConnectInfo connectInfo = !StringUtil.isNullOrEmpty((String)spec.hypervisorType) ? this.queryConnectionInfoViaSpec(dc, spec.hostName, spec.hostPort, spec.userName, spec.password, spec.sslThumbprint, spec.hypervisorType, spec.trustVerificationToken) : dc.queryConnectionInfo(spec.hostName, spec.hostPort, spec.userName, StringUtil.isNullOrEmpty((String)spec.password) ? "" : spec.password, spec.sslThumbprint);
        return connectInfo != null && connectInfo.capability != null && connectInfo.capability.hostAccessManagerSupported != false;
    }

    private ConnectInfo queryConnectionInfoViaSpec(Datacenter dc, String hostName, Integer port, String userName, String password, String sslThumbprint, String hypervisorType, String trustVerificationToken) throws InvalidLogin, HostConnectFault {
        ConnectSpec connectSpec = new ConnectSpec();
        connectSpec.hostName = hostName;
        connectSpec.port = port;
        connectSpec.userName = userName;
        connectSpec.password = StringUtil.isNullOrEmpty((String)password) ? "" : password;
        connectSpec.sslThumbprint = sslThumbprint;
        if (!StringUtil.isNullOrEmpty((String)hypervisorType)) {
            connectSpec.setHostGateway(HostMutationProvider.createGatewaySpec(hypervisorType, trustVerificationToken));
        }
        return dc.queryConnectionInfoViaSpec(connectSpec);
    }

    private void logConnectionFault(HostConnectionSpec spec, MethodFault fault) {
        String hostInfo = spec.hostName + ":" + spec.hostPort + ", thumbprint: " + spec.sslThumbprint + ", username: " + spec.userName;
        _logger.info((Object)("Host connection fault thrown for: " + hostInfo + "\nThis is OK on the first connection attempt.\n"), (Throwable)fault);
    }
}

