/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.host.BIOSInfo;
import com.vmware.vim.binding.vim.host.BootDeviceInfo;
import com.vmware.vim.binding.vim.host.BootDeviceSystem;
import com.vmware.vim.binding.vim.host.Summary;
import com.vmware.vim.binding.vim.host.SystemIdentificationInfo;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ProcessorSystemConfigFormatter {
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("GMT");
    private Summary.HardwareSummary _hardware = null;
    private BIOSInfo _bios = null;
    private BootDeviceInfo _bootInfo = null;

    private ProcessorSystemConfigFormatter(Summary.HardwareSummary hardware, BIOSInfo bios, BootDeviceInfo bootInfo) {
        this._hardware = hardware;
        this._bios = bios;
        this._bootInfo = bootInfo;
    }

    public static ProcessorSystemConfigFormatter newInstance(Summary.HardwareSummary hardware, BIOSInfo bios, BootDeviceInfo bootInfo) {
        return new ProcessorSystemConfigFormatter(hardware, bios, bootInfo);
    }

    public String manufacturer() {
        if (this._hardware == null) {
            return "";
        }
        return this._hardware.vendor;
    }

    public String model() {
        if (this._hardware == null) {
            return "";
        }
        return this._hardware.model;
    }

    public String biosVersion() {
        if (this._bios == null || this._bios.biosVersion == null) {
            return "";
        }
        return this._bios.biosVersion;
    }

    public String releaseDate() {
        if (this._bios == null || this._bios.releaseDate == null) {
            return "";
        }
        Calendar cal = this._bios.releaseDate;
        cal.setTimeZone(UTC_TIMEZONE);
        return LocalizationUtil.formatLocalizedDate((Date)cal.getTime());
    }

    public String assetTag() {
        if (this._hardware == null || this._hardware.otherIdentifyingInfo == null) {
            return "";
        }
        String result = "";
        for (SystemIdentificationInfo i : this._hardware.otherIdentifyingInfo) {
            if (!i.identifierType.key.equalsIgnoreCase(SystemIdentificationInfo.Identifier.AssetTag.name())) continue;
            result = result + i.identifierValue;
        }
        return result;
    }

    public String serviceTag() {
        if (this._hardware == null || this._hardware.otherIdentifyingInfo == null) {
            return "";
        }
        String result = "";
        for (SystemIdentificationInfo i : this._hardware.otherIdentifyingInfo) {
            if (!i.identifierType.key.equalsIgnoreCase(SystemIdentificationInfo.Identifier.ServiceTag.name())) continue;
            result = result + i.identifierValue;
        }
        return result;
    }

    public String bootDevice() {
        if (this._bootInfo == null || this._bootInfo.bootDevices == null) {
            return "";
        }
        String result = "";
        for (BootDeviceSystem.BootDevice device : this._bootInfo.bootDevices) {
            if (device == null || !device.key.equalsIgnoreCase(this._bootInfo.currentBootDeviceKey)) continue;
            result = device.description;
            break;
        }
        return result;
    }
}

