/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.subscription;

import org.reactivestreams.Subscriber;
import reactor.core.queue.CompletableLinkedQueue;
import reactor.core.queue.CompletableQueue;
import reactor.rx.Stream;
import reactor.rx.action.Action;
import reactor.rx.subscription.PushSubscription;

public class ReactiveSubscription<O>
extends PushSubscription<O> {
    protected final CompletableQueue<O> buffer;
    protected boolean draining = false;
    protected volatile long currentNextSignals = 0L;
    protected volatile long maxCapacity = Long.MAX_VALUE;

    public ReactiveSubscription(Stream<O> publisher, Subscriber<? super O> subscriber) {
        this((Stream<? super O>)publisher, subscriber, (CompletableQueue<? super O>)new CompletableLinkedQueue());
    }

    public ReactiveSubscription(Stream<O> publisher, Subscriber<? super O> subscriber, CompletableQueue<O> buffer) {
        super(publisher, subscriber);
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(long elements) {
        try {
            Action.checkRequest(elements);
            FastList list = null;
            long toRequest = elements;
            do {
                boolean last;
                ReactiveSubscription reactiveSubscription = this;
                synchronized (reactiveSubscription) {
                    if (this.terminated == 1) {
                        return;
                    }
                    if (toRequest == Long.MAX_VALUE) {
                        if (this.pendingRequestSignals == Long.MAX_VALUE) {
                            return;
                        }
                        this.pendingRequestSignals = Long.MAX_VALUE;
                    } else {
                        long previous = this.pendingRequestSignals;
                        if (previous != Long.MAX_VALUE && PENDING_UPDATER.addAndGet(this, toRequest) < 0L) {
                            PENDING_UPDATER.set(this, Long.MAX_VALUE);
                            return;
                        }
                    }
                    boolean bl = this.draining = !this.buffer.isEmpty();
                    if (this.draining) {
                        Object element;
                        list = new FastList();
                        while ((long)list.size < toRequest && (element = this.buffer.poll()) != null) {
                            list.add(element);
                        }
                        if (list.size != 0 && this.pendingRequestSignals != Long.MAX_VALUE && PENDING_UPDATER.addAndGet(this, -list.size) < 0L) {
                            this.pendingRequestSignals = 0L;
                        }
                    } else {
                        this.currentNextSignals = 0L;
                    }
                }
                if (list == null) {
                    if (this.terminated == 0) {
                        this.onRequest(elements);
                    } else {
                        this.updatePendingRequests(elements);
                    }
                    return;
                }
                this.drainNext(list);
                reactiveSubscription = this;
                synchronized (reactiveSubscription) {
                    this.draining = !this.buffer.isEmpty();
                    last = !this.draining && this.buffer.isComplete();
                }
                if (last) {
                    this.onComplete();
                    continue;
                }
                if (elements != Long.MAX_VALUE) {
                    elements -= (long)list.size;
                }
                if (this.draining) {
                    toRequest = elements;
                    continue;
                }
                if (elements <= 0L) continue;
                if (this.terminated == 0) {
                    this.onRequest(elements);
                } else {
                    this.updatePendingRequests(elements);
                }
                toRequest = 0L;
            } while (this.draining && toRequest > 0L);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    private void drainNext(FastList list) {
        if (list.size > 0) {
            for (Object el : list.array) {
                if (el == null) break;
                ++this.currentNextSignals;
                this.subscriber.onNext(el);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(O ev) {
        ReactiveSubscription reactiveSubscription = this;
        synchronized (reactiveSubscription) {
            if (this.pendingRequestSignals != Long.MAX_VALUE && PENDING_UPDATER.decrementAndGet(this) < 0L) {
                PENDING_UPDATER.incrementAndGet(this);
                if (ev != null) {
                    this.buffer.add(ev);
                }
                return;
            }
            ++this.currentNextSignals;
        }
        this.subscriber.onNext(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        boolean complete = false;
        if (this.terminated == 1) {
            return;
        }
        ReactiveSubscription reactiveSubscription = this;
        synchronized (reactiveSubscription) {
            this.buffer.complete();
            if (this.buffer.isEmpty() && TERMINAL_UPDATER.compareAndSet(this, 0, 1) && this.subscriber != null) {
                complete = true;
            }
        }
        if (complete) {
            this.subscriber.onComplete();
        }
    }

    public long currentNextSignals() {
        return this.currentNextSignals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePendingRequests(long n) {
        ReactiveSubscription reactiveSubscription = this;
        synchronized (reactiveSubscription) {
            long newPending;
            long oldPending = this.pendingRequestSignals;
            long l = newPending = n == 0L ? 0L : oldPending + n;
            if (newPending < 0L) {
                newPending = n > 0L ? Long.MAX_VALUE : 0L;
            }
            this.pendingRequestSignals = newPending;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldRequestPendingSignals() {
        ReactiveSubscription reactiveSubscription = this;
        synchronized (reactiveSubscription) {
            return this.pendingRequestSignals > 0L && this.pendingRequestSignals != Long.MAX_VALUE && (!this.buffer.isEmpty() || this.currentNextSignals == this.maxCapacity);
        }
    }

    @Override
    public final void maxCapacity(long maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public final long getBufferSize() {
        return this.buffer != null ? (long)this.buffer.size() : -1L;
    }

    public final long capacity() {
        return this.pendingRequestSignals;
    }

    public final CompletableQueue<O> getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isComplete() {
        ReactiveSubscription reactiveSubscription = this;
        synchronized (reactiveSubscription) {
            return this.buffer.isEmpty() && this.buffer.isComplete();
        }
    }

    @Override
    public String toString() {
        return "{current=" + this.currentNextSignals + ", pending=" + (this.pendingRequestSignals() == Long.MAX_VALUE ? "infinite" : Long.valueOf(this.pendingRequestSignals())) + (this.buffer != null ? (this.terminated == 1 ? ", complete" : "") + ", waiting=" + this.buffer.size() : "") + '}';
    }

    static final class FastList {
        Object[] array;
        int size;

        FastList() {
        }

        public void add(Object o) {
            int s = this.size;
            Object[] a = this.array;
            if (a == null) {
                this.array = a = new Object[16];
            } else if (s == a.length) {
                Object[] array2 = new Object[s + (s >> 2)];
                System.arraycopy(a, 0, array2, 0, s);
                this.array = a = array2;
            }
            a[s] = o;
            this.size = s + 1;
        }
    }
}

