/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.vspherewssdk.mvc;

import com.google.gson.Gson;
import com.vmware.samples.vspherewssdk.VmActionService;
import com.vmware.samples.vspherewssdk.model.VmInfo;
import com.vmware.samples.vspherewssdk.mvc.ActionResult;
import com.vmware.samples.vspherewssdk.mvc.ObjectIdUtil;
import com.vmware.samples.vspherewssdk.mvc.QueryUtil;
import com.vmware.vise.data.query.ObjectReferenceService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/actions.html"})
public class ActionsController {
    private static final Log _logger = LogFactory.getLog(ActionsController.class);
    private final String RESOURCE_BUNDLE = "com_vmware_samples_vspherewssdk";
    private final VmActionService _vmActionService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public ActionsController(VmActionService vmActionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._vmActionService = vmActionService;
        this._objectReferenceService = objectReferenceService;
        QueryUtil.setObjectReferenceService(objectReferenceService);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> invoke(@RequestParam(value="actionUid", required=true) String string, @RequestParam(value="targets", required=true) String string2, @RequestParam(value="json", required=false) String string3) throws Exception {
        Object object;
        String string4;
        ActionResult actionResult = new ActionResult(string, "com_vmware_samples_vspherewssdk");
        Object object2 = null;
        String[] stringArray = string2.split(",");
        if (stringArray.length > 1) {
            _logger.warn((Object)("Action " + string + " called with " + stringArray.length + " target objects, will use only the first one"));
        }
        if ((object2 = this._objectReferenceService.getReference(string4 = ObjectIdUtil.decodeParameter(stringArray[0]))) == null) {
            String string5 = "VM not found with id: " + string4;
            _logger.error((Object)string5);
            actionResult.setErrorLocalizedMessage(string5);
            return actionResult.getJsonMap();
        }
        VmInfo vmInfo = null;
        if (string3 != null) {
            object = new Gson();
            vmInfo = (VmInfo)object.fromJson(string3, VmInfo.class);
        }
        if (string.equals("com.vmware.samples.vspherewssdk.myVmAction1")) {
            boolean bl = this._vmActionService.backendAction1(object2, vmInfo);
            actionResult.setObjectChangedResult(bl, "action1.errorMsg");
        } else if (string.equals("com.vmware.samples.vspherewssdk.myVmAction2")) {
            boolean bl = this._vmActionService.backendAction2(object2);
            actionResult.setObjectChangedResult(bl, "action2.errorMsg");
        } else {
            object = "Action not implemented yet! " + string;
            _logger.warn(object);
            actionResult.setErrorLocalizedMessage((String)object);
        }
        return actionResult.getJsonMap();
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception exception, HttpServletResponse httpServletResponse) {
        httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("message", exception.getMessage());
        if (exception.getCause() != null) {
            hashMap.put("cause", exception.getCause().getMessage());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        hashMap.put("stackTrace", stringWriter.toString());
        return hashMap;
    }
}

