/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.wssdkprovider;

import com.vmware.samples.wssdkprovider.VmData;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.security.ClientSessionEndListener;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.data.VimObjectReferenceService;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.BindingProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmDataProviderImpl
implements PropertyProviderAdapter,
ClientSessionEndListener {
    private static final Log _logger = LogFactory.getLog(VmDataProviderImpl.class);
    private static final String VM_TYPE = "VirtualMachine";
    private static final String VMDATA_PROPERTY = "samples:vmData";
    private final UserSessionService _userSessionService;
    private final VimObjectReferenceService _vimObjectReferenceService;
    private static final String SERVICE_INSTANCE = "ServiceInstance";
    private static VimPortType _vimPort = VmDataProviderImpl.initializeVimPort();

    private static VimPortType initializeVimPort() {
        VimService vimService = new VimService();
        return vimService.getVimPort();
    }

    public VmDataProviderImpl(UserSessionService userSessionService, VimObjectReferenceService vimObjectReferenceService, DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        this._userSessionService = userSessionService;
        this._vimObjectReferenceService = vimObjectReferenceService;
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = VM_TYPE;
        typeInfo.properties = new String[]{VMDATA_PROPERTY};
        return new TypeInfo[]{typeInfo};
    }

    public void sessionEnded(String string) {
        _logger.info((Object)("Logging out client session - " + string));
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ResultSet resultSet = new ResultSet();
        try {
            ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
            for (Object object : propertyRequestSpec.objects) {
                ResultItem resultItem = this.getVmProperties(object);
                if (resultItem == null) continue;
                arrayList.add(resultItem);
            }
            resultSet.items = arrayList.toArray(new ResultItem[0]);
        }
        catch (Exception exception) {
            _logger.error((Object)("VmDataProviderImpl.getProperties error: " + exception));
            resultSet.error = exception;
        }
        return resultSet;
    }

    private ResultItem getVmProperties(Object object) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        PropertyValue propertyValue;
        List list;
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType(this._vimObjectReferenceService.getResourceObjectType(object));
        managedObjectReference.setValue(this._vimObjectReferenceService.getValue(object));
        String string = this._vimObjectReferenceService.getServerGuid(object);
        ServiceContent serviceContent = this.getServiceContent(string);
        if (serviceContent == null) {
            return null;
        }
        VirtualMachineConfigInfo virtualMachineConfigInfo = null;
        VmData vmData = new VmData();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.setType("Datacenter");
        propertySpec.getPathSet().add("name");
        PropertySpec propertySpec2 = new PropertySpec();
        propertySpec2.setAll(Boolean.FALSE);
        propertySpec2.setType(VM_TYPE);
        propertySpec2.getPathSet().add("config");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(Boolean.FALSE);
        objectSpec.getSelectSet().addAll(VmDataProviderImpl.buildTraversalSpecForVMToDatacenter());
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getPropSet().add(propertySpec2);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        List list2 = _vimPort.retrieveProperties(serviceContent.getPropertyCollector(), arrayList);
        if (list2 != null) {
            for (ObjectContent objectContent : list2) {
                VirtualDevice virtualDevice;
                if (VM_TYPE.equalsIgnoreCase(objectContent.getObj().getType())) {
                    list = objectContent.getPropSet();
                    if (list == null) continue;
                    propertyValue = list.iterator();
                    while (propertyValue.hasNext()) {
                        virtualDevice = (DynamicProperty)propertyValue.next();
                        virtualMachineConfigInfo = (VirtualMachineConfigInfo)virtualDevice.getVal();
                    }
                    continue;
                }
                list = objectContent.getPropSet();
                if (list == null || !(propertyValue = list.iterator()).hasNext()) continue;
                virtualDevice = (DynamicProperty)propertyValue.next();
                vmData.datacenterName = (String)virtualDevice.getVal();
            }
        }
        long l = 0L;
        if (virtualMachineConfigInfo != null) {
            list = virtualMachineConfigInfo.getHardware().getDevice();
            for (VirtualDevice virtualDevice : list) {
                if (!(virtualDevice instanceof VirtualDisk)) continue;
                l += ((VirtualDisk)virtualDevice).getCapacityInKB();
            }
        }
        vmData.capacityInKb = l + " KB";
        vmData.numberOfVirtualCpus = virtualMachineConfigInfo.getHardware().getNumCPU() + " CPU";
        list = new ResultItem();
        ((ResultItem)list).resourceObject = object;
        propertyValue = new PropertyValue();
        propertyValue.resourceObject = object;
        propertyValue.propertyName = VMDATA_PROPERTY;
        propertyValue.value = vmData;
        ((ResultItem)list).properties = new PropertyValue[]{propertyValue};
        return list;
    }

    private static List<SelectionSpec> buildTraversalSpecForVMToDatacenter() {
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("VisitFolders");
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setType("Folder");
        traversalSpec.setPath("parent");
        traversalSpec.setSkip(Boolean.FALSE);
        traversalSpec.setName("VisitFolders");
        traversalSpec.getSelectSet().add(selectionSpec);
        SelectionSpec selectionSpec2 = new SelectionSpec();
        selectionSpec2.setName("vAppToVApp");
        SelectionSpec selectionSpec3 = new SelectionSpec();
        selectionSpec3.setName("vAppToFolder");
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setType("VirtualApp");
        traversalSpec2.setPath("parentFolder");
        traversalSpec2.setSkip(Boolean.FALSE);
        traversalSpec2.setName("vAppToFolder");
        traversalSpec2.getSelectSet().add(selectionSpec);
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setType("VirtualApp");
        traversalSpec3.setPath("parentVApp");
        traversalSpec3.setSkip(Boolean.FALSE);
        traversalSpec3.setName("vAppToVApp");
        traversalSpec3.getSelectSet().add(selectionSpec2);
        traversalSpec3.getSelectSet().add(selectionSpec3);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setType(VM_TYPE);
        traversalSpec4.setPath("parentVApp");
        traversalSpec4.setSkip(Boolean.FALSE);
        traversalSpec4.setName("vmTovApp");
        traversalSpec4.getSelectSet().add(traversalSpec3);
        traversalSpec4.getSelectSet().add(traversalSpec2);
        TraversalSpec traversalSpec5 = new TraversalSpec();
        traversalSpec5.setType(VM_TYPE);
        traversalSpec5.setPath("parent");
        traversalSpec5.setSkip(Boolean.FALSE);
        traversalSpec5.setName("vmToFolder");
        traversalSpec5.getSelectSet().add(selectionSpec);
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add((SelectionSpec)traversalSpec5);
        arrayList.add((SelectionSpec)traversalSpec4);
        arrayList.add((SelectionSpec)traversalSpec);
        return arrayList;
    }

    private ServerInfo getServerInfoObject(String string) {
        UserSession userSession = this._userSessionService.getUserSession();
        for (ServerInfo serverInfo : userSession.serversInfo) {
            if (!serverInfo.serviceGuid.equalsIgnoreCase(string)) continue;
            return serverInfo;
        }
        return null;
    }

    private ServiceContent getServiceContent(String string) {
        ServerInfo serverInfo = this.getServerInfoObject(string);
        String string2 = serverInfo.sessionCookie;
        String string3 = serverInfo.serviceUrl;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("getServiceContent: sessionCookie = " + string2 + ", serviceUrl= " + string3));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("vmware_soap_session=" + string2);
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put("Cookie", arrayList);
        Map map = ((BindingProvider)_vimPort).getRequestContext();
        map.put("javax.xml.ws.service.endpoint.address", string3);
        map.put("javax.xml.ws.session.maintain", true);
        map.put("javax.xml.ws.http.request.headers", hashMap);
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType(SERVICE_INSTANCE);
        managedObjectReference.setValue(SERVICE_INSTANCE);
        ServiceContent serviceContent = null;
        try {
            serviceContent = _vimPort.retrieveServiceContent(managedObjectReference);
        }
        catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
            _logger.error((Object)("getServiceContent error: " + (Object)((Object)runtimeFaultFaultMsg)));
        }
        return serviceContent;
    }

    static {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
        TrustManager[] trustManagerArray = new TrustManager[1];
        TrustAllTrustManager trustAllTrustManager = new TrustAllTrustManager();
        trustManagerArray[0] = trustAllTrustManager;
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _logger.info((Object)noSuchAlgorithmException);
        }
        SSLSessionContext sSLSessionContext = sSLContext.getServerSessionContext();
        sSLSessionContext.setSessionTimeout(0);
        try {
            sSLContext.init(null, trustManagerArray, null);
        }
        catch (KeyManagementException keyManagementException) {
            _logger.info((Object)keyManagementException);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
    }

    private static class TrustAllTrustManager
    implements TrustManager,
    X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }
}

