/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.common.api.filters;

import com.vmware.vise.common.api.filters.QueryFilterBuilder;
import com.vmware.vise.common.api.filters.QueryFilterRegistry;
import com.vmware.vise.util.ValidationUtil;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.DisposableBean;

public class QueryFilterBuilderRegistrar
implements DisposableBean {
    private final QueryFilterRegistry _registry;
    private final Collection<QueryFilterBuilder> _builders;

    public QueryFilterBuilderRegistrar(QueryFilterRegistry queryFilterRegistry, Collection<QueryFilterBuilder> collection) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryFilterRegistry, collection});
        this._registry = queryFilterRegistry;
        this._builders = Collections.unmodifiableCollection(collection);
        this.registerBuilders();
    }

    public void destroy() {
        this.unregisterBuilders();
    }

    private void registerBuilders() {
        for (QueryFilterBuilder queryFilterBuilder : this._builders) {
            this._registry.registerFilterBuilder(queryFilterBuilder);
        }
    }

    private void unregisterBuilders() {
        for (QueryFilterBuilder queryFilterBuilder : this._builders) {
            this._registry.unregisterFilterBuilder(queryFilterBuilder);
        }
    }
}

