/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.impl;

import com.vmware.cdc.vcenter.AlarmChange;
import com.vmware.opsmgmt.client.alarms.ServiceAlarmInfo;
import com.vmware.opsmgmt.client.alarms.util.AlarmUtil;
import com.vmware.opsmgmt.client.alarms.util.ServiceAlarmInfoRetriever;
import com.vmware.opsmgmt.client.alarms.util.Util;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vim.alarm.AlarmState;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.messaging.AlarmChangeProcessor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmChangeProcessorImpl
implements AlarmChangeProcessor<AlarmState> {
    private static final Log _logger = LogFactory.getLog(AlarmChangeProcessorImpl.class);
    private static final String ALARM_INFOS_QUERY_NAME = "AlarmChangeProcessorImpl.alarmInfos";
    private static final String ENTITY_NAMES_QUERY_NAME = "AlarmChangeProcessorImpl.entityNames";
    private final QueryExecutor queryExecutor;
    private final QuerySpecBuilder querySpecBuilder;
    private ServiceAlarmInfoRetriever _serviceAlarmInfoRetriever;

    public AlarmChangeProcessorImpl(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this.queryExecutor = queryExecutor;
        this.querySpecBuilder = querySpecBuilder;
    }

    public void setServiceAlarmInfoRetriever(ServiceAlarmInfoRetriever serviceAlarmInfoRetriever) {
        this._serviceAlarmInfoRetriever = serviceAlarmInfoRetriever;
    }

    public PartialUpdate<AlarmState> process(Collection<AlarmChange> collection, String string) {
        PartialUpdate partialUpdate = PartialUpdate.empty();
        for (AlarmChange alarmChange : collection) {
            PartialUpdateItem<AlarmState> partialUpdateItem = this.createAlarmUpdate(alarmChange);
            partialUpdate.getUpdates().add(partialUpdateItem);
        }
        boolean bl = this.addMetadataToNewAlarms((PartialUpdate<AlarmState>)partialUpdate, string);
        if (!bl) {
            AlarmChangeProcessorImpl.filterOutNewAlarms((PartialUpdate<AlarmState>)partialUpdate);
        }
        partialUpdate.setDestination("/topic/alarms");
        return partialUpdate;
    }

    private static void filterOutNewAlarms(PartialUpdate<AlarmState> partialUpdate) {
        ArrayList<PartialUpdateItem> arrayList = new ArrayList<PartialUpdateItem>();
        for (PartialUpdateItem partialUpdateItem : partialUpdate.updates) {
            if (!partialUpdateItem.isDelta) continue;
            arrayList.add(partialUpdateItem);
        }
        partialUpdate.updates = arrayList;
    }

    private static boolean hasNewAlarms(PartialUpdate<AlarmState> partialUpdate) {
        for (PartialUpdateItem partialUpdateItem : partialUpdate.getUpdates()) {
            if (partialUpdateItem.isDelta) continue;
            return true;
        }
        return false;
    }

    private PartialUpdateItem<AlarmState> createAlarmUpdate(AlarmChange alarmChange) {
        PartialUpdateItem partialUpdateItem = null;
        AlarmChange.Kind kind = alarmChange.getKind();
        if (kind == null) {
            _logger.debug((Object)"Invalid alarm update kind.");
            return partialUpdateItem;
        }
        AlarmState alarmState = AlarmChangeProcessorImpl.toAlarmState(alarmChange);
        switch (kind) {
            case CLEAR: {
                partialUpdateItem = PartialUpdateItem.deltaOf(null, (Object)alarmState.key);
                if (alarmState.alarm == null) break;
                AlarmUtil.assignMetadata(partialUpdateItem, "objUpdateGuid", alarmState.alarm.getServerGuid());
                break;
            }
            case TRIGGER: {
                partialUpdateItem = PartialUpdateItem.of((Object)alarmState, (Object)alarmChange.getAlarm());
                AlarmUtil.assignMetadata(partialUpdateItem, "objUpdateGuid", alarmState.entity.getServerGuid());
                break;
            }
            case RETRIGGER: 
            case ACKNOWLEDGE: {
                partialUpdateItem = PartialUpdateItem.deltaOf((Object)alarmState, (Object)alarmState.alarm);
                AlarmUtil.assignMetadata(partialUpdateItem, "objUpdateGuid", alarmState.entity.getServerGuid());
                break;
            }
            default: {
                _logger.warn((Object)String.format("Unknown alarm update kind %s.", kind));
            }
        }
        return partialUpdateItem;
    }

    private boolean addMetadataToNewAlarms(PartialUpdate<AlarmState> partialUpdate, String string) {
        if (!AlarmChangeProcessorImpl.hasNewAlarms(partialUpdate)) {
            return true;
        }
        ArrayList<AlarmState> arrayList = new ArrayList<AlarmState>();
        HashMap<ManagedObjectReference, AlarmInfo> hashMap = new HashMap<ManagedObjectReference, AlarmInfo>();
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        HashSet<ManagedObjectReference> hashSet2 = new HashSet<ManagedObjectReference>();
        HashMap<ManagedObjectReference, String> hashMap2 = new HashMap<ManagedObjectReference, String>();
        this.extractAlarmInfosAndEntities(partialUpdate.getUpdates(), arrayList, hashMap, hashSet, hashSet2);
        Set<ManagedObjectReference> set = hashMap.keySet();
        if (!this.populateAlarmInfos(hashMap, hashSet, hashSet2, set) || !this.populateEntityNames(hashSet, hashSet2, hashMap2)) {
            return false;
        }
        Map<String, ServiceAlarmInfo> map = this._serviceAlarmInfoRetriever.retrieve(arrayList, string);
        this.populateMetadataForServiceAlarms(partialUpdate, hashMap, hashMap2, map);
        return true;
    }

    private void populateMetadataForServiceAlarms(PartialUpdate<AlarmState> partialUpdate, HashMap<ManagedObjectReference, AlarmInfo> hashMap, Map<ManagedObjectReference, String> map, Map<String, ServiceAlarmInfo> map2) {
        for (PartialUpdateItem partialUpdateItem : partialUpdate.updates) {
            if (partialUpdateItem.isDelta) continue;
            AlarmState alarmState = (AlarmState)partialUpdateItem.data;
            String string = alarmState.key;
            ManagedObjectReference managedObjectReference = alarmState.entity;
            AlarmInfo alarmInfo = hashMap.get(alarmState.alarm);
            if (alarmInfo != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, string, alarmInfo);
                ManagedObjectReference managedObjectReference2 = alarmInfo.entity;
                this.assignAlarmInfoNameMetadata(map, (PartialUpdateItem<AlarmState>)partialUpdateItem, managedObjectReference2);
                boolean bl = AlarmUtil.isVamiLinkVisisble(alarmInfo, managedObjectReference);
                AlarmUtil.assignMetadata(partialUpdateItem, "showVAMILink", bl);
                AlarmUtil.assignMetadata(partialUpdateItem, "issueUri", DefaultUriSchemeUtil.createUri((String)"AlarmIssue", (String)string));
                this.assignIssueInfoMetadata(map, map2, (PartialUpdateItem<AlarmState>)partialUpdateItem, alarmState, managedObjectReference, alarmInfo);
                continue;
            }
            _logger.error((Object)"AlarmInfo is null!");
        }
    }

    private void assignIssueInfoMetadata(Map<ManagedObjectReference, String> map, Map<String, ServiceAlarmInfo> map2, PartialUpdateItem<AlarmState> partialUpdateItem, AlarmState alarmState, ManagedObjectReference managedObjectReference, AlarmInfo alarmInfo) {
        String string;
        IssueInfo issueInfo = new IssueInfo();
        if (managedObjectReference != null) {
            issueInfo.entity = managedObjectReference;
            string = map.get(managedObjectReference);
            if (string != null) {
                issueInfo.entityName = string;
            } else {
                _logger.error((Object)"AlarmState entity name is null");
            }
        } else {
            _logger.error((Object)"AlarmState entity is null");
        }
        issueInfo.description = alarmInfo.description;
        string = map2.get(Util.buildAlarmKey(alarmState));
        issueInfo.service = string;
        AlarmUtil.assignMetadata(partialUpdateItem, "issueInfo", issueInfo);
    }

    private void assignAlarmInfoNameMetadata(Map<ManagedObjectReference, String> map, PartialUpdateItem<AlarmState> partialUpdateItem, ManagedObjectReference managedObjectReference) {
        if (managedObjectReference != null) {
            String string = map.get(managedObjectReference);
            if (string != null) {
                AlarmUtil.assignMetadata(partialUpdateItem, "alarmInfoName", string);
            } else {
                _logger.error((Object)"AlarmInfo entity name is null.");
            }
        } else {
            _logger.error((Object)"AlarmInfo entity is null.");
        }
    }

    private boolean populateAlarmInfos(HashMap<ManagedObjectReference, AlarmInfo> hashMap, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2, Set<ManagedObjectReference> set3) {
        PropertyValue[] propertyValueArray;
        if (set3.isEmpty()) {
            return true;
        }
        try {
            propertyValueArray = this.queryProperties(set3, "info", ALARM_INFOS_QUERY_NAME);
        }
        catch (Exception exception) {
            _logger.error((Object)("[LiveRefresh] Couldnt retrieve infos: " + exception.getMessage()), (Throwable)exception);
            return false;
        }
        for (PropertyValue propertyValue : propertyValueArray) {
            AlarmInfo alarmInfo = (AlarmInfo)propertyValue.value;
            if (alarmInfo == null || alarmInfo.alarm == null) continue;
            hashMap.put(alarmInfo.alarm, alarmInfo);
            if (alarmInfo.entity == null) continue;
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmInfo.entity)) {
                set2.add(alarmInfo.entity);
                continue;
            }
            set.add(alarmInfo.entity);
        }
        return true;
    }

    private boolean populateEntityNames(Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2, Map<ManagedObjectReference, String> map) {
        PropertyValue[] propertyValueArray;
        for (ManagedObjectReference propertyValueArray2 : set2) {
            String string = VcServiceUtil.getServiceName((String)propertyValueArray2.getServerGuid());
            if (string == null) continue;
            map.put(propertyValueArray2, string);
        }
        if (set.isEmpty()) {
            return true;
        }
        try {
            propertyValueArray = this.queryProperties(set, "name", ENTITY_NAMES_QUERY_NAME);
        }
        catch (Exception exception) {
            _logger.error((Object)"Cannot extract entity names", (Throwable)exception);
            return false;
        }
        for (PropertyValue propertyValue : propertyValueArray) {
            map.put((ManagedObjectReference)propertyValue.resourceObject, (String)propertyValue.value);
        }
        return true;
    }

    private PropertyValue[] queryProperties(Set<ManagedObjectReference> set, String string, String string2) throws Exception {
        ResultItem[] resultItemArray;
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec(ArrayUtil.toArray(set, ManagedObjectReference.class), new String[]{string});
        querySpec.name = string2;
        ResultSet resultSet = this.queryExecutor.getData(querySpec);
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (resultSet != null && (resultItemArray = resultSet.items) != null && resultItemArray.length > 0 && resultItemArray[0] != null) {
            for (ResultItem resultItem : resultItemArray) {
                for (PropertyValue propertyValue : resultItem.properties) {
                    propertyValue.resourceObject = resultItem.resourceObject;
                    arrayList.add(propertyValue);
                }
            }
        }
        if (arrayList.isEmpty() && resultSet != null && resultSet.error != null) {
            throw resultSet.error;
        }
        return arrayList.toArray(new PropertyValue[0]);
    }

    private void extractAlarmInfosAndEntities(List<PartialUpdateItem<AlarmState>> list, List<AlarmState> list2, HashMap<ManagedObjectReference, AlarmInfo> hashMap, Set<ManagedObjectReference> set, Set<ManagedObjectReference> set2) {
        for (PartialUpdateItem<AlarmState> partialUpdateItem : list) {
            if (partialUpdateItem.isDelta) continue;
            AlarmState alarmState = (AlarmState)partialUpdateItem.data;
            list2.add(alarmState);
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)alarmState.entity)) {
                set2.add(alarmState.entity);
            } else {
                set.add(alarmState.entity);
            }
            hashMap.put(alarmState.alarm, null);
        }
    }

    private static AlarmState toAlarmState(AlarmChange alarmChange) {
        AlarmState alarmState = new AlarmState();
        alarmState.key = AlarmChangeProcessorImpl.getAlarmStateKey(alarmChange);
        alarmState.entity = alarmChange.getResource() instanceof ManagedObjectReference ? (ManagedObjectReference)alarmChange.getResource() : null;
        alarmState.alarm = (ManagedObjectReference)alarmChange.getAlarm();
        alarmState.overallStatus = StringUtil.isNullOrEmpty((String)alarmChange.getOverallStatus()) ? null : ManagedEntity.Status.valueOf((String)alarmChange.getOverallStatus());
        alarmState.time = alarmChange.getTime();
        alarmState.eventKey = alarmChange.getEventKey();
        alarmState.acknowledged = AlarmChange.Kind.ACKNOWLEDGE.equals((Object)alarmChange.getKind());
        alarmState.acknowledgedByUser = alarmChange.getAcknowledgedByUser();
        alarmState.acknowledgedTime = alarmChange.getAcknowledgedTime();
        return alarmState;
    }

    private static String getAlarmStateKey(AlarmChange alarmChange) {
        if (!(alarmChange.getAlarm() instanceof ManagedObjectReference)) {
            return null;
        }
        if (!(alarmChange.getResource() instanceof ManagedObjectReference)) {
            return null;
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)alarmChange.getAlarm();
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)alarmChange.getResource();
        return managedObjectReference.getValue() + "." + managedObjectReference2.getValue();
    }
}

