/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.alarms.util;

import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.HashMap;

public class AlarmUtil {
    public static final String INFO_PROPERTY = "info";
    public static final String NAME_PROPERTY = "name";
    public static final String INFO_ENTITY_PROPERTY = "info.entity";
    public static final String IS_ROOT_FOLDER_PROPERTY = "isRootFolder";
    public static final String GENERIC_ISSUE_TYPE = "Issue";
    public static final String ALARM_ISSUE_TYPE = "AlarmIssue";
    public static final String META_ALARMINFO_NAME = "alarmInfoName";
    public static final String META_SHOW_VAMI_LINK = "showVAMILink";
    public static final String META_ISSUE_URI = "issueUri";
    public static final String META_ISSUE_INFO = "issueInfo";
    public static final String META_OBJ_GUID = "objUpdateGuid";
    public static final String DB_HEALTH_ALARM_SYSTEM_NAME = "alarm.DBHealthAlarm";
    public static final String OS_TYPE_LINUX = "linux";
    public static final int TOP_TRIGGERED_ALARMS_COUNT_IN_VC = 150;

    public static <T> void assignMetadata(PartialUpdateItem<T> partialUpdateItem, String string, Object object) {
        HashMap<String, Object> hashMap = partialUpdateItem.getMetadata();
        if (hashMap == null) {
            hashMap = new HashMap<String, Object>();
            partialUpdateItem.setMetadata(hashMap);
        }
        hashMap.put(string, object);
    }

    public static boolean isVamiLinkVisisble(AlarmInfo alarmInfo, ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null || alarmInfo == null) {
            return false;
        }
        return AlarmUtil.isDBHealthAlarm(alarmInfo) && AlarmUtil.vcIsVCSA(managedObjectReference.getServerGuid());
    }

    private static boolean isDBHealthAlarm(AlarmInfo alarmInfo) {
        return !StringUtil.isNullOrEmpty((String)alarmInfo.systemName) && alarmInfo.systemName.equals(DB_HEALTH_ALARM_SYSTEM_NAME);
    }

    private static boolean vcIsVCSA(String string) {
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            return false;
        }
        if (VcServiceUtil.is65VcOrLaterByServerGuid((String)string)) {
            AboutInfo aboutInfo = vcService.getServiceInstanceContent().about;
            return !StringUtil.isNullOrEmpty((String)aboutInfo.osType) && aboutInfo.osType.contains(OS_TYPE_LINUX);
        }
        return false;
    }
}

