/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.PropertyParam;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.content.library.StorageBacking;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

@QueryModel(value="com.vmware.content.LibraryModel")
public class LibraryExtendedDataModel {
    @Property(value="com.vmware.content.LibraryModel/type")
    public Boolean libraryType;
    @Relationship(value={"com.vmware.content.library.ItemModel/libraryId~"})
    @Property(value="com.vmware.content.library.ItemModel/@modelKey")
    public URI[] libraryItem;

    @PredicateProperty
    public static PropertyPredicate getIsLocalLibrary() {
        return new PropertyPredicate("com.vmware.content.LibraryModel/type", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"LOCAL");
    }

    @DerivedProperty
    public static ManagedObjectReference getVcenter(@PropertyParam(value="com.vmware.content.LibraryModel/vcenter") String vcenterId) {
        return CisIdConverter.fromGlobalCisId((String)vcenterId, (String)"Folder");
    }

    @DerivedProperty
    public static String[] getDatastoreIds(@PropertyParam(value="com.vmware.content.LibraryModel/storageBackings") List<StorageBacking> storageBackings) {
        ArrayList<String> datastoreIds = new ArrayList<String>();
        if (storageBackings != null) {
            for (StorageBacking backing : storageBackings) {
                datastoreIds.add(backing.getDatastoreId());
            }
        }
        return datastoreIds.toArray(new String[datastoreIds.size()]);
    }
}

