/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.impl;

import com.vmware.content.Library;
import com.vmware.content.LibraryModel;
import com.vmware.content.LocalLibrary;
import com.vmware.content.SubscribedLibrary;
import com.vmware.content.SubscribedLibraryTypes;
import com.vmware.content.library.OptimizationInfo;
import com.vmware.content.library.PublishInfo;
import com.vmware.content.library.StorageBacking;
import com.vmware.content.library.SubscriptionInfo;
import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.library.CreateLibrarySpec;
import com.vmware.vsphere.client.library.specs.DeleteLibrarySpec;
import com.vmware.vsphere.client.library.specs.EditLibraryBasicSpec;
import com.vmware.vsphere.client.library.specs.EditLibrarySpec;
import com.vmware.vsphere.client.library.specs.EvictLibrarySpec;
import com.vmware.vsphere.client.library.specs.LibraryNameValidatorSpec;
import com.vmware.vsphere.client.library.specs.SubscriptionUrlValidatorSpec;
import com.vmware.vsphere.client.library.specs.SyncLibrarySpec;
import com.vmware.vsphere.client.library.util.LibraryUtil;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(LibraryMutationProvider.class);
    private final Library _libraryService;
    private final LocalLibrary _localLibraryService;
    private final SubscribedLibrary _subscribedLibraryService;
    private final DataService _dataService;
    private VapiTaskMonitor _vapiTaskMonitor;
    private final String NFS4_QUERY_STRING = "?version=4";

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public LibraryMutationProvider(Library libraryService, LocalLibrary localLibraryService, SubscribedLibrary subscribedLibraryService, DataService dataService) {
        this._libraryService = libraryService;
        this._localLibraryService = localLibraryService;
        this._subscribedLibraryService = subscribedLibraryService;
        this._dataService = dataService;
    }

    public OperationResult add(CreateLibrarySpec createSpec) {
        OperationResult result = new OperationResult();
        String libraryId = UUID.randomUUID().toString();
        if (StringUtil.isNullOrEmpty((String)createSpec.name)) {
            throw new IllegalArgumentException(LibraryUtil.getLocalizedString("error.noLibraryName"));
        }
        if (createSpec.storageFileSystemPath != null) {
            createSpec.storageFileSystemPath = createSpec.storageFileSystemPath.trim();
        }
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating create library. Client token: " + asyncCallback.getActivationId()));
        try {
            if (LibraryModel.LibraryType.LOCAL.equals((Object)createSpec.type)) {
                this._localLibraryService.create(libraryId, this.createLocalLibrary(createSpec), (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            } else if (LibraryModel.LibraryType.SUBSCRIBED.equals((Object)createSpec.type)) {
                this._subscribedLibraryService.create(libraryId, this.createSubscribedLibrary(createSpec), (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            }
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            String errorMsg = "Create " + createSpec.type + " library failed: ";
            _logger.error((Object)errorMsg, (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult remove(URI libraryUri, DeleteLibrarySpec removeSpec) throws Exception {
        OperationResult result = new OperationResult();
        result.entity = libraryUri;
        result.error = this.getLibraryError(libraryUri);
        if (result.error != null) {
            return result;
        }
        String libraryId = UriSchemeUtil.getId((URI)libraryUri);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating delete library. Client token: " + asyncCallback.getActivationId()));
        try {
            Boolean isLocalLibrary = (Boolean)QueryUtil.getProperty((DataService)this._dataService, (Object)libraryUri, (String)"com.vmware.content.LibraryModel/isLocalLibrary");
            if (isLocalLibrary.booleanValue()) {
                this._localLibraryService.delete(libraryId, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            } else {
                this._subscribedLibraryService.delete(libraryId, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            }
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to delete library.", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryUri, SyncLibrarySpec syncSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryUri;
        result.error = this.getLibraryError(libraryUri);
        if (result.error != null) {
            return result;
        }
        String libraryId = UriSchemeUtil.getId((URI)libraryUri);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating sync library. Client token: " + asyncCallback.getActivationId()));
        try {
            this._subscribedLibraryService.sync(libraryId, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Sync operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryUri, EvictLibrarySpec evictSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryUri;
        result.error = this.getLibraryError(libraryUri);
        if (result.error != null) {
            return result;
        }
        String libraryId = UriSchemeUtil.getId((URI)libraryUri);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating evict on library content. Client token: " + asyncCallback.getActivationId()));
        try {
            this._subscribedLibraryService.evict(libraryId, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Evict library operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryUri, EditLibraryBasicSpec editSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryUri;
        result.error = this.getLibraryError(libraryUri);
        if (result.error != null) {
            return result;
        }
        String libraryId = UriSchemeUtil.getId((URI)libraryUri);
        LibraryModel library = new LibraryModel();
        if (!StringUtil.isNullOrEmpty((String)editSpec.name)) {
            library.setName(editSpec.name);
        }
        if (editSpec.description != null) {
            library.setDescription(editSpec.description);
        }
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating udpate library. Client token: " + asyncCallback.getActivationId()));
        try {
            this._libraryService.update(libraryId, library, (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Edit operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public OperationResult apply(URI libraryUri, EditLibrarySpec editSpec) {
        OperationResult result = new OperationResult();
        result.entity = libraryUri;
        result.error = this.getLibraryError(libraryUri);
        if (result.error != null) {
            return result;
        }
        String libraryId = UriSchemeUtil.getId((URI)libraryUri);
        LibraryModel library = this._libraryService.get(libraryId);
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
        _logger.info((Object)("Initiating update library. Client token: " + asyncCallback.getActivationId()));
        try {
            if (editSpec.isLocalLibrary.booleanValue()) {
                this._localLibraryService.update(libraryId, this.updateLocalLibrary(editSpec, library), (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            } else {
                this._subscribedLibraryService.update(libraryId, this.updateSubscribedLibrary(editSpec, library), (AsyncCallback)asyncCallback, asyncCallback.getInvocationConfig());
            }
            result.task = asyncCallback.waitForActivationTask();
        }
        catch (Exception e) {
            _logger.error((Object)"Edit operation failed", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    public ValidationResult validate(URI libraryUri, SubscriptionUrlValidatorSpec subscribeUrlSpec) {
        ValidationResult result = new ValidationResult();
        try {
            URL url = new URL(subscribeUrlSpec.subscriptionUrl);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            SubscriptionInfo subscribeInfo = this.createSubscriptionInfo(uri, subscribeUrlSpec.sslThumbprint, subscribeUrlSpec.isAuthBasic, subscribeUrlSpec.username, subscribeUrlSpec.password, false);
            SubscribedLibraryTypes.ProbeResult probeResult = this._subscribedLibraryService.probe(subscribeInfo);
            result.result = probeResult;
        }
        catch (URISyntaxException e) {
            String errMsg = LibraryUtil.getLocalizedString("error.invalidUrl");
            _logger.error((Object)errMsg);
            result.error = ErrorTransformUtil.convertError((String)errMsg);
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to validate subscription information.", (Throwable)e);
            result.error = ErrorTransformUtil.convertError((Exception)e);
        }
        return result;
    }

    private LibraryModel createLocalLibrary(CreateLibrarySpec createSpec) throws URIException {
        LibraryModel library = new LibraryModel();
        library.setDescription(createSpec.description);
        library.setServerGuid(createSpec.vcServiceGuid);
        library.setName(createSpec.name);
        library.setType(LibraryModel.LibraryType.LOCAL);
        library.setPublishInfo(this.createPublishInfo(createSpec.isExternallyPublished, createSpec.isAuthBasic, createSpec.localPublishedUsername, createSpec.localPublishedPassword));
        library.setStorageBackings(this.getStorageBackings(createSpec));
        if (createSpec.isExternallyPublished.booleanValue() && VcServiceUtil.isVc61OrLater((String)createSpec.vcServiceGuid)) {
            OptimizationInfo optimizationInfo = new OptimizationInfo();
            optimizationInfo.setOptimizeRemotePublishing(createSpec.isStreamOptimized);
            library.setOptimizationInfo(optimizationInfo);
        }
        return library;
    }

    private LibraryModel updateLocalLibrary(EditLibrarySpec editSpec, LibraryModel library) {
        if (editSpec.isPublished != null) {
            library.setPublishInfo(this.updatePublishInfo(library.getPublishInfo(), editSpec.isPublished, editSpec.isAuthBasic, editSpec.publishUsername, editSpec.passwordHasChanged, editSpec.publishPassword));
        }
        return library;
    }

    private PublishInfo createPublishInfo(Boolean isPublished, Boolean isAuthBasic, String username, String password) {
        PublishInfo publishInfo = new PublishInfo();
        publishInfo.setPublished(isPublished);
        if (isPublished.booleanValue()) {
            this.setPublishAuthMethod(publishInfo, isAuthBasic, username, password);
        } else {
            publishInfo.setAuthenticationMethod(PublishInfo.AuthenticationMethod.NONE);
        }
        return publishInfo;
    }

    private PublishInfo updatePublishInfo(PublishInfo publishInfo, Boolean isPublished, Boolean isAuthBasic, String username, Boolean passwordHasChanged, String password) {
        publishInfo.setPublished(isPublished);
        if (isPublished.booleanValue()) {
            if (passwordHasChanged.booleanValue() || publishInfo.getAuthenticationMethod() == null || publishInfo.getAuthenticationMethod().equals((Object)PublishInfo.AuthenticationMethod.BASIC) != isAuthBasic.booleanValue()) {
                this.setPublishAuthMethod(publishInfo, isAuthBasic, username, password);
            }
        } else {
            publishInfo.setUserName(null);
            publishInfo.setPassword(null);
            publishInfo.setAuthenticationMethod(PublishInfo.AuthenticationMethod.NONE);
        }
        return publishInfo;
    }

    private void setPublishAuthMethod(PublishInfo publishInfo, Boolean isAuthBasic, String username, String password) {
        if (isAuthBasic.booleanValue()) {
            publishInfo.setUserName(username);
            publishInfo.setPassword(password.toCharArray());
            publishInfo.setAuthenticationMethod(PublishInfo.AuthenticationMethod.BASIC);
        } else {
            publishInfo.setUserName(null);
            publishInfo.setPassword(null);
            publishInfo.setAuthenticationMethod(PublishInfo.AuthenticationMethod.NONE);
        }
    }

    private LibraryModel createSubscribedLibrary(CreateLibrarySpec createSpec) throws URIException {
        LibraryModel library = new LibraryModel();
        library.setCreationTime(Calendar.getInstance());
        library.setServerGuid(createSpec.vcServiceGuid);
        library.setDescription(createSpec.description);
        library.setName(createSpec.name);
        library.setType(LibraryModel.LibraryType.SUBSCRIBED);
        library.setStorageBackings(this.getStorageBackings(createSpec));
        library.setSubscriptionInfo(this.createSubscriptionInfo(URI.create(createSpec.subscriptionUrl), createSpec.sslThumbprint, createSpec.isAuthBasic, createSpec.subscribedUsername, createSpec.subscribedPassword, createSpec.createLocalCopy));
        return library;
    }

    private LibraryModel updateSubscribedLibrary(EditLibrarySpec editSpec, LibraryModel library) {
        library.setSubscriptionInfo(this.updateSubscriptionInfo(library.getSubscriptionInfo(), editSpec.isSubscribed, editSpec.modifiedSubscriptionUrl, editSpec.sslThumbprint, editSpec.isAuthBasic, editSpec.subscribeUsername, editSpec.passwordHasChanged, editSpec.subscribePassword, editSpec.createLocalCopy));
        return library;
    }

    private SubscriptionInfo createSubscriptionInfo(URI subscriptionUrl, String sslThumbprint, Boolean isAuthBasic, String username, String password, Boolean createLocalCopy) {
        SubscriptionInfo subscriptionInfo = new SubscriptionInfo();
        subscriptionInfo.setSubscriptionUrl(subscriptionUrl);
        subscriptionInfo.setOnDemand(Boolean.valueOf(createLocalCopy == false));
        subscriptionInfo.setAutomaticSyncEnabled(Boolean.valueOf(true));
        subscriptionInfo.setSslThumbprint(sslThumbprint);
        this.setSubscribedAuthMethod(subscriptionInfo, isAuthBasic, username, password);
        return subscriptionInfo;
    }

    private SubscriptionInfo updateSubscriptionInfo(SubscriptionInfo subscriptionInfo, Boolean isSubscribed, String subscriptionUrl, String sslThumbprint, Boolean isAuthBasic, String username, Boolean passwordHasChanged, String password, Boolean createLocalCopy) {
        subscriptionInfo.setOnDemand(Boolean.valueOf(createLocalCopy == false));
        subscriptionInfo.setAutomaticSyncEnabled(isSubscribed);
        subscriptionInfo.setSslThumbprint(sslThumbprint);
        if (!StringUtil.isNullOrEmpty((String)subscriptionUrl)) {
            subscriptionInfo.setSubscriptionUrl(URI.create(subscriptionUrl));
        }
        if (passwordHasChanged.booleanValue() || subscriptionInfo.getAuthenticationMethod() == null || subscriptionInfo.getAuthenticationMethod().equals((Object)SubscriptionInfo.AuthenticationMethod.BASIC) != isAuthBasic.booleanValue()) {
            this.setSubscribedAuthMethod(subscriptionInfo, isAuthBasic, username, password);
        }
        return subscriptionInfo;
    }

    private void setSubscribedAuthMethod(SubscriptionInfo subscriptionInfo, Boolean isAuthBasic, String username, String password) {
        if (isAuthBasic.booleanValue()) {
            subscriptionInfo.setUserName(username);
            subscriptionInfo.setPassword(password.toCharArray());
            subscriptionInfo.setAuthenticationMethod(SubscriptionInfo.AuthenticationMethod.BASIC);
        } else {
            subscriptionInfo.setUserName(null);
            subscriptionInfo.setPassword(null);
            subscriptionInfo.setAuthenticationMethod(SubscriptionInfo.AuthenticationMethod.NONE);
        }
    }

    private URI encodeURL(String url) throws URIException {
        URI uriFormatted = null;
        if (url.contains("?version=4")) {
            String path = url.substring(0, url.indexOf("?version=4"));
            String encodedUrl = URIUtil.encodePath((String)path, (String)StandardCharsets.UTF_8.toString());
            uriFormatted = URI.create(encodedUrl + "?version=4");
        } else {
            String encodedUrl = URIUtil.encodePath((String)url, (String)StandardCharsets.UTF_8.toString());
            uriFormatted = URI.create(encodedUrl);
        }
        return uriFormatted;
    }

    private List<StorageBacking> getStorageBackings(CreateLibrarySpec createSpec) throws URIException {
        ArrayList<StorageBacking> storageBackings = new ArrayList();
        if (createSpec.useDatastore.booleanValue()) {
            storageBackings = this.getStorageBackingList(createSpec.datastoreRefs);
        }
        if (createSpec.useFilesystem.booleanValue()) {
            StorageBacking sb = new StorageBacking();
            sb.setStorageUri(this.encodeURL(createSpec.storageFileSystemPath));
            sb.setType(StorageBacking.Type.OTHER);
            storageBackings.add(sb);
        }
        return storageBackings;
    }

    private List<StorageBacking> getStorageBackingList(ManagedObjectReference[] datastoreMorefs) {
        ArrayList<StorageBacking> storageBackingsList = new ArrayList<StorageBacking>();
        for (ManagedObjectReference moref : datastoreMorefs) {
            StorageBacking sb = new StorageBacking();
            String morefId = CisIdConverter.toGlobalCisId((ManagedObjectReference)moref, (String)moref.getServerGuid());
            sb.setDatastoreId(morefId);
            sb.setType(StorageBacking.Type.DATASTORE);
            storageBackingsList.add(sb);
        }
        return storageBackingsList;
    }

    public ValidationResult validate(LibraryNameValidatorSpec spec) {
        return this.validateLibraryNameInternal(null, spec);
    }

    public ValidationResult validate(URI libraryItemUri, LibraryNameValidatorSpec spec) {
        return this.validateLibraryNameInternal(libraryItemUri, spec);
    }

    private ValidationResult validateLibraryNameInternal(URI libraryUri, LibraryNameValidatorSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = libraryUri;
        validationResult.result = true;
        try {
            if (!this.isLibraryNameUnique(libraryUri, spec.libraryName).booleanValue()) {
                validationResult.result = false;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error when validating library name uniqueness", (Throwable)e);
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return validationResult;
    }

    private Boolean isLibraryNameUnique(URI libraryUri, String name) throws Exception {
        Boolean isNameUnique = true;
        String libraryName = StringUtils.trim((String)name);
        if (StringUtil.isNullOrEmpty((String)libraryName)) {
            throw new IllegalArgumentException(LibraryUtil.getLocalizedString("error.noLibraryName"));
        }
        PropertyConstraint libraryNameConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.Library", (String)"com.vmware.content.LibraryModel/name", (Comparator)Comparator.EQUALS, (Object)libraryName);
        QuerySpec qs = QueryUtil.buildQuerySpec((Constraint)libraryNameConstraint, (String[])new String[]{"com.vmware.content.LibraryModel/name"});
        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)qs);
        if (libraryUri == null) {
            isNameUnique = resultSet.items.length == 0;
        } else if (resultSet.items.length > 0) {
            for (ResultItem item : resultSet.items) {
                URI library = (URI)item.resourceObject;
                if (library.equals(libraryUri)) continue;
                isNameUnique = false;
                break;
            }
        }
        return isNameUnique;
    }

    private Exception getLibraryError(URI libraryUri) {
        if (libraryUri == null || StringUtil.isNullOrEmpty((String)libraryUri.toString())) {
            String errMsg = LibraryUtil.getLocalizedString("error.noLibraryURI");
            _logger.error((Object)errMsg);
            return ErrorTransformUtil.convertError((String)errMsg);
        }
        return null;
    }
}

