/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.library.impl;

import com.vmware.content.LibraryModel;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.library.model.LibraryDataModel;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;

public class LibraryPropertyProvider
implements PropertyProviderBean {
    private static final String CONTENTLIBRARY_DELETELOCALLIBRARY = "ContentLibrary.DeleteLocalLibrary";
    private static final String CONTENTLIBRARY_DELETESUBSCRIBEDLIBRARY = "ContentLibrary.DeleteSubscribedLibrary";
    private final DataFetchCommand _dataFetchCommand;
    private final DataService _dataService;

    public LibraryPropertyProvider(DataFetchCommand dataFetchCommand, DataService dataService) {
        Validate.notNull((Object)dataFetchCommand, (String)"dataFetchCommand is null");
        Validate.notNull((Object)dataService, (String)"dataService is null");
        this._dataFetchCommand = dataFetchCommand;
        this._dataService = dataService;
    }

    @type(value="com.vmware.content.Library")
    public Boolean getHasDeletePrivileges(URI libraryUri) throws Exception {
        Validate.notNull((Object)libraryUri, (String)"libraryUri is null.");
        String[] grantedPrivileges = (String[])QueryUtil.getProperty((DataService)this._dataService, (Object)libraryUri, (String)"grantedPrivileges");
        List<String> privilegesList = Arrays.asList(grantedPrivileges);
        Object[] libraryUriArray = new URI[]{libraryUri};
        Collection libraryData = this._dataFetchCommand.execute(LibraryDataModel.class, libraryUriArray);
        if (libraryData != null && libraryData.size() > 0 && privilegesList != null) {
            LibraryDataModel library = (LibraryDataModel)((Object)libraryData.iterator().next());
            if (LibraryModel.LibraryType.LOCAL.toString().equals(library.type)) {
                return privilegesList.contains(CONTENTLIBRARY_DELETELOCALLIBRARY);
            }
            return privilegesList.contains(CONTENTLIBRARY_DELETESUBSCRIBEDLIBRARY);
        }
        return true;
    }
}

