/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.impl;

import com.vmware.content.Library;
import com.vmware.content.library.ItemModel;
import com.vmware.content.library.ItemPath;
import com.vmware.content.library.item.File;
import com.vmware.content.library.item.FileTypes;
import com.vmware.vcenter.iso.IsoPath;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryItemPropertyProvider
implements PropertyProviderBean {
    private final File _fileService;
    private final IsoPath _contentLibIsoPathService;
    private final ItemPath _libraryItemPathService;
    private final Library _libraryService;
    private final DataService _dataService;
    private static final Log _logger = LogFactory.getLog(LibraryItemPropertyProvider.class);
    private static final String CL_PREFIX = "[contentLib]";
    private static final String IS_VAPP_TEMPLATE_PROPERTY = "com.vmware.content.type.ovf.OvfTemplate/isVappTemplate";
    private static final String IS_OVF_TEMPLATE_PROPERTY = "com.vmware.content.library.ItemModel/isOVFTemplate";
    private static final String LIBRARY_SERVER_GUID_PROPERTY = "com.vmware.content.LibraryModel/serverGuid";
    private static final String LIBRARY_RELATION_PROPERTY = "com.vmware.content.LibraryModel/libraryItem";

    public LibraryItemPropertyProvider(File fileService, IsoPath contentLibraryIsoPathService, ItemPath libraryItemPathService, Library libraryService, DataService dataService) {
        Validate.notNull((Object)fileService, (String)"fileService null");
        this._fileService = fileService;
        this._contentLibIsoPathService = contentLibraryIsoPathService;
        this._libraryItemPathService = libraryItemPathService;
        this._libraryService = libraryService;
        this._dataService = dataService;
    }

    @type(value="com.vmware.content.library.Item")
    public String[] getFiles(URI libraryItem) {
        Validate.notNull((Object)libraryItem, (String)"target object is null");
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
        ArrayList<String> result = new ArrayList<String>();
        List files = this._fileService.list(libraryItemId);
        for (FileTypes.Info file : files) {
            result.add(file.getName());
        }
        return (String[])ArrayUtil.toArray(result, String.class);
    }

    @type(value="com.vmware.content.library.Item")
    public String getContentLibraryIsoPath(URI libraryItem) {
        Validate.notNull((Object)libraryItem, (String)"target object is null");
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
        String path = null;
        if (libraryItemId != null && StringUtils.isNotEmpty((String)libraryItemId)) {
            path = this._contentLibIsoPathService.getDatastorePath(libraryItemId);
        }
        return path;
    }

    @type(value="com.vmware.content.library.Item")
    public String getContentLibraryFriendlyIsoPath(URI libraryItem, String datastorePath) {
        String friendlyPath = null;
        try {
            if (StringUtils.isNotEmpty((String)datastorePath)) {
                ItemModel itemModel = this._libraryItemPathService.getByDatastorePath(datastorePath);
                String libraryName = this._libraryService.get(itemModel.getLibraryId()).getName();
                if (itemModel != null) {
                    StringBuilder pathBuilder = new StringBuilder();
                    pathBuilder.append(CL_PREFIX).append(" /");
                    pathBuilder.append(libraryName).append("/");
                    pathBuilder.append(itemModel.getName());
                    friendlyPath = pathBuilder.toString();
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error fetching friendly Content Library ISO path for " + datastorePath + ":" + e));
            return datastorePath;
        }
        return friendlyPath;
    }

    @type(value="Folder")
    public Response getLibraryTemplates(ManagedObjectReference rootFolder) throws Exception {
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = "LibraryTemplates_Query";
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = this.buildTemplateConstraint(false, rootFolder.getServerGuid());
        querySpec.resourceSpec.constraint.targetType = "com.vmware.content.library.Item";
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{"com.vmware.content.library.ItemModel/isSubscribed", "com.vmware.content.library.ItemModel/itemType.@formatted", "com.vmware.content.library.ItemModel/libraryName", "isPublished", "com.vmware.content.library.ItemModel/size.@formatted", "primaryIconId", "com.vmware.content.library.ItemModel/name", "com.vmware.content.library.ItemModel/lastModifiedTime", "com.vmware.content.library.ItemModel/isCached.@formatted"};
        propertySpec.type = "com.vmware.content.library.Item";
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response data2 = this._dataService.getData(requestSpec);
        return data2;
    }

    private Constraint buildTemplateConstraint(boolean isVappTemplate, String serverGuid) {
        Constraint ovfTemplateConstraint = this.buildOVFTemplateConstraint(isVappTemplate, serverGuid);
        Constraint streamConstraint = this.buildStreamOptimizedConstraint();
        Constraint finalConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{ovfTemplateConstraint, streamConstraint}, (Conjoiner)Conjoiner.AND);
        finalConstraint.targetType = "com.vmware.content.library.Item";
        return finalConstraint;
    }

    private Constraint buildOVFTemplateConstraint(boolean isVappTemplate, String serverGuid) {
        PropertyConstraint vAppTemplateConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_VAPP_TEMPLATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)isVappTemplate);
        PropertyConstraint templateTypeConstraint = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)IS_OVF_TEMPLATE_PROPERTY, (Comparator)Comparator.EQUALS, (Object)true);
        PropertyConstraint librariesOnServer = QueryUtil.createPropertyConstraint((String)"com.vmware.content.Library", (String)LIBRARY_SERVER_GUID_PROPERTY, (Comparator)Comparator.EQUALS, (Object)serverGuid);
        RelationalConstraint libraryItemRelation = QueryUtil.createRelationalConstraint((String)LIBRARY_RELATION_PROPERTY, (Constraint)librariesOnServer, (Boolean)true, (String)"com.vmware.content.library.Item");
        Constraint templateConstraints = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{vAppTemplateConstraint, templateTypeConstraint}, (Conjoiner)Conjoiner.AND);
        templateConstraints.targetType = "com.vmware.content.library.Item";
        Constraint combinedConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{libraryItemRelation, templateConstraints}, (Conjoiner)Conjoiner.AND);
        combinedConstraint.targetType = "com.vmware.content.library.Item";
        return combinedConstraint;
    }

    private Constraint buildStreamOptimizedConstraint() {
        PropertyConstraint propConstraint1 = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)"isStreamOptimized", (Comparator)Comparator.EQUALS, (Object)false);
        PropertyConstraint propConstraint2 = QueryUtil.createPropertyConstraint((String)"com.vmware.content.library.Item", (String)"isStreamOptimized", (Comparator)Comparator.EQUALS, (Object)"NULL");
        Constraint streamOptimizedConstraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{propConstraint1, propConstraint2}, (Conjoiner)Conjoiner.OR);
        streamOptimizedConstraint.targetType = "com.vmware.content.library.Item";
        return streamOptimizedConstraint;
    }

    private ResultSpec buildResultSpec() {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        orderingPropertySpec.orderingType = SortType.ASCENDING;
        orderingPropertySpec.propertyNames = new String[]{"com.vmware.content.library.ItemModel/name"};
        orderingPropertySpec.type = "com.vmware.content.library.Item";
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        orderingCriteria.orderingProperties = new OrderingPropertySpec[]{orderingPropertySpec};
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = 100;
        resultSpec.offset = 0;
        resultSpec.order = orderingCriteria;
        return resultSpec;
    }
}

