/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.impl;

import com.vmware.content.library.item.DownloadSession;
import com.vmware.content.library.item.DownloadSessionModel;
import com.vmware.content.library.item.downloadsession.File;
import com.vmware.content.library.item.downloadsession.FileTypes;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vcenter.ovf.ExportSession;
import com.vmware.vcenter.ovf.ExportSessionTypes;
import com.vmware.vcenter.ovf.OvfFileInfo;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.libraryItem.model.LibraryItemEndpointInfo;
import com.vmware.vsphere.client.libraryItem.model.LibraryItemState;
import com.vmware.vsphere.client.libraryItem.model.LibraryItemValidationResult;
import com.vmware.vsphere.client.libraryItem.specs.ExportLibraryItemCompleteSpec;
import com.vmware.vsphere.client.libraryItem.specs.ExportLibraryItemProgressSpec;
import com.vmware.vsphere.client.libraryItem.specs.ExportLibraryItemSpec;
import com.vmware.vsphere.client.libraryItem.specs.ExportLibraryItemValidateSpec;
import com.vmware.vsphere.client.libraryItem.specs.ExportOVFSpec;
import com.vmware.vsphere.client.libraryItem.util.LibraryItemUtil;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import com.vmware.vsphere.client.util.vapi.VapiUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryItemExportMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(LibraryItemExportMutationProvider.class);
    private final DownloadSession _downloadSession;
    private final ExportSession _exportSession;
    private final File _downloadSessionFile;
    private final Boolean _isNativeBrowserFileTransferEnabled;
    private VapiTaskMonitor _vapiTaskMonitor;

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    public LibraryItemExportMutationProvider(DownloadSession downloadSession, File downloadSessionFile, ExportSession exportSession, FeatureStateService featureStateService) {
        this._downloadSession = downloadSession;
        this._downloadSessionFile = downloadSessionFile;
        this._exportSession = exportSession;
        this._isNativeBrowserFileTransferEnabled = featureStateService.isEnabled(Feature.NativeBrowserFileTransfer);
    }

    public OperationResult apply(URI libraryItem, ExportLibraryItemSpec spec) {
        OperationResult operationResult = new OperationResult();
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
        String sessionID = null;
        try {
            DownloadSessionModel createSpec = new DownloadSessionModel();
            createSpec.setLibraryItemId(libraryItemId);
            String clientToken = VapiUtil.newClientToken();
            sessionID = this._downloadSession.create(clientToken, createSpec);
            _logger.info((Object)String.format("Created export session with ID: %s for library item with ID: %s.", sessionID, libraryItemId));
            List filesToDownload = this._downloadSessionFile.list(sessionID);
            for (FileTypes.Info fileInfo : filesToDownload) {
                this._downloadSessionFile.prepare(sessionID, fileInfo.getName(), null);
            }
            operationResult.result = sessionID;
        }
        catch (Exception e) {
            _logger.error((Object)("Creating and preparing download session failed. spec = " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            operationResult.error = e;
        }
        if (operationResult.error == null) {
            operationResult.task = this.getTask(sessionID);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference vmMoref, ExportOVFSpec spec) {
        OperationResult operationResult = new OperationResult();
        String moref = ManagedObjectUtil.morefToString((ManagedObjectReference)vmMoref);
        ExportSessionTypes.CreateSpec createSpec = new ExportSessionTypes.CreateSpec();
        createSpec.setExportFlags(spec.getExportFlags());
        createSpec.setTargetType(ExportSessionTypes.TargetType.DOWNLOAD_TARGET);
        createSpec.setName(spec.getName());
        createSpec.setDescription(spec.getDescription());
        String clientToken = VapiUtil.newClientToken();
        ExportSessionTypes.SourceInfo sourceInfo = new ExportSessionTypes.SourceInfo();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)vmMoref, VirtualMachine.class)) {
            sourceInfo.setVmId(moref);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)vmMoref, VirtualApp.class)) {
            sourceInfo.setVappId(moref);
        }
        operationResult.result = this._exportSession.create(clientToken, sourceInfo, (Structure)createSpec);
        _logger.info((Object)String.format("Created export session with ID: %s for virtual machine moref:  %s.", operationResult.result, moref));
        return operationResult;
    }

    public ValidationResult validate(ManagedObjectReference vmMoref, ExportOVFSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        LibraryItemValidationResult result = new LibraryItemValidationResult();
        validationResult.result = result;
        ExportSessionTypes.Info info = null;
        try {
            info = this._exportSession.get(spec.sessionID);
        }
        catch (Exception e) {
            result.libraryItemState = LibraryItemState.ERROR;
            validationResult.error = e;
            _logger.error((Object)"Received the following exception while trying to create an export session:\n", (Throwable)e);
            this.safeDelete(spec);
            return validationResult;
        }
        switch (info.getState().getEnumValue()) {
            case EXPORT_READY: {
                List allFiles = info.getFiles();
                long progress = this.getTotalProgressOvfFileInfo(allFiles);
                this.safeSetProgress(spec, progress);
                result.libraryItemState = LibraryItemState.READY;
                result.endPointList = LibraryItemUtil.getOVFExportURIs(allFiles);
                List<OvfFileInfo> filesWithURL = this.getOvfFilesWithURL(allFiles);
                if (this.areFilesDownloaded(allFiles)) {
                    result.libraryItemState = LibraryItemState.COMPLETED;
                    this.safeSetProgress(spec, 100L);
                    this.safeDelete(spec);
                    break;
                }
                if (filesWithURL.size() != allFiles.size()) break;
                result.libraryItemState = LibraryItemState.MANIFEST_READY;
                result.endPointList = this.getFilesNotDownloadedYet(filesWithURL);
                break;
            }
            case EXPORT_ERROR: {
                result.libraryItemState = LibraryItemState.ERROR;
                validationResult.error = new Exception("Received a list of OVFError");
                _logger.error((Object)String.format("Received a list of OVFError: %s", info.getErrors()));
                this.safeDelete(spec);
                break;
            }
            case EXPORT_PREPARING: 
            case EXPORT_IN_PROGRESS: {
                result.libraryItemState = LibraryItemState.INITIALIZING;
                break;
            }
            default: {
                result.libraryItemState = LibraryItemState.UNKNOWN;
            }
        }
        return validationResult;
    }

    private boolean areFilesDownloaded(List<OvfFileInfo> files) {
        for (OvfFileInfo file : files) {
            if (file.getSize() <= 0L) {
                return false;
            }
            if (file.getBytesTransferred() == file.getSize()) continue;
            return false;
        }
        return true;
    }

    private long getTotalProgressOvfFileInfo(List<OvfFileInfo> files) {
        int noOfFiles = files.size();
        double slice = 100.0 / (double)noOfFiles;
        double totalProgress = 0.0;
        for (OvfFileInfo fileInfo : files) {
            long bytesTransferred = fileInfo.getBytesTransferred();
            long fileSize = fileInfo.getSize();
            double progress = fileSize <= 0L ? 0.0 : (double)bytesTransferred / (double)fileSize;
            double deltaProgress = progress * slice;
            totalProgress += deltaProgress;
        }
        return (long)totalProgress;
    }

    private void safeSetProgress(ExportOVFSpec spec, long progress) {
        try {
            this._exportSession.progress(spec.sessionID, progress);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error while setting progress for session:%s", spec.sessionID, e));
        }
    }

    private void safeDelete(ExportOVFSpec spec) {
        try {
            this._exportSession.delete(spec.sessionID);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error while deleting session:%s", spec.sessionID, e));
        }
    }

    private List<LibraryItemEndpointInfo> getFilesNotDownloadedYet(List<OvfFileInfo> filesWithURL) {
        ArrayList<LibraryItemEndpointInfo> notDownloadedYet = new ArrayList<LibraryItemEndpointInfo>();
        for (OvfFileInfo file : filesWithURL) {
            if (file.getBytesTransferred() > 0L) continue;
            notDownloadedYet.add(LibraryItemUtil.createEndpoint(file.getName(), file.getFileUrl()));
        }
        return notDownloadedYet;
    }

    private List<OvfFileInfo> getOvfFilesWithURL(List<OvfFileInfo> files) {
        ArrayList<OvfFileInfo> result = new ArrayList<OvfFileInfo>();
        for (OvfFileInfo fileInfo : files) {
            if (fileInfo.getFileUrl() == null) continue;
            result.add(fileInfo);
        }
        return result;
    }

    public ValidationResult validate(URI libraryItem, ExportLibraryItemValidateSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        try {
            LibraryItemValidationResult valResult = this.getValidationResult(spec.sessionID);
            boolean isReadyForDownload = valResult.isComplete;
            if (isReadyForDownload) {
                this._downloadSession.keepAlive(spec.sessionID, Long.valueOf(10L));
                _logger.info((Object)String.format("Session with ID: %s is prepared.", spec.sessionID));
            }
            validationResult.result = valResult;
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error while waiting for session with ID: %s to prepare files. spec = %s", spec.sessionID, ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            validationResult.error = e;
        }
        return validationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult apply(URI libraryItem, ExportLibraryItemCompleteSpec spec) {
        OperationResult operationResult = new OperationResult();
        try {
            if (spec.clientErrorMessage != null) {
                this._downloadSession.fail(spec.sessionID, spec.clientErrorMessage);
                _logger.error((Object)String.format("Session with ID: %s failed with error: %s.", spec.sessionID, spec.clientErrorMessage));
            } else if (!Boolean.TRUE.equals(spec.isCanceled)) {
                this._downloadSession.keepAlive(spec.sessionID, Long.valueOf(100L));
                _logger.info((Object)String.format("Session with ID: %s completed successfully.", spec.sessionID));
            }
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Session with ID: %s failed to complete. spec = %s", spec.sessionID, ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
            operationResult.error = e;
        }
        finally {
            this.deleteSession(spec.sessionID);
        }
        return operationResult;
    }

    public ValidationResult validate(URI libraryItem, ExportLibraryItemProgressSpec spec) {
        ValidationResult validationResult = new ValidationResult();
        try {
            if (!this._isNativeBrowserFileTransferEnabled.booleanValue()) {
                this._downloadSession.keepAlive(spec.sessionID, Long.valueOf(spec.transferProgress));
                _logger.info((Object)String.format("Session with ID: %s reported progress: %s.", spec.sessionID, spec.transferProgress));
            } else {
                validationResult.result = this.isFileDownloadComplete(spec.sessionID);
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Reporting transfer progress failed. spec = " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)e);
        }
        return validationResult;
    }

    private boolean isFileDownloadComplete(String sessionID) {
        boolean areAllFilesDownloaded = true;
        List files = this._downloadSessionFile.list(sessionID);
        int noOfFiles = files.size();
        double slice = 100.0 / (double)noOfFiles;
        double segment = slice / 100.0;
        double totalProgress = 0.0;
        for (FileTypes.Info fileInfo : files) {
            long fileSize;
            long bytesTransferred = fileInfo.getBytesTransferred();
            long l = fileSize = fileInfo.getSize() == null ? 0L : fileInfo.getSize();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("CL File download status name=" + fileInfo.getName() + ", bytTxfred=" + bytesTransferred + ", fileSize=" + fileSize));
            }
            if (fileSize > 0L) {
                double delta = (double)(bytesTransferred / fileSize) * segment;
                totalProgress += delta;
            }
            if (fileSize > 0L && fileSize == bytesTransferred) continue;
            areAllFilesDownloaded = false;
        }
        if (areAllFilesDownloaded) {
            _logger.info((Object)("Download is done, deleting the session. sessionId=" + sessionID));
            ExportLibraryItemCompleteSpec completeSpec = new ExportLibraryItemCompleteSpec();
            completeSpec.sessionID = sessionID;
            completeSpec.isCanceled = false;
            completeSpec.clientErrorMessage = null;
            this.apply(null, completeSpec);
        } else {
            this._downloadSession.keepAlive(sessionID, Long.valueOf(new Double(totalProgress * 100.0).longValue()));
            _logger.info((Object)String.format("Session with ID: %s reported progress: %s.", sessionID, totalProgress));
        }
        return areAllFilesDownloaded;
    }

    private LibraryItemValidationResult getValidationResult(String sessionID) {
        boolean areAllFilesPrepared = true;
        LibraryItemValidationResult validationResult = new LibraryItemValidationResult();
        ArrayList<LibraryItemEndpointInfo> endPointList = null;
        List files = this._downloadSessionFile.list(sessionID);
        for (FileTypes.Info fileInfo : files) {
            FileTypes.PrepareStatus currentFileState = this._downloadSessionFile.get(sessionID, fileInfo.getName()).getStatus();
            if (!FileTypes.PrepareStatus.PREPARED.equals((Object)currentFileState)) {
                areAllFilesPrepared = false;
                break;
            }
            if (!this._isNativeBrowserFileTransferEnabled.booleanValue()) continue;
            String fileName = fileInfo.getName();
            URI downloadUrl = fileInfo.getDownloadEndpoint().getUri();
            if (endPointList == null) {
                endPointList = new ArrayList<LibraryItemEndpointInfo>();
            }
            _logger.info((Object)("Download end point for source:" + fileName + ":" + downloadUrl));
            endPointList.add(LibraryItemUtil.createEndpoint(fileName, downloadUrl));
        }
        validationResult.endPointList = endPointList;
        validationResult.isComplete = areAllFilesPrepared;
        return validationResult;
    }

    private ManagedObjectReference getTask(String sessionID) {
        ManagedObjectReference task = null;
        try {
            String activationID = this.getTaskActivationId(sessionID);
            task = this._vapiTaskMonitor.waitForActivationTask(activationID, null);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Failed to retrieve task for session with ID: %s.", sessionID), (Throwable)e);
        }
        return task;
    }

    private String getTaskActivationId(String sessionID) {
        String activationID = null;
        if (sessionID != null) {
            String[] parts = sessionID.split(":");
            activationID = parts.length > 0 ? parts[0] : null;
        }
        return activationID;
    }

    private void deleteSession(String sessionID) {
        try {
            this._downloadSession.delete(sessionID);
        }
        catch (Exception sessionDeleteException) {
            _logger.error((Object)"Session delete exception.", (Throwable)sessionDeleteException);
        }
    }
}

