/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.impl;

import com.vmware.content.library.ItemModel;
import com.vmware.content.library.ItemPath;
import com.vmware.content.library.item.File;
import com.vmware.content.library.item.FileTypes;
import com.vmware.vcenter.iso.IsoPath;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LibraryItemPropertyProvider
implements PropertyProviderBean {
    private final File _fileService;
    private final IsoPath _contentLibIsoPathService;
    private final ItemPath _libraryItemPathService;
    private static final Log _logger = LogFactory.getLog(LibraryItemPropertyProvider.class);

    public LibraryItemPropertyProvider(File fileService, IsoPath contentLibraryIsoPathService, ItemPath libraryItemPathService) {
        Validate.notNull((Object)fileService, (String)"fileService null");
        this._fileService = fileService;
        this._contentLibIsoPathService = contentLibraryIsoPathService;
        this._libraryItemPathService = libraryItemPathService;
    }

    @type(value="com.vmware.content.library.Item")
    public String[] getFiles(URI libraryItem) {
        Validate.notNull((Object)libraryItem, (String)"target object is null");
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
        ArrayList<String> result = new ArrayList<String>();
        List files = this._fileService.list(libraryItemId);
        for (FileTypes.Info file : files) {
            result.add(file.getName());
        }
        return (String[])ArrayUtil.toArray(result, String.class);
    }

    @type(value="com.vmware.content.library.Item")
    public String getContentLibraryIsoPath(URI libraryItem) {
        Validate.notNull((Object)libraryItem, (String)"target object is null");
        String libraryItemId = UriSchemeUtil.getId((URI)libraryItem);
        String path = null;
        if (libraryItemId != null && StringUtils.isNotEmpty((String)libraryItemId)) {
            path = this._contentLibIsoPathService.getDatastorePath(libraryItemId);
        }
        return path;
    }

    @type(value="com.vmware.content.library.Item")
    public String getContentLibraryFriendlyIsoPath(URI libraryItem, String datastorePath) {
        String friendlyPath = null;
        try {
            ItemModel itemModel;
            if (StringUtils.isNotEmpty((String)datastorePath) && (itemModel = this._libraryItemPathService.getByDatastorePath(datastorePath)) != null) {
                friendlyPath = itemModel.getName();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error fetching friendly Content Library ISO path for " + datastorePath + ":" + e));
            return datastorePath;
        }
        return friendlyPath;
    }
}

