/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.libraryItem.specs;

import com.vmware.vim.binding.impl.vmodl.DataObjectImpl;
import com.vmware.vise.core.model.creates;
import com.vmware.vise.core.model.data;
import com.vmware.vise.core.model.optional;
import java.net.URI;

@data
@creates(value="com.vmware.content.library.Item")
public class ImportLibraryItemSpec
extends DataObjectImpl {
    private static final long serialVersionUID = 1L;
    public URI source;
    public URI target;
    public String transferType;
    public String itemName;
    @optional
    public String itemDescription;
    public boolean addManifest;
    public boolean addCertificate;
    public boolean isUpdate = false;

    public String toString() {
        return this.getStringRepresentation(this.source.toString());
    }

    public String toLogString() {
        if (this.source.getUserInfo() == null) {
            return this.toString();
        }
        StringBuilder sourceBuilder = new StringBuilder();
        sourceBuilder.append(this.source.getScheme()).append("://").append("***:***@").append(this.source.getHost()).append(this.source.getPort()).append(this.source.getPath()).append(this.source.getQuery()).append(this.source.getFragment());
        return this.getStringRepresentation(sourceBuilder.toString());
    }

    private String getStringRepresentation(String source) {
        StringBuilder builder = new StringBuilder();
        builder.append("LibraryItemImportSpec [source=").append(source).append(", target=").append(this.target).append(", itemName=").append(this.itemName).append(", transferType=").append(this.transferType).append(", itemDescription=").append(this.itemDescription).append(", addManifest=").append(this.addManifest).append(", addCertificate=").append(this.addCertificate).append("]");
        return builder.toString();
    }
}

