/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.zeppelin.cr.fs.util;

import java.util.Collection;

public class StringUtils {
    public static final String EMPTY = "";

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String nvl(String str) {
        return StringUtils.nvl(str, EMPTY);
    }

    public static String nvl(String str, String valueIfNull) {
        return str != null ? str : valueIfNull;
    }

    public static String join(String[] strings, String separator) {
        if (strings == null) {
            return null;
        }
        return StringUtils.join(strings, separator, 0, strings.length);
    }

    public static String join(String[] strings, String separator, int beginIndex, int endIndex) {
        if (strings == null) {
            return null;
        }
        int numStrings = strings.length;
        if (numStrings == 0) {
            return EMPTY;
        }
        if (beginIndex < 0 || beginIndex >= numStrings) {
            throw new IndexOutOfBoundsException("Invalid beginIndex: " + beginIndex + ". Total number of elements in array: " + numStrings);
        }
        if (endIndex < 0 || beginIndex > numStrings) {
            throw new IndexOutOfBoundsException("Invalid endIndex: " + endIndex + ". Total number of elements in array: " + numStrings);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("endIndex <= beginIndex   (" + endIndex + " <= " + beginIndex + ")");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = beginIndex; i < endIndex; ++i) {
            String s;
            if (separator != null && i > beginIndex) {
                sb.append(separator);
            }
            if ((s = strings[i]) == null) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    public static String toString(Collection<String> coll, String separator) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : coll) {
            if (separator != null) {
                if (i > 0) {
                    sb.append(separator);
                }
                ++i;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String leftPad(String str, int desiredLength, char padChar) {
        int len;
        if (str == null) {
            str = EMPTY;
        }
        if ((len = str.length()) >= desiredLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(desiredLength);
        int padLen = desiredLength - len;
        for (int i = 0; i < padLen; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String leftPad(char ch, int desiredLength, char padChar) {
        return StringUtils.leftPad(String.valueOf(ch), desiredLength, padChar);
    }

    public static String toCharacterCodes(String str, int radix) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : str.toCharArray()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(Integer.toString(ch, radix));
        }
        return sb.toString();
    }

    public static String toCharacterCodes(String str) {
        return StringUtils.toCharacterCodes(str, 16);
    }

    public static void main(String[] args) {
        System.out.println("012345".substring(1, 2));
    }
}

