/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.google.common.base.Preconditions;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileSystemUtils;

public class FileUtil {
    private static final int COPY_BUFFER_SIZE = 16384;
    private static final Log _logger = LogFactory.getLog(FileUtil.class);

    public static boolean isValidFileUri(URI uRI) {
        if (uRI == null) {
            return false;
        }
        if (!uRI.isAbsolute() || !uRI.getSchemeSpecificPart().startsWith("/")) {
            return false;
        }
        if (!"file".equals(uRI.getScheme())) {
            return false;
        }
        if (StringUtil.isNullOrEmpty(uRI.getPath())) {
            return false;
        }
        return uRI.getAuthority() == null && uRI.getQuery() == null && uRI.getFragment() == null;
    }

    public static void writeFile(@WillClose InputStream inputStream, File file) throws IOException {
        FileUtil.writeFile(inputStream, file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(@WillClose InputStream inputStream, File file, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            File file2 = file.getParentFile();
            if (bl && !file2.exists()) {
                file2.mkdirs();
            }
            bufferedInputStream = new BufferedInputStream(inputStream, 16384);
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 16384);
            while ((n = bufferedInputStream.read()) >= 0) {
                bufferedOutputStream.write(n);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close(inputStream);
            StreamUtil.close(bufferedInputStream);
            StreamUtil.close(bufferedOutputStream);
            StreamUtil.close(fileOutputStream);
            throw throwable;
        }
        StreamUtil.close(inputStream);
        StreamUtil.close(bufferedInputStream);
        StreamUtil.close(bufferedOutputStream);
        StreamUtil.close(fileOutputStream);
    }

    private static void createParentDirsIfNecessary(@Nonnull File file) throws IOException {
        assert (file != null);
        File file2 = file.getParentFile();
        if (file2.exists()) {
            return;
        }
        boolean bl = file2.mkdirs();
        if (!bl) {
            throw new IOException("Could not create the parent directories for file: " + file.getAbsolutePath());
        }
    }

    public static boolean copyFile(File file, File file2) throws IOException {
        if (!file.isFile()) {
            throw new IllegalArgumentException("Can't copy file. Source is not a file: " + file.getAbsolutePath());
        }
        FileUtil.createParentDirsIfNecessary(file2);
        Path path = file.toPath();
        Path path2 = file2.toPath();
        Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
        boolean bl = Files.isRegularFile(path2, new LinkOption[0]);
        return bl;
    }

    public static boolean copyFileUsingTempDir(File file, File file2, File file3) throws IOException {
        File file4 = new File(file3, file.getName());
        if (!FileUtil.copyFile(file, file4)) {
            return false;
        }
        return file4.renameTo(file2);
    }

    public static void writeFile(byte[] byArray, File file) throws IOException {
        FileUtil.createParentDirsIfNecessary(file);
        Path path = file.toPath();
        Files.write(path, byArray, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static void writeFile(URL uRL, File file) throws IOException {
        InputStream inputStream = uRL.openStream();
        FileUtil.writeFile(inputStream, file);
    }

    public static void writeTextFile(File file, String string) throws IOException {
        FileUtil.writeFile(string.getBytes(), file);
    }

    public static boolean deleteDir(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        for (File file2 : fileArray) {
            boolean bl = file2.isDirectory() ? FileUtil.deleteDir(file2) : file2.delete();
            if (bl) continue;
            return false;
        }
        return file.delete();
    }

    public static boolean cleanupDirs(File ... fileArray) {
        boolean bl = true;
        for (File file : fileArray) {
            bl &= FileUtil.cleanupDir(file);
        }
        return bl;
    }

    public static boolean cleanupDir(File file) {
        if (file == null) {
            _logger.warn((Object)"param folder is null");
            return false;
        }
        if (!file.isDirectory()) {
            _logger.warn((Object)("param folder is not a directory: " + file));
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        boolean bl = true;
        for (File file2 : fileArray) {
            try {
                if (file2.isDirectory()) {
                    if (FileSystemUtils.deleteRecursively((File)file2)) continue;
                    bl = false;
                    _logger.warn((Object)String.format("Unable to delete folder: %s", file2));
                    continue;
                }
                if (file2.delete()) continue;
                bl = false;
                _logger.warn((Object)String.format("Unable to delete file: %s", file2));
            }
            catch (Exception exception) {
                _logger.error((Object)("Could not delete file: " + file2), (Throwable)exception);
                bl = false;
            }
        }
        return bl;
    }

    public static byte[] readFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file is null");
        Path path = file.toPath();
        try {
            byte[] byArray = Files.readAllBytes(path);
            return byArray;
        }
        catch (Exception exception) {
            throw new IOException("Failed to read from file: " + file.getAbsolutePath(), exception);
        }
    }

    public static String readTextFile(File file) throws IOException {
        byte[] byArray = FileUtil.readFile(file);
        return new String(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String string) throws IOException {
        Properties properties;
        if (StringUtil.isNullOrEmpty(string)) {
            throw new IllegalArgumentException("The properties file path shouldn't be null or empty");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new IOException("The properties file does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new IOException("The properties file path doesn't point to a file: " + file.getAbsolutePath());
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties = FileUtil.loadProperties(fileInputStream);
        }
        catch (Throwable throwable) {
            StreamUtil.close(fileInputStream);
            throw throwable;
        }
        StreamUtil.close(fileInputStream);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(InputStream inputStream) throws IOException {
        Properties properties;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            Properties properties2 = new Properties();
            properties2.load(bufferedInputStream);
            properties = properties2;
        }
        catch (Throwable throwable) {
            StreamUtil.close(bufferedInputStream);
            throw throwable;
        }
        StreamUtil.close(bufferedInputStream);
        return properties;
    }

    public static File locateDirectory(String string) {
        if (StringUtil.isNullOrEmpty(string)) {
            String string2 = String.format("Could not locate the directory at the given path: %s", string);
            _logger.warn((Object)string2);
            return null;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            String string3 = String.format("Could not locate the directory at the given path: %s", string);
            _logger.warn((Object)string3);
            return null;
        }
        return file;
    }

    public static boolean isDirectory(String string) {
        return FileUtil.locateDirectory(string) != null;
    }
}

