/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.google.common.base.Preconditions;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtil {
    private static final Log _logger = LogFactory.getLog(PropertyUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public static Properties loadProperties(@Nonnull ClassLoader classLoader, @Nonnull String string) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classLoader is null");
        }
        if (StringUtil.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("propertiesFileName is or whitespace");
        }
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException iOException) {
                _logger.error((Object)"Failed to load the configuration properties", (Throwable)iOException);
            }
            finally {
                StreamUtil.close(inputStream);
            }
        } else {
            _logger.error((Object)("Property file " + string + " not found"));
        }
        return null;
    }

    public static int getIntProperty(@Nullable Properties properties, @Nonnull String string, int n) {
        if (StringUtil.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("propertyName is null");
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The System property '" + string + "' cannot be parsed to int: " + string2 + ". Will try to get the value from the properties file."), (Throwable)numberFormatException);
            }
        }
        if (properties != null) {
            string2 = properties.getProperty(string);
            int n3 = PropertyUtil.toInt(string2, n, string);
            return n3;
        }
        return n;
    }

    public static int getIntProperty(@Nonnull ConfigurationService configurationService, @Nonnull String string, int n) {
        String string2;
        Preconditions.checkArgument((configurationService != null ? 1 : 0) != 0, (Object)"configService is null");
        Preconditions.checkArgument((!StringUtil.isNullOrWhitespace(string) ? 1 : 0) != 0, (Object)"The property name is null or whitespace");
        try {
            string2 = configurationService.getProperty(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve property '" + string + "' from the configuration service"), (Throwable)exception);
            return n;
        }
        int n2 = PropertyUtil.toInt(string2, n, string);
        return n2;
    }

    public static long getLongProperty(@Nullable Properties properties, @Nonnull String string, long l) {
        if (StringUtil.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("propertyName is null");
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                long l2 = Long.parseLong(string2);
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The System property '" + string + "' cannot be parsed to long: " + string2 + ". Will try to get the value from the properties file."), (Throwable)numberFormatException);
            }
        }
        if (properties != null) {
            string2 = properties.getProperty(string);
            long l3 = PropertyUtil.toLong(string2, l, string);
            return l3;
        }
        return l;
    }

    public static long getLongProperty(@Nonnull ConfigurationService configurationService, @Nonnull String string, long l) {
        String string2;
        Preconditions.checkArgument((configurationService != null ? 1 : 0) != 0, (Object)"configService is null");
        Preconditions.checkArgument((!StringUtil.isNullOrWhitespace(string) ? 1 : 0) != 0, (Object)"The property name is null or whitespace");
        try {
            string2 = configurationService.getProperty(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve property '" + string + "' from the configuration service"), (Throwable)exception);
            return l;
        }
        long l2 = PropertyUtil.toLong(string2, l, string);
        return l2;
    }

    public static boolean getBooleanProperty(@Nullable Properties properties, @Nonnull String string, boolean bl) {
        Boolean bl2;
        if (StringUtil.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("propertyName is null");
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl2 = StringUtil.parseBoolean(string2);
            if (bl2 != null) {
                return bl2;
            }
            _logger.warn((Object)("The value of the system property '" + string + "' couldn't be parsed to boolean."));
        }
        if (properties != null) {
            string2 = properties.getProperty(string);
            bl2 = StringUtil.parseBoolean(string2);
            if (bl2 != null) {
                return bl2;
            }
            _logger.warn((Object)("The value of property '" + string + "' couldn't be parsed to boolean."));
        }
        return bl;
    }

    public static boolean getBooleanProperty(@Nonnull ConfigurationService configurationService, @Nonnull String string, boolean bl) {
        String string2;
        Preconditions.checkArgument((configurationService != null ? 1 : 0) != 0, (Object)"configService is null");
        Preconditions.checkArgument((!StringUtil.isNullOrWhitespace(string) ? 1 : 0) != 0, (Object)"The property name is null or whitespace");
        try {
            string2 = configurationService.getProperty(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve property '" + string + "' from the configuration service. Will use the default: " + bl), (Throwable)exception);
            return bl;
        }
        Boolean bl2 = StringUtil.parseBoolean(string2);
        if (bl2 != null) {
            return bl2;
        }
        _logger.warn((Object)("The value of property '" + string + "' couldn't be parsed to boolean. Will use the default: " + bl));
        return bl;
    }

    private static int toInt(@Nullable String string, int n, @Nonnull String string2) {
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The property '" + string2 + "' cannot be parsed to int: " + string + " Will use the default value: " + n), (Throwable)numberFormatException);
            }
        }
        return n;
    }

    private static long toLong(@Nullable String string, long l, @Nonnull String string2) {
        if (string != null) {
            try {
                long l2 = Long.parseLong(string);
                return l2;
            }
            catch (NumberFormatException numberFormatException) {
                _logger.error((Object)("The property '" + string2 + "' cannot be parsed to long: " + string + " Will use the default value: " + l), (Throwable)numberFormatException);
            }
        }
        return l;
    }
}

