/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util;

import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.io.StreamUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(ZipFile zipFile, File file) throws IOException {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            File file2 = new File(file, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                file2.mkdirs();
                continue;
            }
            file2.getParentFile().mkdirs();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                FileUtil.writeFile(inputStream, file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addFileToZip(String string, String string2, boolean bl, ZipOutputStream zipOutputStream) throws Exception {
        File file = new File(string2);
        if (file.isDirectory()) {
            ZipUtil.addFolderToZip(string, string2, bl, zipOutputStream);
            return;
        }
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(string2);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            zipOutputStream.putNextEntry(new ZipEntry(string + "/" + file.getName()));
            while ((n = bufferedInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        catch (Throwable throwable) {
            StreamUtil.close(bufferedInputStream);
            StreamUtil.close(fileInputStream);
            throw throwable;
        }
        StreamUtil.close(bufferedInputStream);
        StreamUtil.close(fileInputStream);
    }

    private static void addFolderToZip(String string, String string2, boolean bl, ZipOutputStream zipOutputStream) throws Exception {
        File file = new File(string2);
        for (String string3 : file.list()) {
            if (string.equals("")) {
                if (!bl) {
                    ZipUtil.addFileToZip(file.getName(), string2 + "/" + string3, false, zipOutputStream);
                    continue;
                }
                ZipUtil.addFileToZip("", string2 + "/" + string3, false, zipOutputStream);
                continue;
            }
            ZipUtil.addFileToZip(string + "/" + file.getName(), string2 + "/" + string3, false, zipOutputStream);
        }
    }
}

