/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.client.configuration;

import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.client.configuration.ConfigurationLocator;
import com.vmware.vise.util.common.Environment;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationLocatorImpl
implements ConfigurationLocator {
    private static final Log _logger = LogFactory.getLog(ConfigurationLocatorImpl.class);
    private static final String FILE_SEPARATOR = Environment.fileSeparator();
    private static final String FILE_NAME = "webclient.properties";
    private static final String DEFAULT_PROPERTIES = "default.properties";
    private static final String WEB_PROPERTIES_TPL = "webclient.properties.tpl";
    private String _configFile = Environment.clientAppDataFolder() + FILE_SEPARATOR + "webclient.properties";
    private Properties _defaultProps;

    @Override
    public String getConfigFilePath() {
        File file = new File(this._configFile);
        if (file.isFile()) {
            return this._configFile;
        }
        this.createWebclientPropertiesFile(file);
        return this._configFile;
    }

    @Override
    public String getConfigFolder() {
        return Environment.clientAppDataFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getDefaultProperties() {
        if (this._defaultProps == null) {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_PROPERTIES);
                if (inputStream == null) {
                    Properties properties = null;
                    return properties;
                }
                this._defaultProps = new Properties();
                this._defaultProps.load(inputStream);
            }
            catch (Exception exception) {
                _logger.debug((Object)"Default properties loading failed", (Throwable)exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return ConfigurationLocatorImpl.copyProperties(this._defaultProps);
    }

    public static Properties copyProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            properties2.put(obj, properties.get(obj));
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWebclientPropertiesFile(File file) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(WEB_PROPERTIES_TPL);
            if (inputStream != null) {
                FileUtil.writeFile(inputStream, file);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Not able to create the webclient.properties file. " + exception.getLocalizedMessage()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

