/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.concurrent.ConcurrencyUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExecutorUtil {
    private static final Log _logger = LogFactory.getLog(ExecutorUtil.class);
    public static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };

    public static void executeTasks(Collection<? extends Runnable> collection, Executor executor) throws InterruptedException {
        try {
            ExecutorUtil.executeTasks(collection, executor, -1L, null);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public static void executeTasks(Collection<? extends Runnable> collection, Executor executor, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        Object object;
        int n;
        if (executor == null) {
            throw new IllegalArgumentException("The executor shouldn't be null");
        }
        if (collection == null || (n = collection.size()) == 0) {
            _logger.warn((Object)"An empty collection of tasks specified.");
            return;
        }
        boolean bl = l > 0L && timeUnit != null;
        CountDownLatch countDownLatch = new CountDownLatch(n);
        SessionUtil.ThreadContext threadContext = null;
        Iterator<? extends Runnable> iterator = collection.iterator();
        boolean bl2 = iterator.hasNext();
        ArrayList<LatchRunnable> arrayList = new ArrayList<LatchRunnable>(collection.size());
        while (bl2) {
            Runnable runnable = iterator.next();
            object = new LatchRunnable(runnable, countDownLatch);
            arrayList.add((LatchRunnable)object);
            bl2 = iterator.hasNext();
            if (bl || bl2) {
                try {
                    if (threadContext == null) {
                        threadContext = SessionUtil.getThreadContext(true);
                    }
                    ThreadContextPropagatingTask threadContextPropagatingTask = new ThreadContextPropagatingTask((Runnable)object, threadContext);
                    executor.execute(threadContextPropagatingTask);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    ((LatchRunnable)object).run();
                }
                continue;
            }
            ((LatchRunnable)object).run();
        }
        if (bl) {
            boolean bl3 = countDownLatch.await(l, timeUnit);
            if (!bl3) {
                object = new ArrayList(5);
                for (LatchRunnable latchRunnable : arrayList) {
                    if (latchRunnable.isDone()) continue;
                    object.add(latchRunnable);
                }
                throw new TimeoutException(String.format("Tasks didn't complete within the allotted timeout: %d %s.  The tasks that timed out are: %s", new Object[]{l, timeUnit, object.toString()}));
            }
        } else {
            countDownLatch.await();
        }
    }

    public static <T> List<TaskResult<T>> executeTasks(List<? extends Callable<T>> list, Executor executor) throws InterruptedException {
        try {
            return ExecutorUtil.executeTasks(list, executor, -1L, null, false, false, true);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
    }

    public static <T> List<TaskResult<T>> executeTasks(List<? extends Callable<T>> list, Executor executor, long l, TimeUnit timeUnit, boolean bl) throws InterruptedException, TimeoutException {
        return ExecutorUtil.executeTasks(list, executor, l, timeUnit, bl, false, true);
    }

    public static List<TaskResult<Void>> executeRunnableTasks(List<? extends Runnable> list, Executor executor, long l, TimeUnit timeUnit, boolean bl, boolean bl2, boolean bl3) throws InterruptedException, TimeoutException, IllegalArgumentException, RejectedExecutionException {
        List<Callable<Void>> list2 = ExecutorUtil.toCallables(list);
        return ExecutorUtil.executeTasks(list2, executor, l, timeUnit, bl, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<TaskResult<T>> executeTasks(List<? extends Callable<T>> list, Executor executor, long l, TimeUnit timeUnit, boolean bl, boolean bl2, boolean bl3) throws InterruptedException, TimeoutException, IllegalArgumentException, RejectedExecutionException {
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2;
        int n3;
        if (executor == null) {
            throw new IllegalArgumentException("The executor shouldn't be null");
        }
        ExecutorService executorService = null;
        if (executor instanceof ExecutorService) {
            executorService = (ExecutorService)executor;
        }
        if (list == null || (n3 = list.size()) == 0) {
            _logger.warn((Object)"An empty collection of tasks specified.");
            return Collections.emptyList();
        }
        boolean bl4 = l > 0L && timeUnit != null;
        ArrayList arrayList = new ArrayList(n3);
        ArrayList<Future<T>> arrayList2 = new ArrayList<Future<T>>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(null);
            arrayList2.add(null);
        }
        List<TaskResult<T>> list2 = Collections.synchronizedList(arrayList);
        CountDownLatch countDownLatch = new CountDownLatch(n3);
        SessionUtil.ThreadContext threadContext = null;
        int n4 = n3 - 1;
        for (n2 = 0; n2 <= n4; ++n2) {
            object3 = list.get(n2);
            n = n2;
            object2 = ExecutorUtil.createLatchTask(object3, n, list2, countDownLatch);
            if (bl4 || n2 < n4) {
                try {
                    if (threadContext == null) {
                        threadContext = SessionUtil.getThreadContext(true);
                    }
                    if (executorService != null) {
                        object = new ThreadContextPropagatingTask<T>(object2, threadContext);
                        Future<T> future = executorService.submit(object);
                        arrayList2.set(n2, future);
                        continue;
                    }
                    object = new ThreadContextPropagatingTask<T>(object2, threadContext);
                    executor.execute((Runnable)object);
                    continue;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    if (bl3) {
                        ExecutorUtil.executeTaskInCurrentThread(executorService, object2, n2, arrayList2);
                        continue;
                    }
                    _logger.warn((Object)("Task '" + list.get(n2) + "' was rejected by the thread " + "pool. Will cancel all tasks from its batch."));
                    if (executorService != null) {
                        for (int i = 0; i < n3; ++i) {
                            Future future = (Future)arrayList2.get(i);
                            if (future == null) continue;
                            ExecutorUtil.cancelTask(future, list.get(i), false);
                        }
                    }
                    throw rejectedExecutionException;
                }
            }
            ExecutorUtil.executeTaskInCurrentThread(executorService, object2, n2, arrayList2);
        }
        if (bl4) {
            n2 = countDownLatch.await(l, timeUnit) ? 1 : 0;
            if (n2 == 0 && !bl) {
                if (bl2 && executorService != null) {
                    for (n4 = 0; n4 < n3; ++n4) {
                        object3 = (Future)arrayList2.get(n4);
                        if (object3 == null) continue;
                        ExecutorUtil.cancelTask(object3, list.get(n4), true);
                    }
                }
                throw new TimeoutException("Tasks didn't complete within the allowed timeout: " + l + " " + (Object)((Object)timeUnit));
            }
        } else if (executorService != null) {
            ExecutorUtil.await(arrayList2);
        } else {
            countDownLatch.await();
        }
        List<TaskResult<T>> list3 = list2;
        synchronized (list3) {
            ArrayList<TaskResult<T>> arrayList3 = new ArrayList<TaskResult<T>>(arrayList.size());
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object2 = (TaskResult)arrayList.get(i);
                object = (Future)arrayList2.get(i);
                if (object2 != null) {
                    if (object != null) {
                        object2 = ((TaskResult)object2).newTaskResultWithFuture((Future)object);
                    }
                    arrayList3.add((TaskResult<T>)object2);
                    continue;
                }
                if (bl2 && object != null) {
                    ExecutorUtil.cancelTask(object, list.get(i), true);
                }
                arrayList3.add(new TaskResult(null, new TimeoutException(), (Future)object));
            }
            return arrayList3;
        }
    }

    static <T> void await(List<Future<T>> list) {
        if (list == null) {
            return;
        }
        for (Future<T> future : list) {
            ExecutorUtil.await(future);
        }
    }

    static void await(Future<?> future) {
        if (future == null || future.isDone()) {
            return;
        }
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            _logger.error((Object)"Waiting for task completion finished with error.", (Throwable)exception);
        }
    }

    private static <T> Callable<T> createLatchTask(final @Nonnull Callable<T> callable, final int n, final @Nonnull List<TaskResult<T>> list, final @Nonnull CountDownLatch countDownLatch) {
        Callable callable2 = new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object v = callable.call();
                    list.set(n, new TaskResult(v, null, null));
                    Object v2 = v;
                    return v2;
                }
                catch (Exception exception) {
                    if (ExceptionUtil.isCausedBy(exception, InterruptedException.class) || ExceptionUtil.isCausedBy(exception, ClosedByInterruptException.class)) {
                        _logger.warn((Object)("Task '" + callable + "' was interrupted"), (Throwable)exception);
                    }
                    list.set(n, new TaskResult(null, exception, null));
                    throw exception;
                }
                catch (Error error) {
                    Exception exception = new Exception("A java.lang.Error occurred while executing a task", error);
                    list.set(n, new TaskResult(null, exception, null));
                    throw error;
                }
                finally {
                    countDownLatch.countDown();
                }
            }

            public String toString() {
                return callable.toString();
            }
        };
        return callable2;
    }

    private static <T> void executeTaskInCurrentThread(@Nullable ExecutorService executorService, @Nonnull Callable<T> callable, int n, @Nullable List<Future<T>> list) {
        if (executorService != null) {
            FutureTask<T> futureTask = new FutureTask<T>(callable);
            list.set(n, futureTask);
            futureTask.run();
        } else {
            try {
                callable.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void cancelTask(@Nonnull Future<?> future, @Nonnull Callable<?> callable, boolean bl) {
        boolean bl2 = future.cancel(true);
        if (bl2) {
            _logger.warn((Object)("Task '" + callable + "'" + (bl ? " timed out and" : "") + " was cancelled."));
        } else if (!future.isDone()) {
            _logger.warn((Object)("Task '" + callable + "'" + (bl ? " timed out but" : "") + " it could not be cancelled."));
        }
    }

    private static List<Callable<Void>> toCallables(List<? extends Runnable> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>(n);
        for (int i = 0; i < n; ++i) {
            final Runnable runnable = list.get(i);
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    runnable.run();
                    return null;
                }

                public String toString() {
                    return runnable.toString();
                }
            };
            arrayList.add(callable);
        }
        return arrayList;
    }

    private static class LatchRunnable
    implements Runnable {
        private final Runnable _runnable;
        private final CountDownLatch _latch;
        private volatile boolean _runnableExecutionComplete;

        LatchRunnable(Runnable runnable, CountDownLatch countDownLatch) {
            this._runnable = runnable;
            this._latch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this._runnable.run();
            }
            catch (RuntimeException runtimeException) {
                _logger.error((Object)("A task crashed: " + this._runnable), (Throwable)runtimeException);
            }
            finally {
                this._runnableExecutionComplete = true;
                this._latch.countDown();
            }
        }

        public boolean isDone() {
            return this._runnableExecutionComplete;
        }

        public String toString() {
            return this._runnable.toString();
        }
    }

    private static class ThreadContextPropagatingTask<T>
    implements Runnable,
    Callable<T> {
        private final Callable<T> _callable;
        private final SessionUtil.ThreadContext _threadContext;
        private final long _creationTimeInNanos = System.nanoTime();

        public ThreadContextPropagatingTask(Callable<T> callable, SessionUtil.ThreadContext threadContext) {
            if (callable == null) {
                throw new IllegalArgumentException("The Callable should not be null");
            }
            this._callable = callable;
            this._threadContext = threadContext;
        }

        public ThreadContextPropagatingTask(final Runnable runnable, SessionUtil.ThreadContext threadContext) {
            if (runnable == null) {
                throw new IllegalArgumentException("The Runnable should not be null");
            }
            this._callable = new Callable<T>(){

                @Override
                public T call() {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"A task crashed", (Throwable)exception);
                    }
                    return null;
                }
            };
            this._threadContext = threadContext;
        }

        @Override
        public T call() throws Exception {
            this.logIfWaitingThresholdIsExceeded();
            if (this._threadContext != null) {
                SessionUtil.setThreadContext(this._threadContext);
            }
            try {
                T t;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Thread " + Thread.currentThread().getName() + " is beginning execution of task " + this._callable));
                }
                T t2 = t = this._callable.call();
                return t2;
            }
            catch (Exception exception) {
                _logger.error((Object)("A task crashed: " + this._callable), (Throwable)exception);
                throw exception;
            }
            finally {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Thread " + Thread.currentThread().getName() + " finished executing task " + this._callable));
                }
                if (this._threadContext != null) {
                    SessionUtil.setThreadContext(null);
                }
            }
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void logIfWaitingThresholdIsExceeded() {
            long l = System.nanoTime() - this._creationTimeInNanos;
            if (l > ConcurrencyUtil.TASK_WAIT_TIME_THRESHOLD_IN_NANOS) {
                _logger.warn((Object)("A task waited too long to be executed: " + TimeUnit.NANOSECONDS.toMillis(l) + " ms. Task: " + this._callable.toString()));
            }
        }

        public String toString() {
            return this._callable.toString();
        }
    }

    public static final class TaskResult<T> {
        private final T _result;
        private final Exception _exception;
        private final Future<T> _future;

        private TaskResult(T t, Exception exception, Future<T> future) {
            this._result = t;
            this._exception = exception;
            this._future = future;
        }

        public T getResult() {
            return this._result;
        }

        public Exception getException() {
            return this._exception;
        }

        public Future<T> getFuture() {
            return this._future;
        }

        private TaskResult<T> newTaskResultWithFuture(Future<T> future) {
            return new TaskResult<T>(this._result, this._exception, future);
        }

        public String toString() {
            return "[result: " + this._result + ", exception: " + this._exception + "]";
        }
    }
}

