/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class InitializationMonitor {
    private final Lock _lock = new ReentrantLock();
    private final Condition _initializedOrCancelled = this._lock.newCondition();
    private boolean _isInitialized = false;
    private boolean _isCancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        this._lock.lock();
        try {
            if (this._isCancelled) {
                throw new IllegalStateException("Monitor has been cancelled");
            }
            boolean bl = this._isInitialized;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockUntilInitializedOrCancelled() {
        this._lock.lock();
        try {
            if (this._isCancelled) {
                throw new IllegalStateException("Monitor has been cancelled");
            }
            if (this._isInitialized) {
                boolean bl = true;
                return bl;
            }
            this._initializedOrCancelled.awaitUninterruptibly();
            if (this._isCancelled) {
                throw new IllegalStateException("Monitor has been cancelled");
            }
            boolean bl = this._isInitialized;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsInitialized(boolean bl) {
        this._lock.lock();
        try {
            if (this._isCancelled) {
                throw new IllegalStateException("Monitor has been cancelled");
            }
            this._isInitialized = bl;
            if (this._isInitialized) {
                this._initializedOrCancelled.signalAll();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this._lock.lock();
        try {
            this._isCancelled = true;
            this._initializedOrCancelled.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }
}

