/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ThreadPool
extends ThreadPoolExecutor {
    private final ThreadLocal<Long> _startTime = new ThreadLocal();
    private static final Log _logger = LogFactory.getLog(ThreadPool.class);
    private final AtomicLong _numTasks = new AtomicLong();
    private final AtomicLong _totalTime = new AtomicLong();

    public ThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    public ThreadPool(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        _logger.info((Object)String.format("Thread [id:%1$s, name:%2$s]: start %3$s", thread.getId(), thread.getName(), runnable.toString()));
        this._startTime.set(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        try {
            long l = System.nanoTime();
            long l2 = l - this._startTime.get();
            this._numTasks.incrementAndGet();
            this._totalTime.addAndGet(l2);
            Thread thread = Thread.currentThread();
            _logger.info((Object)String.format("Thread [id:%1$s, name:%2$s]: end %3$s, time=%4dns", thread.getId(), thread.getName(), runnable.toString(), l2));
        }
        finally {
            super.afterExecute(runnable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void terminated() {
        long l = this._numTasks.get();
        long l2 = l > 0L ? this._totalTime.get() / l : 0L;
        try {
            _logger.info((Object)String.format("Terminated: avg time=%dns", l2));
        }
        finally {
            super.terminated();
        }
    }
}

