/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.concurrent;

import com.vmware.vise.util.ExceptionUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;

public class ThreadUtil {
    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
        while ((threadGroup = threadGroup2.getParent()) != null) {
            threadGroup2 = threadGroup;
        }
        return threadGroup2;
    }

    public static Thread[] getAllThreads() {
        Thread[] threadArray;
        int n;
        ThreadGroup threadGroup = ThreadUtil.getRootThreadGroup();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int n2 = threadMXBean.getThreadCount();
        while ((n = threadGroup.enumerate(threadArray = new Thread[n2 += 100], true)) >= n2) {
        }
        threadArray = Arrays.copyOf(threadArray, n);
        return threadArray;
    }

    public static String convertAllStackTracesToString(@Nullable Map<Thread, StackTraceElement[]> map) {
        if (map == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(5000);
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n').append('\n');
            }
            String string = thread.getName();
            stringBuilder.append("Thread: \"").append(string).append('\"').append('\n');
            String string2 = ExceptionUtil.convertStackTraceElementsToString(stackTraceElementArray);
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

