/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.debug.thread;

import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadUsageDumper {
    private static final Log _logger = LogFactory.getLog(ThreadUsageDumper.class);
    private static final long THREAD_COUNT_STEP = 200L;
    private static final long FULL_DUMP_EVERY_N_ITERATIONS = 5L;
    private final ReentrantLock _lock = new ReentrantLock();
    private long _threadCountDumpTrigger = 0L;
    private long _performedThreadDumps = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpThreadsIfNeeded(ThreadMXBean threadMXBean) {
        long l = threadMXBean.getThreadCount();
        if (l < this._threadCountDumpTrigger) {
            return;
        }
        if (!this._lock.tryLock()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        try {
            long l3 = this._threadCountDumpTrigger;
            this._threadCountDumpTrigger += 200L;
            ThreadInfo[] threadInfoArray = this.getThreadInfos(threadMXBean);
            StringBuilder stringBuilder = new StringBuilder("The limit of " + l3 + " threads reached. ");
            stringBuilder.append("Next limit will be " + this._threadCountDumpTrigger + ". ");
            stringBuilder.append("Dumping all current threads:\n");
            long l4 = 0L;
            for (ThreadInfo threadInfo : threadInfoArray) {
                if (threadInfo == null) continue;
                stringBuilder.append(threadInfo.toString());
                ++l4;
            }
            long l5 = System.currentTimeMillis();
            _logger.info((Object)"------------------- DUMPING BEGIN HERE -------------------");
            _logger.info((Object)stringBuilder);
            _logger.info((Object)"------------------- DUMPING END HERE -------------------");
            _logger.info((Object)String.format("Dumping total of %d threads took: %d ms.", l4, l5 - l2));
            ++this._performedThreadDumps;
        }
        catch (Exception exception) {
            long l6 = System.currentTimeMillis();
            _logger.error((Object)("Dumping threads took: " + (l6 - l2) + " ms. and failed with error."), (Throwable)exception);
        }
        finally {
            this._lock.unlock();
        }
    }

    private ThreadInfo[] getThreadInfos(ThreadMXBean threadMXBean) {
        ThreadInfo[] threadInfoArray = null;
        if (this.isTimeForFullDump()) {
            threadInfoArray = threadMXBean.dumpAllThreads(false, false);
        } else {
            long[] lArray = threadMXBean.getAllThreadIds();
            threadInfoArray = threadMXBean.getThreadInfo(lArray);
        }
        return threadInfoArray;
    }

    private boolean isTimeForFullDump() {
        return this._performedThreadDumps % 5L == 0L;
    }
}

