/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.feature.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.feature.FeatureState;
import com.vmware.vise.util.feature.impl.AbstractFeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import org.apache.commons.lang.Validate;

public class DelegatingFeatureStateService
extends AbstractFeatureStateService {
    private static final String SETTING_NAME_LOCAL_DEVELOPMENT_MODE = "local.development";
    private final ConfigurationService _configService;
    private final AbstractFeatureStateService _featureStateService;

    public DelegatingFeatureStateService(ConfigurationService configurationService, AbstractFeatureStateService abstractFeatureStateService, AbstractFeatureStateService abstractFeatureStateService2) {
        Validate.notNull((Object)configurationService);
        Validate.notNull((Object)abstractFeatureStateService);
        Validate.notNull((Object)abstractFeatureStateService2);
        this._configService = configurationService;
        this._featureStateService = this.isInLocalDevelopmentMode() ? abstractFeatureStateService2 : abstractFeatureStateService;
    }

    @Override
    protected FeatureState getState(Feature feature) {
        return this._featureStateService.getState(feature);
    }

    private boolean isInLocalDevelopmentMode() {
        String string = this._configService.getProperty(SETTING_NAME_LOCAL_DEVELOPMENT_MODE);
        return StringUtil.parseBoolean(string, false);
    }
}

