/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.feature.impl;

import com.vmware.vise.util.feature.FeatureState;
import com.vmware.vise.util.feature.impl.AbstractFeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.io.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DevEnvFeatureStateService
extends AbstractFeatureStateService {
    private static final Log _logger = LogFactory.getLog(DevEnvFeatureStateService.class);
    private static final String FEATURE_DISABLED_VALUE = "disabled";
    private static final String FEATURE_ENABLED_VALUE = "enabled";
    private static final String CONFIG_ROOT = System.getenv("VMWARE_CFG_DIR");
    private static final File FEATURE_CONFIG_FILE = Paths.get(CONFIG_ROOT, "vsphereFeatures", "vsphereFeatures.cfg").toFile();
    private volatile Map<Feature, FeatureState> _featureStateMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureState getState(Feature feature) {
        Object object;
        Validate.notNull((Object)((Object)feature), (String)"The feature shouldn't be null");
        Map<Feature, FeatureState> map = this._featureStateMap;
        if (map == null) {
            object = this;
            synchronized (object) {
                map = this._featureStateMap;
                if (map == null) {
                    this._featureStateMap = map = this.buildFeatureStateMap();
                }
            }
        }
        if ((object = this._featureStateMap.get((Object)feature)) == null) {
            _logger.warn((Object)("Unconfigured feature: " + (Object)((Object)feature)));
            return FeatureState.DISABLED;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Feature, FeatureState> buildFeatureStateMap() {
        EnumMap<Feature, FeatureState> enumMap;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(FEATURE_CONFIG_FILE);
            properties.load(fileInputStream);
            EnumMap<Feature, FeatureState> enumMap2 = new EnumMap<Feature, FeatureState>(Feature.class);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Feature feature = this.parseFeatureName(entry.getKey().toString());
                if (feature == null) continue;
                FeatureState featureState = this.parseFeatureState(entry.getValue());
                enumMap2.put(feature, featureState);
            }
            enumMap = enumMap2;
        }
        catch (IOException iOException) {
            Map<Feature, FeatureState> map;
            try {
                _logger.warn((Object)("Error while reading config file " + FEATURE_CONFIG_FILE), (Throwable)iOException);
                map = Collections.emptyMap();
            }
            catch (Throwable throwable) {
                StreamUtil.close(fileInputStream);
                throw throwable;
            }
            StreamUtil.close(fileInputStream);
            return map;
        }
        StreamUtil.close(fileInputStream);
        return enumMap;
    }

    private Feature parseFeatureName(String string) {
        Feature feature = null;
        try {
            feature = Feature.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.warn((Object)("Unsupported feature: " + string));
        }
        return feature;
    }

    private FeatureState parseFeatureState(Object object) {
        if (FEATURE_ENABLED_VALUE.equals(object)) {
            return FeatureState.ENABLED;
        }
        if (!FEATURE_DISABLED_VALUE.equals(object)) {
            _logger.warn((Object)String.format("Unsupported feature state: '%s'. Defaulting to DISABLED.", object));
        }
        return FeatureState.DISABLED;
    }
}

