/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.feature.impl;

import com.vmware.vise.util.feature.FeatureState;
import com.vmware.vise.util.feature.impl.AbstractFeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StaticUtilityFeatureStateService
extends AbstractFeatureStateService {
    private static final Log _logger = LogFactory.getLog(StaticUtilityFeatureStateService.class);
    private volatile Map<Feature, FeatureState> _featureStateMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureState getState(Feature feature) {
        Object object;
        Validate.notNull((Object)((Object)feature), (String)"The feature shouldn't be null");
        Map<Feature, FeatureState> map = this._featureStateMap;
        if (map == null) {
            object = this;
            synchronized (object) {
                map = this._featureStateMap;
                if (map == null) {
                    this._featureStateMap = map = this.buildStatesMap();
                }
            }
        }
        if ((object = this._featureStateMap.get((Object)feature)) == null) {
            return FeatureState.DISABLED;
        }
        return object;
    }

    private Map<Feature, FeatureState> buildStatesMap() {
        EnumMap<Feature, FeatureState> enumMap = new EnumMap<Feature, FeatureState>(Feature.class);
        _logger.debug((Object)"Initializing FeatureState static utility");
        com.vmware.vim.featurestateswitch.FeatureState.init();
        for (Feature feature : Feature.values()) {
            String string = feature.value();
            Method method = StaticUtilityFeatureStateService.getFeatureStateMethod(string);
            if (method == null) continue;
            FeatureState featureState = FeatureState.DISABLED;
            try {
                Object object = method.invoke(null, new Object[0]);
                if (Boolean.TRUE.equals(object)) {
                    featureState = FeatureState.ENABLED;
                }
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                String string2 = "Cannot access state for feature: " + string;
                _logger.error((Object)string2, (Throwable)reflectiveOperationException);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Rerieved feature: %s = %s", new Object[]{string, featureState}));
            }
            enumMap.put(feature, featureState);
        }
        return enumMap;
    }

    private static Method getFeatureStateMethod(String string) {
        try {
            String string2 = "get" + string;
            return com.vmware.vim.featurestateswitch.FeatureState.class.getMethod(string2, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string3 = "No such feature found: " + string;
            _logger.error((Object)string3);
            return null;
        }
    }
}

