/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.http;

import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.http.NonValidatingSSLSocketFactory;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsHttpClient
implements HttpClient {
    private final org.apache.commons.httpclient.HttpClient client = new org.apache.commons.httpclient.HttpClient();
    private PostMethod _recentMethod;
    private int statusCode = -1;
    private ProtocolSocketFactory sslSocketFactory = null;
    private static final Log logger = LogFactory.getLog(CommonsHttpClient.class);

    public CommonsHttpClient() {
        this.client.getParams().setConnectionManagerTimeout(300000L);
    }

    @Override
    public void setSocketReadTimeout(int n) {
        this.client.getParams().setSoTimeout(n);
    }

    @Override
    public int getSocketReadTimeout() {
        return this.client.getParams().getSoTimeout();
    }

    @Override
    public int getSocketConnectionTimeout() {
        return this.client.getHttpConnectionManager().getParams().getConnectionTimeout();
    }

    @Override
    public void setSocketConnectionTimeout(int n) {
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(n);
    }

    @Override
    public boolean isSessionInitiated() {
        Cookie[] cookieArray = this.client.getState().getCookies();
        return cookieArray != null && cookieArray.length > 0;
    }

    @Override
    public String executeMethod(String string, Map<String, String> map, Map<String, String> map2) {
        PostMethod postMethod = new PostMethod(string);
        this.initMethod(postMethod, string, map, map2);
        try {
            this.execute(postMethod);
            String string2 = postMethod.getResponseBodyAsString();
            return string2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    @Override
    public byte[] executeMethodResponseAsBytes(String string, Map<String, String> map, Map<String, String> map2) {
        PostMethod postMethod = new PostMethod(string);
        this.initMethod(postMethod, string, map, map2);
        try {
            this.execute(postMethod);
            byte[] byArray = postMethod.getResponseBody();
            return byArray;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    @Override
    public InputStream executeMethodResponseAsStream(String string, Map<String, String> map, Map<String, String> map2, Proxy proxy) {
        PostMethod postMethod = new PostMethod(string);
        this.initMethod(postMethod, string, map, map2);
        try {
            this.execute(postMethod);
            InputStream inputStream = postMethod.getResponseBodyAsStream();
            return inputStream;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    @Override
    public InputStream executeMethodResponseAsStream(String string, Map<String, String> map, Map<String, String> map2) {
        return this.executeMethodResponseAsStream(string, map, map2, null);
    }

    @Override
    public long getContentLength() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Object getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public void setSSLSocketFactory(Object object) {
        if (object instanceof ProtocolSocketFactory) {
            this.sslSocketFactory = (ProtocolSocketFactory)object;
        }
    }

    @Override
    public Object getHostnameVerifier() {
        return null;
    }

    @Override
    public void setHostnameVerifier(Object object) {
    }

    public PostMethod getRecentMethod() {
        return this._recentMethod;
    }

    private void initMethod(PostMethod postMethod, String string, Map<String, String> map, Map<String, String> map2) {
        if (map != null) {
            for (Map.Entry<String, String> protocol : map.entrySet()) {
                postMethod.setParameter(protocol.getKey(), protocol.getValue());
            }
        }
        if (map2 != null) {
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                postMethod.setRequestHeader(entry.getKey(), entry.getValue());
            }
        }
        this._recentMethod = postMethod;
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().equals("https")) {
                if (this.sslSocketFactory == null) {
                    this.sslSocketFactory = new NonValidatingSSLSocketFactory();
                }
                Protocol protocol = new Protocol("https", this.sslSocketFactory, 443);
                Protocol.registerProtocol((String)"https", (Protocol)protocol);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execute(PostMethod postMethod) throws Exception {
        this.statusCode = -1;
        this.statusCode = this.client.executeMethod((HttpMethod)postMethod);
        if (this.statusCode != 200 && logger.isWarnEnabled()) {
            logger.warn((Object)("Execute method failed: " + postMethod.getStatusLine()));
        }
    }
}

