/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.http;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpUtil {
    public static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_COOKIE = "Cookie";
    public static final String HEADER_SET_COOKIE = "Set-Cookie";
    private static final String PATTERN_EXTRACT_CHARSET = ".*?charset=([^\"']+)";
    private static Pattern charsetPattern = Pattern.compile(".*?charset=([^\"']+)");
    private static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?");
    private static final String HTTP_PATTERN = "(?i)(http|https):";
    private static final String USERINFO_PATTERN = "([^@\\[/?#]*)";
    private static final String HOST_IPV4_PATTERN = "[^\\[/?#:]*";
    private static final String HOST_IPV6_PATTERN = "\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]";
    private static final String HOST_PATTERN = "(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*(?:\\{[^/]+?\\})?)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(?i)(http|https):(//(([^@\\[/?#]*)@)?(\\[[\\p{XDigit}\\:\\.]*[%\\p{Alnum}]*\\]|[^\\[/?#:]*)(:(\\d*(?:\\{[^/]+?\\})?))?)?([^?#]*)(\\?(.*))?");

    public static Map<String, String> getRequestHeaders(HttpServletRequest httpServletRequest, String ... stringArray) {
        String string = "^[a-zA-Z0-9-.:;=,*]*$";
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("'request' parameter must not be null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("'headerNames' parameter must not be null");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray) {
            String string3 = httpServletRequest.getHeader(string2);
            if (string3 == null) continue;
            if (string2.matches(string) && string3.matches(string)) {
                hashMap.put(string2, string3);
                continue;
            }
            throw new IllegalArgumentException("Header name and/or header value contains charecters that do not match the required pattern.");
        }
        return hashMap;
    }

    public static String getContentCharSet(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = charsetPattern.matcher(string);
        if (matcher.find() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        return null;
    }

    public static boolean isSameOrigin(HttpServletRequest httpServletRequest) {
        ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(httpServletRequest);
        String string = servletServerHttpRequest.getHeaders().getFirst("Origin");
        if (string == null) {
            return true;
        }
        UriComponents uriComponents = HttpUtil.fromHttpRequest((HttpRequest)servletServerHttpRequest).build();
        UriComponents uriComponents2 = HttpUtil.fromHttpUrl(string).build();
        return uriComponents.getHost().equals(uriComponents2.getHost()) && HttpUtil.getPort(uriComponents) == HttpUtil.getPort(uriComponents2);
    }

    public static UriComponentsBuilder fromHttpRequest(HttpRequest httpRequest) {
        URI uRI = httpRequest.getURI();
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)uRI);
        String string = uRI.getScheme();
        Object object = uRI.getHost();
        int n = uRI.getPort();
        String string2 = httpRequest.getHeaders().getFirst("Forwarded");
        if (StringUtils.hasText((String)string2)) {
            String string3 = StringUtils.commaDelimitedListToStringArray((String)string2)[0];
            Matcher matcher = FORWARDED_HOST_PATTERN.matcher(string3);
            if (matcher.find()) {
                object = matcher.group(1).trim();
            }
            if ((matcher = FORWARDED_PROTO_PATTERN.matcher(string3)).find()) {
                string = matcher.group(1).trim();
            }
        } else {
            String[] stringArray;
            Object object2;
            Object object3;
            String string4 = httpRequest.getHeaders().getFirst("X-Forwarded-Host");
            if (StringUtils.hasText((String)string4)) {
                object3 = StringUtils.commaDelimitedListToStringArray((String)string4);
                object2 = object3[0];
                if (object2.contains(":")) {
                    stringArray = StringUtils.split((String)object2, (String)":");
                    object = stringArray[0];
                    n = Integer.parseInt(stringArray[1]);
                } else {
                    object = object2;
                    n = -1;
                }
            }
            if (StringUtils.hasText((String)(object3 = httpRequest.getHeaders().getFirst("X-Forwarded-Port")))) {
                object2 = StringUtils.commaDelimitedListToStringArray((String)object3);
                n = Integer.parseInt(object2[0]);
            }
            if (StringUtils.hasText((String)(object2 = httpRequest.getHeaders().getFirst("X-Forwarded-Proto")))) {
                stringArray = StringUtils.commaDelimitedListToStringArray((String)object2);
                String string5 = stringArray[0];
                if (!StringUtils.hasText((String)object3) && string5.equals("https") && string.equals("http")) {
                    n = 443;
                }
                string = string5;
            }
        }
        uriComponentsBuilder.scheme(string);
        uriComponentsBuilder.host((String)object);
        uriComponentsBuilder.port(-1);
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            uriComponentsBuilder.port(n);
        }
        return uriComponentsBuilder;
    }

    private static int getPort(UriComponents uriComponents) {
        int n = uriComponents.getPort();
        if (n == -1) {
            if ("http".equals(uriComponents.getScheme()) || "ws".equals(uriComponents.getScheme())) {
                n = 80;
            } else if ("https".equals(uriComponents.getScheme()) || "wss".equals(uriComponents.getScheme())) {
                n = 443;
            }
        }
        return n;
    }

    private static UriComponentsBuilder fromHttpUrl(String string) {
        Assert.notNull((Object)string, (String)"HTTP URL must not be null");
        Matcher matcher = HTTP_URL_PATTERN.matcher(string);
        if (matcher.matches()) {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.newInstance();
            String string2 = matcher.group(1);
            uriComponentsBuilder.scheme(string2 != null ? string2.toLowerCase() : null);
            uriComponentsBuilder.userInfo(matcher.group(4));
            String string3 = matcher.group(5);
            if (StringUtils.hasLength((String)string2) && !StringUtils.hasLength((String)string3)) {
                throw new IllegalArgumentException("[" + string + "] is not a valid HTTP URL");
            }
            uriComponentsBuilder.host(string3);
            String string4 = matcher.group(7);
            if (StringUtils.hasLength((String)string4)) {
                uriComponentsBuilder.port(Integer.parseInt(string4));
            }
            uriComponentsBuilder.path(matcher.group(8));
            uriComponentsBuilder.query(matcher.group(10));
            return uriComponentsBuilder;
        }
        throw new IllegalArgumentException("[" + string + "] is not a valid HTTP URL");
    }
}

