/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.i18n;

import com.vmware.vise.util.i18n.UTF8Control;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceManager {
    private static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    private ArrayList<Locale> _localeChain = null;
    private static ResourceManager _defaultResourceManager = null;

    ResourceManager(Locale[] localeArray) {
        this.setLocaleChain(localeArray);
    }

    public static ResourceManager getDefaultResourceManager() {
        if (_defaultResourceManager == null) {
            _defaultResourceManager = new ResourceManager(null);
        }
        return _defaultResourceManager;
    }

    public String getString(String string, String string2, ClassLoader classLoader) {
        String string3 = null;
        int n = this._localeChain.size();
        for (int i = 0; i < n && string3 == null; ++i) {
            try {
                Locale locale = this._localeChain.get(i);
                ResourceBundle resourceBundle = null;
                resourceBundle = classLoader == null ? ResourceBundle.getBundle(string, locale, new UTF8Control()) : ResourceBundle.getBundle(string, locale, classLoader, new UTF8Control());
                string3 = resourceBundle.getString(string2);
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public String getString(String string, String string2, String[] stringArray, ClassLoader classLoader) {
        String string3 = this.getString(string, string2, classLoader);
        if (stringArray != null && stringArray.length > 0) {
            string3 = MessageFormat.format(string3, stringArray);
        }
        return string3;
    }

    public void setLocaleChain(Locale[] localeArray) {
        this._localeChain = new ArrayList(2);
        if (localeArray == null) {
            this._localeChain.add(DEFAULT_LOCALE);
            return;
        }
        for (int i = 0; i < localeArray.length; ++i) {
            Locale locale = localeArray[i];
            if (this._localeChain.contains(locale)) continue;
            this._localeChain.add(locale);
        }
        if (!this._localeChain.contains(DEFAULT_LOCALE)) {
            this._localeChain.add(DEFAULT_LOCALE);
        }
    }
}

