/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.i18n.json;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.I18nManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.impl.PropertySerializerMap;

public class BeanPropertyWriterEx
extends BeanPropertyWriter {
    private static final Log _logger = LogFactory.getLog(BeanPropertyWriterEx.class);
    private static final Pattern RESOURCE_REG_EX = Pattern.compile("#\\{(\\w+)(\\.\\w+)*:?(\\w+)(\\.\\w+)*\\}");
    private static final String VARIABLE_TOKEN_PATTERN_PREFIX = "#\\{";
    private static final String VARIABLE_TOKEN_PATTERN_SUFFIX = "\\}";
    static I18nManager i18nManager;

    public BeanPropertyWriterEx(BeanPropertyWriter beanPropertyWriter) {
        super(beanPropertyWriter, beanPropertyWriter.getSerializer());
    }

    public BeanPropertyWriter withSerializer(JsonSerializer<Object> jsonSerializer) {
        return new BeanPropertyWriterEx(this);
    }

    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        JsonSerializer jsonSerializer;
        Object object2 = this.get(object);
        if (object2 == null) {
            if (!this._suppressNulls) {
                jsonGenerator.writeFieldName(this._name);
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        if (object2 == object) {
            this._reportSelfReference(object);
        }
        if (this._suppressableValue != null && this._suppressableValue.equals(object2)) {
            return;
        }
        if (object2 instanceof String) {
            object2 = BeanPropertyWriterEx.localizeValue((String)object2);
        }
        if ((jsonSerializer = this._serializer) == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        jsonGenerator.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    private static String localizeValue(String string) {
        Matcher matcher = RESOURCE_REG_EX.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        string = string.replaceAll(VARIABLE_TOKEN_PATTERN_PREFIX, "");
        string = string.replaceFirst(VARIABLE_TOKEN_PATTERN_SUFFIX, "");
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(":");
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        if (string2 == null) {
            _logger.warn((Object)("Bundle name is null, so property cannot be localized, " + string));
            return string;
        }
        if (i18nManager != null) {
            Locale locale = ResourceUtil.getLocale();
            Map<String, Map<String, String>> map = i18nManager.getResourceMap(locale);
            Map<String, String> map2 = map.get(string2);
            if (map2 == null || map2.isEmpty()) {
                _logger.warn((Object)("No or empty resource map is found for the bundle '" + string2 + "'"));
                return string3;
            }
            String string4 = map2.get(string3);
            if (StringUtil.isNullOrEmpty(string4)) {
                return string3;
            }
            return string4;
        }
        throw new IllegalStateException("No i18nManager setup.");
    }
}

