/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.util.messaging;

import com.vmware.vise.util.http.HttpUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;

public class WebSocketBasedMessagingServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 1L;

    protected StreamInbound createWebSocketInbound(String string, HttpServletRequest httpServletRequest) {
        AppMessageInbound appMessageInbound = new AppMessageInbound();
        WebSocketBasedMessagingServlet.saveClientMessageEndpoint(appMessageInbound);
        return appMessageInbound;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (HttpUtil.isSameOrigin(httpServletRequest)) {
            super.doGet(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.sendError(403);
        }
    }

    private static void saveClientMessageEndpoint(AppMessageInbound appMessageInbound) {
        HashSet<AppMessageInbound> hashSet = (HashSet<AppMessageInbound>)SessionUtil.getData("appwebsocketconnection");
        if (hashSet == null) {
            hashSet = new HashSet<AppMessageInbound>();
        }
        hashSet.add(appMessageInbound);
        SessionUtil.setData("appwebsocketconnection", hashSet);
    }

    private static void removeClientMessageEndpoint(AppMessageInbound appMessageInbound) {
        Set set = (Set)SessionUtil.getData("appwebsocketconnection");
        if (set == null || set.size() == 0) {
            return;
        }
        set.remove((Object)appMessageInbound);
    }

    public static final class AppMessageInbound
    extends MessageInbound {
        protected void onBinaryMessage(ByteBuffer byteBuffer) throws IOException {
            throw new UnsupportedOperationException("Binary message not supported");
        }

        protected void onClose(int n) {
            WebSocketBasedMessagingServlet.removeClientMessageEndpoint(this);
        }

        protected void onTextMessage(CharBuffer charBuffer) throws IOException {
        }
    }
}

